/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.filetransfer.ui;

import java.io.File;
import java.net.URL;
import org.eclipse.ecf.internal.filetransfer.ui.Messages;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StartFileDownloadDialog
extends InputDialog {
    private Text useridText;
    private Text passwordText;
    public String userid;
    public String passwd;
    public String filename;
    protected Text fileLocation;
    String filePath = this.filePath == null ? "" : this.filePath;

    public StartFileDownloadDialog(Shell parentShell, String startURL) {
        super(parentShell, Messages.getString("StartFileDownloadDialog.FileTransfer"), Messages.getString("StartFileDownloadDialog.Source"), startURL, null);
    }

    String getFullDownloadPath(String path, String fileName) {
        if (fileName == null) {
            return this.filePath;
        }
        String result = this.filePath;
        if (!result.endsWith(File.separator)) {
            result = String.valueOf(result) + File.separator;
        }
        return String.valueOf(result) + fileName;
    }

    public StartFileDownloadDialog(Shell parentShell) {
        this(parentShell, null);
    }

    Text getInputText() {
        return this.getText();
    }

    public void create() {
        super.create();
        Button okButton = this.getButton(0);
        okButton.setText(Messages.getString("StartFileDownloadDialog.DOWNLOAD_BUTTON"));
        okButton.setToolTipText(Messages.getString("StartFileDownloadDialog.DOWNLOAD_BUTTON_TOOLTIP"));
        URL url = this.validateURL();
        if (url != null) {
            String user;
            String fileName = this.getFileNameFromURL();
            if (!"".equals(fileName)) {
                this.fileLocation.setText(this.getFullDownloadPath(this.filePath, fileName));
                this.useridText.setFocus();
            }
            if ((user = url.getUserInfo()) != null) {
                this.useridText.setText(user);
                this.passwordText.setFocus();
            }
            okButton.setEnabled(true);
        } else {
            okButton.setEnabled(false);
        }
    }

    URL validateURL() {
        String text = this.getInputText().getText();
        URL result = null;
        try {
            if (!"".equals(text)) {
                result = new URL(text);
            }
        }
        catch (Exception e) {
            this.setErrorMessage(NLS.bind((String)Messages.getString("StartFileDownloadDialog.MalformedURLException"), (Object)text));
            return null;
        }
        this.setErrorMessage(null);
        return result;
    }

    String getFileNameFromURL() {
        String scp = this.getInputText().getText();
        String fileName = "";
        if (scp != null && scp.length() > 0) {
            fileName = scp.substring(scp.lastIndexOf(47) + 1);
        }
        return fileName;
    }

    String getCurrentDirectory() {
        String currentDirectory = this.fileLocation.getText();
        return currentDirectory.substring(0, currentDirectory.lastIndexOf(File.separator));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(Messages.getString("StartFileDownloadDialog.OutputFile"));
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.fileLocation = new Text(composite, 2052);
        this.fileLocation.setLayoutData((Object)new GridData(256));
        this.fileLocation.setText(this.filePath);
        this.fileLocation.setSelection(this.fileLocation.getText().length());
        Text text = this.getInputText();
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartFileDownloadDialog.this.validateURL();
            }
        });
        text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                StartFileDownloadDialog.this.fileLocation.setText(StartFileDownloadDialog.this.getFullDownloadPath(StartFileDownloadDialog.this.getCurrentDirectory(), StartFileDownloadDialog.this.getFileNameFromURL()));
                StartFileDownloadDialog.this.fileLocation.setSelection(StartFileDownloadDialog.this.fileLocation.getText().length());
            }
        });
        final Button fileBrowse = new Button(composite, 8);
        fileBrowse.setText(Messages.getString("StartFileDownloadDialog.Browse"));
        fileBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    String fileName = StartFileDownloadDialog.this.getFileNameFromURL();
                    FileDialog fd = new FileDialog(fileBrowse.getShell(), 8192);
                    fd.setText(Messages.getString("StartFileDownloadDialog.OutputFile"));
                    fd.setFileName(fileName);
                    fd.setFilterPath(StartFileDownloadDialog.this.getCurrentDirectory());
                    String fname = fd.open();
                    if (fname != null) {
                        StartFileDownloadDialog.this.fileLocation.setText(fname);
                        StartFileDownloadDialog.this.fileLocation.setSelection(StartFileDownloadDialog.this.fileLocation.getText().length());
                    }
                }
            }
        });
        label = new Label(composite, 64);
        label.setText(Messages.getString("StartFileDownloadDialog.Userid"));
        data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.useridText = new Text(composite, 2052);
        this.useridText.setLayoutData((Object)new GridData(768));
        this.useridText.setText(System.getProperty("user.name"));
        this.useridText.setSelection(this.useridText.getText().length());
        label = new Label(composite, 64);
        label.setText(Messages.getString("StartFileDownloadDialog.Password"));
        data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.passwordText = new Text(composite, 0x400804);
        this.passwordText.setLayoutData((Object)new GridData(768));
        StartFileDownloadDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.userid = this.useridText.getText();
            this.passwd = this.passwordText.getText();
            this.filename = this.fileLocation.getText();
            File f = new File(this.filename);
            if (f.exists()) {
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.getString("StartFileDownloadDialog.FILE_EXISTS_TITLE"), (String)NLS.bind((String)Messages.getString("StartFileDownloadDialog.FILE_EXISTS_MESSAGE"), (Object)this.filename))) {
                    super.buttonPressed(buttonId);
                } else {
                    this.fileLocation.setFocus();
                }
                return;
            }
        }
        super.buttonPressed(buttonId);
    }
}

