/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.eventadmin;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.ecf.internal.remoteservice.eventadmin.DefaultSerializationHandler;
import org.eclipse.ecf.remoteservice.eventadmin.serialization.SerializationHandler;
import org.osgi.service.event.Event;

public class EventMessage
implements Serializable {
    private static final long serialVersionUID = 2743430591605178391L;
    private String topic;
    private Map properties;
    private transient SerializationHandler sh = new DefaultSerializationHandler();
    private transient Event localEvent;

    public EventMessage(Event event) throws NotSerializableException {
        this.topic = event.getTopic();
        this.properties = this.createPropertiesFromEvent(event);
    }

    public EventMessage(Event event, SerializationHandler serializationHandler) throws NotSerializableException {
        this.sh = serializationHandler;
        this.topic = event.getTopic();
        this.properties = this.createPropertiesFromEvent(event);
    }

    public EventMessage(String topic, Map properties) {
        this.topic = topic;
        this.properties = properties;
    }

    protected Map createPropertiesFromEvent(Event event) throws NotSerializableException {
        String[] propertyNames = event.getPropertyNames();
        Hashtable<String, Object> ht = propertyNames == null ? new Hashtable<String, Object>(1) : new Hashtable(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            Object val = event.getProperty(propertyNames[i]);
            ht.put(propertyNames[i], this.sh.serialize(val));
            ++i;
        }
        return ht;
    }

    protected String getTopic() {
        return this.topic;
    }

    protected Map getProperties() {
        Set keySet = this.properties.keySet();
        for (Object key : keySet) {
            Object val = this.properties.get(key);
            this.properties.put(key, this.sh.deserialize(val));
        }
        return this.properties;
    }

    protected Event createLocalEvent() {
        return new Event(this.getTopic(), this.getProperties());
    }

    public synchronized Event getEvent() {
        if (this.localEvent == null) {
            this.localEvent = this.createLocalEvent();
        }
        return this.localEvent;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EventMessage[topic=");
        buffer.append(this.topic);
        buffer.append(", properties=");
        buffer.append(this.properties);
        buffer.append("]");
        return buffer.toString();
    }

    public void setSerializationHandler(SerializationHandler serializationHandler) {
        this.sh = serializationHandler;
    }
}

