/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.ClientEntry;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.CollabClient;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.part.FileEditorInput;

public class EditorCompoundContributionItem
extends CompoundContributionItem {
    private static final IContributionItem[] EMPTY = new IContributionItem[0];
    private final ImageDescriptor menuImageDescriptor = ClientPlugin.getDefault().getImageRegistry().getDescriptor("collaboration");

    public EditorCompoundContributionItem() {
    }

    public EditorCompoundContributionItem(String id) {
        super(id);
    }

    protected IFile getFileForPart(IEditorPart editorPart) {
        IEditorInput input = editorPart.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            return fei.getFile();
        }
        return null;
    }

    protected ClientEntry isConnected(IResource res) {
        if (res == null) {
            return null;
        }
        CollabClient client = CollabClient.getDefault();
        ClientEntry entry = client.isConnected(res, "ecf.generic.client");
        return entry;
    }

    protected IEditorPart getEditorPart() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        IWorkbenchPage wp = ww.getActivePage();
        if (wp == null) {
            return null;
        }
        return wp.getActiveEditor();
    }

    protected ITextSelection getSelection() {
        IEditorPart ep = this.getEditorPart();
        if (ep == null) {
            return null;
        }
        IEditorSite ws = ep.getEditorSite();
        if (ws == null) {
            return null;
        }
        ISelectionProvider sp = ws.getSelectionProvider();
        if (sp == null) {
            return null;
        }
        ISelection sel = sp.getSelection();
        if (sel == null || !(sel instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)sel;
    }

    protected IContributionItem[] getContributionItems() {
        final ITextSelection textSelection = this.getSelection();
        if (textSelection == null) {
            return EMPTY;
        }
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart == null) {
            return EMPTY;
        }
        final IFile file = this.getFileForPart(editorPart);
        if (file == null) {
            return EMPTY;
        }
        final IProject project = file.getProject();
        if (this.isConnected((IResource)project.getWorkspace().getRoot()) == null) {
            return EMPTY;
        }
        Action action = new Action(){

            public void run() {
                ClientEntry entry = EditorCompoundContributionItem.this.isConnected((IResource)project.getWorkspace().getRoot());
                if (entry == null) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.EditorCompoundContributionItem_EXCEPTION_NOT_CONNECTED_TITLE, (String)Messages.EditorCompoundContributionItem_EXCEPTION_NOT_CONNECTED_MESSAGE);
                    return;
                }
                EclipseCollabSharedObject collabsharedobject = entry.getSharedObject();
                if (collabsharedobject != null) {
                    collabsharedobject.sendOpenAndSelectForFile(null, String.valueOf(project.getName()) + "/" + file.getProjectRelativePath().toString(), textSelection.getOffset(), textSelection.getLength());
                }
            }
        };
        ClientEntry entry = this.isConnected((IResource)project.getWorkspace().getRoot());
        if (entry == null) {
            return EMPTY;
        }
        EclipseCollabSharedObject collabsharedobject = entry.getSharedObject();
        if (collabsharedobject == null) {
            return EMPTY;
        }
        action.setText(NLS.bind((String)Messages.EditorCompoundContributionItem_SHARE_SELECTION_MENU_ITEM_NAME, (Object)collabsharedobject.getWindowTitle()));
        if (this.menuImageDescriptor != null) {
            action.setImageDescriptor(this.menuImageDescriptor);
        }
        return new IContributionItem[]{new Separator(), new ActionContributionItem((IAction)action)};
    }
}

