/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimerTask;
import javax.jmdns.impl.DNSConstants;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;

public class Responder
extends TimerTask {
    private final JmDNSImpl jmDNSImpl;
    private DNSIncoming in;
    private InetAddress addr;
    private int port;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming in, InetAddress addr, int port) {
        this.jmDNSImpl = jmDNSImpl;
        this.in = in;
        this.addr = addr;
        this.port = port;
    }

    public void start() {
        int delay;
        boolean iAmTheOnlyOne = true;
        for (DNSEntry entry : this.in.getQuestions()) {
            DNSQuestion q;
            if (entry instanceof DNSQuestion && !(iAmTheOnlyOne &= (q = (DNSQuestion)entry).getType() == 33 || q.getType() == 16 || q.getType() == 1 || q.getType() == 28 || this.jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(q.getName()) || this.jmDNSImpl.getServices().containsKey(q.getName().toLowerCase()))) break;
        }
        int n = delay = iAmTheOnlyOne && !this.in.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this.in.elapseSinceArrival();
        if (delay < 0) {
            delay = 0;
        }
        this.jmDNSImpl.schedule(this, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.jmDNSImpl.getIoLock();
        synchronized (object) {
            if (this.jmDNSImpl.getPlannedAnswer() == this.in) {
                this.jmDNSImpl.setPlannedAnswer(null);
            }
            HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
            HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
            if (this.jmDNSImpl.getState() == DNSState.ANNOUNCED) {
                try {
                    boolean isUnicast = this.port != DNSConstants.MDNS_PORT;
                    block11: for (DNSEntry entry : this.in.getQuestions()) {
                        DNSRecord.Address answer;
                        int type;
                        if (!(entry instanceof DNSQuestion)) continue;
                        DNSQuestion q = (DNSQuestion)entry;
                        if (isUnicast) {
                            questions.add(q);
                        }
                        if ((type = q.getType()) == 255 || type == 33) {
                            if (this.jmDNSImpl.getLocalHost().getName().equalsIgnoreCase(q.getName())) {
                                answer = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (answer != null) {
                                    answers.add(answer);
                                }
                                if ((answer = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                    answers.add(answer);
                                }
                                type = 0;
                            } else if (this.jmDNSImpl.getServiceTypes().containsKey(q.getName().toLowerCase())) {
                                type = 12;
                            }
                        }
                        switch (type) {
                            case 1: {
                                answer = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (answer == null) break;
                                answers.add(answer);
                                break;
                            }
                            case 28: {
                                answer = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord();
                                if (answer == null) break;
                                answers.add(answer);
                                break;
                            }
                            case 12: {
                                for (ServiceInfoImpl info : this.jmDNSImpl.getServices().values()) {
                                    if (info.getState() != DNSState.ANNOUNCED || !q.getName().equalsIgnoreCase(info.getType())) continue;
                                    DNSRecord.Address answer2 = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                    if (answer2 != null) {
                                        answers.add(answer2);
                                    }
                                    if ((answer2 = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                        answers.add(answer2);
                                    }
                                    answers.add(new DNSRecord.Pointer(info.getType(), 12, 1, 3600, info.getQualifiedName()));
                                    answers.add(new DNSRecord.Service(info.getQualifiedName(), 33, 32769, 3600, info.getPriority(), info.getWeight(), info.getPort(), this.jmDNSImpl.getLocalHost().getName()));
                                    answers.add(new DNSRecord.Text(info.getQualifiedName(), 16, 32769, 3600, info.getText()));
                                }
                                if (!q.getName().equalsIgnoreCase("_services._dns-sd._udp.local.")) break;
                                Iterator serviceTypeIterator = this.jmDNSImpl.getServiceTypes().values().iterator();
                                while (serviceTypeIterator.hasNext()) {
                                    answers.add(new DNSRecord.Pointer("_services._dns-sd._udp.local.", 12, 1, 3600, (String)serviceTypeIterator.next()));
                                }
                                continue block11;
                            }
                            case 16: 
                            case 33: 
                            case 255: {
                                ServiceInfoImpl info = (ServiceInfoImpl)this.jmDNSImpl.getServices().get(q.getName().toLowerCase());
                                if (info == null || info.getState() != DNSState.ANNOUNCED) continue block11;
                                DNSRecord.Address answer3 = this.jmDNSImpl.getLocalHost().getDNS4AddressRecord();
                                if (answer3 != null) {
                                    answers.add(answer3);
                                }
                                if ((answer3 = this.jmDNSImpl.getLocalHost().getDNS6AddressRecord()) != null) {
                                    answers.add(answer3);
                                }
                                answers.add(new DNSRecord.Pointer(info.getType(), 12, 1, 3600, info.getQualifiedName()));
                                answers.add(new DNSRecord.Service(info.getQualifiedName(), 33, 32769, 3600, info.getPriority(), info.getWeight(), info.getPort(), this.jmDNSImpl.getLocalHost().getName()));
                                answers.add(new DNSRecord.Text(info.getQualifiedName(), 16, 32769, 3600, info.getText()));
                                break;
                            }
                        }
                    }
                    for (DNSRecord knownAnswer : this.in.getAnswers()) {
                        if (knownAnswer.getTtl() <= 1800) continue;
                        answers.remove(knownAnswer);
                    }
                    if (answers.size() != 0) {
                        DNSOutgoing out = null;
                        if (isUnicast) {
                            out = new DNSOutgoing(33792, false);
                        }
                        Iterator i = questions.iterator();
                        while (i.hasNext()) {
                            out.addQuestion((DNSQuestion)i.next());
                        }
                        i = answers.iterator();
                        while (i.hasNext()) {
                            out = this.jmDNSImpl.addAnswer(this.in, this.addr, this.port, out, (DNSRecord)i.next());
                        }
                        this.jmDNSImpl.send(out);
                    }
                    this.cancel();
                }
                catch (Throwable e) {
                    this.jmDNSImpl.close();
                }
            }
        }
    }
}

