/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery.ui.statusline;

import org.eclipse.ecf.discovery.ui.model.IItemStatusLineProvider;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class AdapterFactoryStatuslineProvider
implements ISelectionChangedListener {
    private ComposedAdapterFactory adapterFactory;
    private IStatusLineManager statusline;

    public AdapterFactoryStatuslineProvider(ComposedAdapterFactory anAdapterFactory, IStatusLineManager aStatusline) {
        this.adapterFactory = anAdapterFactory;
        this.statusline = aStatusline;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            EObject object = (EObject)ss.getFirstElement();
            if (object != null) {
                IItemStatusLineProvider itemStatusLineProvider = (IItemStatusLineProvider)this.adapterFactory.adapt((Notifier)object, IItemStatusLineProvider.class);
                if (itemStatusLineProvider != null) {
                    this.statusline.setMessage(itemStatusLineProvider.getStatusLineText((Object)object));
                } else {
                    IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
                    if (itemLabelProvider != null) {
                        this.statusline.setMessage(itemLabelProvider.getText((Object)object));
                    }
                }
            }
        } else {
            this.statusline.setMessage("");
        }
    }
}

