/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.datashare;

import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.identity.StringID;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelConfig;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelContainerListener;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.internal.provider.datashare.Activator;
import org.eclipse.ecf.provider.datashare.SharedObjectDatashareContainerAdapter;
import org.eclipse.ecf.provider.generic.SOContainer;

public class DatashareContainerAdapter
implements IChannelContainerAdapter {
    protected SOContainer container = null;
    protected static final int DEFAULT_TRANSACTION_WAIT = 30000;
    protected static final int SO_CREATION_ERROR = 1001;
    protected SharedObjectDatashareContainerAdapter delegate = null;
    protected ID delegateID = null;

    public DatashareContainerAdapter(SOContainer container) {
        this.container = container;
        this.initialize();
    }

    protected void initialize() {
        try {
            this.delegateID = IDFactory.getDefault().createStringID(SharedObjectDatashareContainerAdapter.class.getName());
            this.delegate = new SharedObjectDatashareContainerAdapter();
            this.container.getSharedObjectManager().addSharedObject(this.delegateID, (ISharedObject)this.delegate, null);
        }
        catch (Exception e) {
            Trace.catching((String)"org.eclipse.ecf.provider.datashare", (String)"org.eclipse.ecf.provider.datashare/debug/exceptions/catching", DatashareContainerAdapter.class, (String)"DatashareContainerAdapter.initialize", (Throwable)e);
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.datashare", 1001, "Exception initializing DatashareContainerAdapter instance", (Throwable)e));
        }
    }

    public IChannel createChannel(ID newID, IChannelListener listener, Map properties) throws ECFException {
        return this.delegate.createChannel(newID, listener, properties);
    }

    public IChannel createChannel(IChannelConfig newChannelConfig) throws ECFException {
        return this.delegate.createChannel(newChannelConfig);
    }

    public IChannel getChannel(ID channelID) {
        return this.delegate.getChannel(channelID);
    }

    public boolean removeChannel(ID channelID) {
        return this.delegate.removeChannel(channelID);
    }

    public Namespace getChannelNamespace() {
        return IDFactory.getDefault().getNamespaceByName(StringID.class.getName());
    }

    public void addListener(IChannelContainerListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(IChannelContainerListener listener) {
        this.delegate.removeListener(listener);
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.equals(IContainer.class)) {
            return this.container;
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }
}

