/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.messages.DeliverServiceMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class ProxyGenerator
extends ClassVisitor
implements Opcodes {
    private String sourceID;
    private String[] serviceInterfaceNames;
    private String implName;
    private String uri;
    private ClassWriter writer;
    private Map injections;
    private Set implemented;
    private final List superInterfaces = new ArrayList();
    private final Set visitedInterfaces = new HashSet();
    private String smartProxyClassName;
    private String smartProxyClassNameDashed;
    private boolean addLifecycleSupport;
    private static final int[] ICONST = new int[]{3, 4, 5, 6, 7, 8};
    private static final String[] BOXED_TYPE = new String[]{"ERROR", "java/lang/Boolean", "java/lang/Character", "java/lang/Byte", "java/lang/Short", "java/lang/Integer", "java/lang/Float", "java/lang/Long", "java/lang/Double"};
    private static final String[] UNBOX_METHOD = new String[]{"ERROR", "booleanValue", "charValue", "byteValue", "shortValue", "intValue", "floatValue", "longValue", "doubleValue"};
    private static final char[] CHAR_TABLE = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j'};
    private static final String REMOTING_I;
    private static final String ENDPOINT_I;
    private static final String UICOMP_I;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ch.ethz.iks.r_osgi.Remoting");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REMOTING_I = clazz.getName().replace('.', '/');
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("ch.ethz.iks.r_osgi.channels.ChannelEndpoint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ENDPOINT_I = clazz2.getName().replace('.', '/');
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("ch.ethz.iks.r_osgi.types.ServiceUIComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        UICOMP_I = clazz3.getName().replace('.', '/');
    }

    ProxyGenerator() {
        super(327680);
    }

    protected InputStream generateProxyBundle(URI service, DeliverServiceMessage deliv) throws IOException {
        this.uri = service.toString();
        this.sourceID = ProxyGenerator.generateSourceID(this.uri);
        this.implemented = new HashSet();
        this.injections = deliv.getInjections();
        byte[] bytes = deliv.getSmartProxyName() == null ? this.generateProxyClass(deliv.getInterfaceNames(), deliv.getInterfaceClass()) : this.generateProxyClass(deliv.getInterfaceNames(), deliv.getInterfaceClass(), deliv.getSmartProxyName(), deliv.getProxyClass());
        String className = this.implName.replace('/', '.');
        Manifest mf = new Manifest();
        Attributes attr = mf.getMainAttributes();
        attr.putValue("Manifest-Version", "1.0");
        attr.putValue("Created-By", "R-OSGi Proxy Generator");
        attr.putValue("Bundle-Activator", className);
        attr.putValue("Bundle-Classpath", ".");
        attr.putValue("Bundle-SymbolicName", "R-OSGi Proxy Bundle generated for Endpoint " + this.uri.toString());
        attr.putValue("Import-Package", "org.osgi.framework, ch.ethz.iks.r_osgi, ch.ethz.iks.r_osgi.types, ch.ethz.iks.r_osgi.channels" + ("".equals(deliv.getOptionalImports()) ? "" : ", " + deliv.getOptionalImports()) + ("".equals(deliv.getImports()) ? "" : ", ") + deliv.getImports());
        if (!"".equals(deliv.getExports())) {
            attr.putValue("Export-Package", deliv.getExports());
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream((OutputStream)bout, mf);
        CRC32 crc = new CRC32();
        crc.update(bytes, 0, bytes.length);
        JarEntry jarEntry = new JarEntry(String.valueOf(this.implName) + ".class");
        jarEntry.setSize(bytes.length);
        jarEntry.setCrc(crc.getValue());
        out.putNextEntry(jarEntry);
        out.write(bytes, 0, bytes.length);
        ((FilterOutputStream)out).flush();
        out.closeEntry();
        String[] injectionNames = this.injections.keySet().toArray(new String[this.injections.size()]);
        int i = 0;
        while (i < injectionNames.length) {
            String name = injectionNames[i];
            if (!name.equals(String.valueOf(this.smartProxyClassNameDashed) + ".class")) {
                byte[] rewritten;
                byte[] data = (byte[])this.injections.get(name);
                if (this.smartProxyClassNameDashed != null && name.startsWith(this.smartProxyClassNameDashed)) {
                    String rest = name.substring(this.smartProxyClassNameDashed.length());
                    name = String.valueOf(this.implName) + rest;
                    ClassReader rewriterReader = new ClassReader(data);
                    ClassWriter rewriterWriter = new ClassWriter(0);
                    rewriterReader.accept((ClassVisitor)new ClassRewriter(rewriterWriter), 2);
                    rewritten = rewriterWriter.toByteArray();
                } else {
                    rewritten = data;
                }
                crc = new CRC32();
                crc.update(rewritten, 0, rewritten.length);
                jarEntry = new JarEntry(name);
                jarEntry.setSize(rewritten.length);
                jarEntry.setCrc(crc.getValue());
                out.putNextEntry(jarEntry);
                out.write(rewritten, 0, rewritten.length);
                ((FilterOutputStream)out).flush();
                out.closeEntry();
            }
            ++i;
        }
        ((FilterOutputStream)out).flush();
        out.finish();
        out.close();
        return new ByteArrayInputStream(bout.toByteArray());
    }

    private byte[] generateProxyClass(String[] interfaceNames, byte[] interfaceClass) throws IOException {
        this.serviceInterfaceNames = interfaceNames;
        this.implName = "proxy/" + this.sourceID + "/" + interfaceNames[0].replace('.', '/') + "Impl";
        ClassReader reader = new ClassReader(interfaceClass);
        this.writer = new ClassWriter(2);
        reader.accept((ClassVisitor)this, 2);
        this.visitedInterfaces.add(interfaceNames[0].replace('.', '/'));
        this.recurseInterfaceHierarchy();
        this.serviceInterfaceNames = null;
        byte[] bytes = this.writer.toByteArray();
        return bytes;
    }

    private byte[] generateProxyClass(String[] interfaceNames, byte[] interfaceClass, String proxyName, byte[] proxyClass) throws IOException {
        this.serviceInterfaceNames = interfaceNames;
        this.implName = "proxy/" + this.sourceID + "/" + proxyName.replace('.', '/') + "Impl";
        this.smartProxyClassName = proxyName;
        this.smartProxyClassNameDashed = this.smartProxyClassName.replace('.', '/');
        ClassReader reader = new ClassReader(proxyClass);
        this.writer = new ClassWriter(2);
        reader.accept((ClassVisitor)this, 2);
        this.visitedInterfaces.add(this.smartProxyClassNameDashed);
        this.recurseInterfaceHierarchy();
        this.serviceInterfaceNames = null;
        byte[] bytes = this.writer.toByteArray();
        return bytes;
    }

    private void recurseInterfaceHierarchy() throws IOException {
        try {
            while (!this.superInterfaces.isEmpty()) {
                ClassReader reader;
                String superIface = (String)this.superInterfaces.remove(0);
                if (this.visitedInterfaces.contains(superIface)) continue;
                byte[] bytes = (byte[])this.injections.get(String.valueOf(superIface) + ".class");
                if (bytes == null) {
                    try {
                        Class<?> clazz = Class.forName(superIface.replace('/', '.'));
                        ClassLoader classLoader = clazz.getClassLoader();
                        if (classLoader == null) {
                            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                        }
                        reader = new ClassReader(classLoader.getResourceAsStream(String.valueOf(superIface) + ".class"));
                    }
                    catch (IOException ioe) {
                        throw new IOException("While processing " + superIface.replace('/', '.') + ": " + ioe.getMessage());
                    }
                } else {
                    reader = new ClassReader(bytes);
                }
                this.visitedInterfaces.add(superIface);
                reader.accept((ClassVisitor)this, 0);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (name.equals(this.smartProxyClassNameDashed) || this.smartProxyClassName == null && name.equals(this.serviceInterfaceNames[0].replace('.', '/'))) {
            MethodVisitor method;
            if (RemoteOSGiServiceImpl.PROXY_DEBUG) {
                RemoteOSGiServiceImpl.log.log(4, "creating proxy class " + this.implName);
            }
            String[] serviceInterfaces = new String[this.serviceInterfaceNames.length + 1];
            int i = 0;
            while (i < this.serviceInterfaceNames.length) {
                serviceInterfaces[i] = this.serviceInterfaceNames[i].replace('.', '/');
                ++i;
            }
            serviceInterfaces[this.serviceInterfaceNames.length] = "org/osgi/framework/BundleActivator";
            if ((access & 0x200) == 0) {
                HashSet<String> ifaces = new HashSet<String>();
                ifaces.addAll(Arrays.asList(interfaces));
                ifaces.add("org/osgi/framework/BundleActivator");
                ifaces.addAll(Arrays.asList(serviceInterfaces));
                this.writer.visit(version >= 49 && RemoteOSGiServiceImpl.IS_JAVA5 ? 49 : 46, 33, this.implName, null, superName, ifaces.toArray(new String[ifaces.size()]));
                if (Arrays.asList(interfaces).contains("ch/ethz/iks/r_osgi/SmartProxy")) {
                    this.addLifecycleSupport = true;
                }
            } else {
                this.writer.visit(version >= 49 && RemoteOSGiServiceImpl.IS_JAVA5 ? 49 : 46, 33, this.implName, null, "java/lang/Object", serviceInterfaces);
                if (RemoteOSGiServiceImpl.PROXY_DEBUG) {
                    RemoteOSGiServiceImpl.log.log(4, "Creating Proxy Bundle from Interfaces " + Arrays.asList(this.serviceInterfaceNames));
                }
                method = this.writer.visitMethod(1, "<init>", "()V", null, null);
                method.visitVarInsn(25, 0);
                method.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
                method.visitInsn(177);
                method.visitMaxs(2, 1);
                method.visitEnd();
                i = 1;
                while (i < this.serviceInterfaceNames.length) {
                    if (!this.visitedInterfaces.contains(this.serviceInterfaceNames[i])) {
                        this.superInterfaces.add(this.serviceInterfaceNames[i].replace('.', '/'));
                    }
                    ++i;
                }
            }
            FieldVisitor field = this.writer.visitField(2, "endpoint", "L" + ENDPOINT_I + ";", null, null);
            field.visitEnd();
            method = this.writer.visitMethod(1, "start", "(Lorg/osgi/framework/BundleContext;)V", null, new String[]{"java/lang/Exception"});
            method.visitCode();
            method.visitVarInsn(25, 1);
            method.visitVarInsn(25, 1);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("ch.ethz.iks.r_osgi.Remoting");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            method.visitLdcInsn((Object)clazz.getName());
            method.visitMethodInsn(185, "org/osgi/framework/BundleContext", "getServiceReference", "(Ljava/lang/String;)Lorg/osgi/framework/ServiceReference;");
            method.visitMethodInsn(185, "org/osgi/framework/BundleContext", "getService", "(Lorg/osgi/framework/ServiceReference;)Ljava/lang/Object;");
            method.visitTypeInsn(192, REMOTING_I);
            method.visitVarInsn(58, 2);
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 2);
            method.visitLdcInsn((Object)this.uri);
            method.visitMethodInsn(185, REMOTING_I, "getEndpoint", "(Ljava/lang/String;)L" + ENDPOINT_I + ";");
            method.visitFieldInsn(181, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            method.visitVarInsn(25, 0);
            method.visitFieldInsn(180, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            method.visitLdcInsn((Object)this.uri);
            method.visitVarInsn(25, 1);
            int len = this.serviceInterfaceNames.length;
            if (len < 6) {
                method.visitInsn(ICONST[this.serviceInterfaceNames.length]);
            } else {
                method.visitIntInsn(16, len);
            }
            method.visitTypeInsn(189, "java/lang/String");
            int i2 = 0;
            while (i2 < len && i2 < 6) {
                method.visitInsn(89);
                method.visitInsn(ICONST[i2]);
                method.visitLdcInsn((Object)this.serviceInterfaceNames[i2]);
                method.visitInsn(83);
                ++i2;
            }
            i2 = 6;
            while (i2 < len) {
                method.visitInsn(89);
                method.visitIntInsn(16, i2);
                method.visitLdcInsn((Object)this.serviceInterfaceNames[i2]);
                method.visitInsn(83);
                ++i2;
            }
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 0);
            method.visitFieldInsn(180, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            method.visitLdcInsn((Object)this.uri);
            method.visitMethodInsn(185, ENDPOINT_I, "getProperties", "(Ljava/lang/String;)Ljava/util/Dictionary;");
            method.visitMethodInsn(185, "org/osgi/framework/BundleContext", "registerService", "([Ljava/lang/String;Ljava/lang/Object;Ljava/util/Dictionary;)Lorg/osgi/framework/ServiceRegistration;");
            method.visitMethodInsn(185, ENDPOINT_I, "trackRegistration", "(Ljava/lang/String;Lorg/osgi/framework/ServiceRegistration;)V");
            method.visitVarInsn(25, 0);
            method.visitFieldInsn(180, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            method.visitLdcInsn((Object)this.uri);
            method.visitMethodInsn(185, ENDPOINT_I, "getProperties", "(Ljava/lang/String;)Ljava/util/Dictionary;");
            method.visitLdcInsn((Object)"service.presentation");
            method.visitMethodInsn(182, "java/util/Dictionary", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            method.visitTypeInsn(192, "java/lang/String");
            method.visitVarInsn(58, 3);
            method.visitVarInsn(25, 3);
            Label l0 = new Label();
            method.visitJumpInsn(198, l0);
            method.visitVarInsn(25, 3);
            method.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
            method.visitMethodInsn(182, "java/lang/Class", "newInstance", "()Ljava/lang/Object;");
            method.visitTypeInsn(192, UICOMP_I);
            method.visitVarInsn(58, 4);
            method.visitVarInsn(25, 4);
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(185, UICOMP_I, "initComponent", "(Ljava/lang/Object;Lorg/osgi/framework/BundleContext;)V");
            method.visitVarInsn(25, 1);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("ch.ethz.iks.r_osgi.types.ServiceUIComponent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            method.visitLdcInsn((Object)clazz2.getName());
            method.visitVarInsn(25, 4);
            method.visitVarInsn(25, 0);
            method.visitFieldInsn(180, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            method.visitLdcInsn((Object)this.uri);
            method.visitMethodInsn(185, ENDPOINT_I, "getPresentationProperties", "(Ljava/lang/String;)Ljava/util/Dictionary;");
            method.visitMethodInsn(185, "org/osgi/framework/BundleContext", "registerService", "(Ljava/lang/String;Ljava/lang/Object;Ljava/util/Dictionary;)Lorg/osgi/framework/ServiceRegistration;");
            method.visitInsn(87);
            method.visitLabel(l0);
            if (this.addLifecycleSupport) {
                method.visitVarInsn(25, 0);
                method.visitVarInsn(25, 1);
                method.visitMethodInsn(182, this.implName, "started", "(Lorg/osgi/framework/BundleContext;)V");
            }
            method.visitInsn(177);
            method.visitMaxs(7, 5);
            method.visitEnd();
            method = this.writer.visitMethod(1, "stop", "(Lorg/osgi/framework/BundleContext;)V", null, new String[]{"java/lang/Exception"});
            method.visitCode();
            method.visitVarInsn(25, 0);
            method.visitFieldInsn(180, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            method.visitLdcInsn((Object)this.uri);
            method.visitMethodInsn(185, ENDPOINT_I, "untrackRegistration", "(Ljava/lang/String;)V");
            method.visitVarInsn(25, 0);
            method.visitInsn(1);
            method.visitFieldInsn(181, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            if (this.addLifecycleSupport) {
                method.visitVarInsn(25, 0);
                method.visitVarInsn(25, 1);
                method.visitMethodInsn(182, this.implName, "stopped", "(Lorg/osgi/framework/BundleContext;)V");
            }
            method.visitInsn(177);
            method.visitMaxs(2, 2);
            method.visitEnd();
        }
        int i = 0;
        while (i < interfaces.length) {
            if (!this.visitedInterfaces.contains(interfaces[i])) {
                this.superInterfaces.add(interfaces[i]);
            }
            ++i;
        }
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.writer.visitAnnotation(this.checkRewriteDesc(desc), visible);
        return null;
    }

    public void visitAttribute(Attribute attr) {
        this.writer.visitAttribute(attr);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.writer.visitInnerClass(this.checkRewrite(name), this.checkRewrite(outerName), this.checkRewrite(innerName), access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (name.equals("endpoint")) {
            return null;
        }
        return this.writer.visitField(access, name, this.checkRewriteDesc(desc), signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.implemented.contains(String.valueOf(name) + desc)) {
            return null;
        }
        int methodAccess = access;
        if ((methodAccess & 0x400) != 0) {
            Type[] args = Type.getArgumentTypes((String)desc);
            boolean needsBoxing = false;
            MethodVisitor method = this.writer.visitMethod(methodAccess ^= 0x400, name, desc, signature, exceptions);
            method.visitVarInsn(25, 0);
            method.visitFieldInsn(180, this.implName, "endpoint", "L" + ENDPOINT_I + ";");
            method.visitLdcInsn((Object)this.uri);
            method.visitLdcInsn((Object)(String.valueOf(name) + desc));
            if (args.length < 5) {
                method.visitInsn(ICONST[args.length]);
            } else {
                method.visitIntInsn(16, args.length);
            }
            method.visitTypeInsn(189, "java/lang/Object");
            int slot = 1;
            int i = 0;
            while (i < (args.length < 5 ? args.length : 5)) {
                if (args[i].getSort() == 9 || args[i].getSort() == 10) {
                    method.visitInsn(89);
                    method.visitInsn(ICONST[i]);
                    method.visitVarInsn(25, slot);
                    method.visitInsn(83);
                    ++slot;
                } else {
                    method.visitInsn(89);
                    method.visitInsn(ICONST[i]);
                    method.visitTypeInsn(187, "ch/ethz/iks/r_osgi/types/BoxedPrimitive");
                    method.visitInsn(89);
                    method.visitVarInsn(args[i].getOpcode(21), slot);
                    method.visitMethodInsn(183, "ch/ethz/iks/r_osgi/types/BoxedPrimitive", "<init>", "(" + args[i].getDescriptor() + ")V");
                    method.visitInsn(83);
                    slot += args[i].getSize();
                    needsBoxing = true;
                }
                ++i;
            }
            i = 5;
            while (i < args.length) {
                if (args[i].getSort() == 9 || args[i].getSort() == 10) {
                    method.visitInsn(89);
                    method.visitIntInsn(16, i);
                    method.visitVarInsn(25, slot);
                    method.visitInsn(83);
                    ++slot;
                } else {
                    method.visitInsn(89);
                    method.visitIntInsn(16, i);
                    method.visitTypeInsn(187, "ch/ethz/iks/r_osgi/types/BoxedPrimitive");
                    method.visitInsn(89);
                    method.visitVarInsn(args[i].getOpcode(21), slot);
                    method.visitMethodInsn(183, "ch/ethz/iks/r_osgi/types/BoxedPrimitive", "<init>", "(" + args[i].getDescriptor() + ")V");
                    method.visitInsn(83);
                    slot += args[i].getSize();
                    needsBoxing = true;
                }
                ++i;
            }
            method.visitMethodInsn(185, ENDPOINT_I, "invokeMethod", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;");
            Type returnType = Type.getReturnType((String)desc);
            int sort = returnType.getSort();
            switch (sort) {
                case 0: {
                    method.visitInsn(87);
                    method.visitInsn(177);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    method.visitTypeInsn(192, BOXED_TYPE[sort]);
                    method.visitMethodInsn(182, BOXED_TYPE[sort], UNBOX_METHOD[sort], "()" + returnType.getDescriptor());
                    method.visitInsn(returnType.getOpcode(172));
                    break;
                }
                case 9: {
                    StringBuffer a = new StringBuffer();
                    int i2 = 0;
                    while (i2 < returnType.getDimensions()) {
                        a.append("[");
                        ++i2;
                    }
                    method.visitTypeInsn(192, String.valueOf(a.toString()) + returnType.getElementType().toString());
                    method.visitInsn(176);
                    break;
                }
                default: {
                    method.visitTypeInsn(192, returnType.getInternalName());
                    method.visitInsn(176);
                }
            }
            method.visitMaxs((args.length == 0 ? 4 : 7) + (needsBoxing ? 2 : 0), 2 + slot);
            method.visitEnd();
            this.implemented.add(String.valueOf(name) + desc);
            return null;
        }
        MethodVisitor method = this.writer.visitMethod(access, name, desc, signature, exceptions);
        this.implemented.add(String.valueOf(name) + desc);
        return new MethodRewriter(method);
    }

    public void visitEnd() {
        this.writer.visitEnd();
    }

    private static String generateSourceID(String id) {
        int pos1 = id.indexOf("://");
        char[] chars = id.substring(pos1 + 3).replace('/', '_').replace(':', '_').replace('-', '_').toCharArray();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '.') {
                buffer.append('o');
            } else if (chars[i] > '/' && chars[i] < ':') {
                buffer.append(CHAR_TABLE[chars[i] - 48]);
            } else if (chars[i] != '#') {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    String checkRewrite(String clazzName) {
        if (this.smartProxyClassNameDashed == null) {
            return clazzName;
        }
        if (clazzName == null) {
            return null;
        }
        if (clazzName.equals(this.smartProxyClassNameDashed) || clazzName.startsWith(String.valueOf(this.smartProxyClassNameDashed) + "$")) {
            String rest = clazzName.substring(this.smartProxyClassNameDashed.length());
            return String.valueOf(this.implName) + rest;
        }
        return clazzName;
    }

    String checkRewriteDesc(String desc) {
        int j;
        if (this.smartProxyClassNameDashed == null) {
            return desc;
        }
        if (desc == null) {
            return null;
        }
        String result = desc;
        int i = result.indexOf(String.valueOf(this.smartProxyClassNameDashed) + ";");
        while (i > 0) {
            j = i + this.smartProxyClassNameDashed.length();
            result = String.valueOf(result.substring(0, i)) + this.implName + result.substring(j);
            i = result.indexOf(this.smartProxyClassNameDashed, j);
        }
        i = result.indexOf(String.valueOf(this.smartProxyClassNameDashed) + "$");
        while (i > 0) {
            j = i + this.smartProxyClassNameDashed.length();
            result = String.valueOf(result.substring(0, i)) + this.implName + result.substring(j);
            i = result.indexOf(this.smartProxyClassNameDashed, j);
        }
        return result;
    }

    private final class ClassRewriter
    extends ClassVisitor {
        ClassRewriter(ClassWriter writer) {
            super(327680, (ClassVisitor)writer);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.cv.visit(version >= 49 && RemoteOSGiServiceImpl.IS_JAVA5 ? 49 : 46, access, ProxyGenerator.this.checkRewrite(name), signature, ProxyGenerator.this.checkRewrite(superName), interfaces);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.cv.visitField(access, ProxyGenerator.this.checkRewrite(name), ProxyGenerator.this.checkRewriteDesc(desc), signature, value);
            return null;
        }

        public void visitOuterClass(String owner, String name, String desc) {
            this.cv.visitOuterClass(ProxyGenerator.this.checkRewrite(owner), ProxyGenerator.this.checkRewrite(name), ProxyGenerator.this.checkRewriteDesc(desc));
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.cv.visitInnerClass(ProxyGenerator.this.checkRewrite(name), ProxyGenerator.this.checkRewrite(outerName), ProxyGenerator.this.checkRewrite(innerName), access);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if ("<init>()V".equals(String.valueOf(name) + desc)) {
                return null;
            }
            return new MethodRewriter(this.cv.visitMethod(access, name, ProxyGenerator.this.checkRewriteDesc(desc), signature, exceptions));
        }
    }

    private final class MethodRewriter
    extends MethodVisitor {
        MethodRewriter(MethodVisitor methodWriter) {
            super(327680, methodWriter);
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.mv.visitTypeInsn(opcode, ProxyGenerator.this.checkRewrite(desc));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitFieldInsn(opcode, ProxyGenerator.this.checkRewrite(owner), name, ProxyGenerator.this.checkRewriteDesc(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitMethodInsn(opcode, ProxyGenerator.this.checkRewrite(owner), name, ProxyGenerator.this.checkRewriteDesc(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.mv.visitMethodInsn(opcode, ProxyGenerator.this.checkRewrite(owner), name, ProxyGenerator.this.checkRewriteDesc(desc), itf);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.mv.visitMultiANewArrayInsn(ProxyGenerator.this.checkRewrite(desc), dims);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, ProxyGenerator.this.checkRewriteDesc(desc), signature, start, end, index);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.mv.visitAnnotation(ProxyGenerator.this.checkRewriteDesc(desc), visible);
            return null;
        }
    }
}

