/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public final class StartupPageTemplate {
    public static final String TOKEN_BACKGROUND_IMAGE = "backgroundImage";
    public static final String TOKEN_LIBRARIES = "libraries";
    public static final String TOKEN_APP_SCRIPT = "appScript";
    public static final String TOKEN_BODY = "body";
    public static final String TOKEN_TITLE = "title";
    public static final String TOKEN_HEADERS = "headers";
    public static final String TOKEN_NO_SCRIPT_MESSAGE = "noScriptMessage";
    public static final String TOKEN_NONCE_VALUE = "nonceValue";
    private final Token[] tokens;

    public StartupPageTemplate() {
        this(StartupPageTemplate.loadStatupPageTemplate());
    }

    public StartupPageTemplate(String template) {
        this.tokens = new TemplateParser(template).parse();
    }

    public void writePage(PrintWriter printWriter, VariableWriter variableValueProvider) {
        Token[] tokenArray = this.tokens;
        int n = this.tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Token token = tokenArray[n2];
            if (token.isVariable()) {
                variableValueProvider.writeVariable(printWriter, token.toString());
            } else {
                printWriter.print(token.toString());
            }
            ++n2;
        }
        printWriter.flush();
    }

    private static String loadStatupPageTemplate() {
        StringBuilder buffer = new StringBuilder();
        try {
            InputStream stream = StartupPageTemplate.class.getResourceAsStream("rwt-index.html");
            InputStreamReader streamReader = new InputStreamReader(stream, "UTF-8");
            try (BufferedReader reader = new BufferedReader(streamReader);){
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to read startup page template", ioe);
        }
        return buffer.toString();
    }

    static class TemplateParser {
        private final String template;
        private final List<Token> tokens;
        private int index;
        private boolean withinBrackets;
        private StringBuilder currentToken;

        TemplateParser(String template) {
            this.template = template;
            this.tokens = new LinkedList<Token>();
            this.currentToken = new StringBuilder();
        }

        Token[] parse() {
            while (this.index < this.template.length()) {
                if (!this.withinBrackets && this.currentCharEquals('$') && this.nextCharEquals('{')) {
                    this.pushCurrentToken();
                    this.withinBrackets = true;
                    ++this.index;
                } else if (this.withinBrackets && this.currentCharEquals('}')) {
                    this.pushCurrentToken();
                    this.withinBrackets = false;
                } else {
                    this.currentToken.append(this.currentChar());
                }
                ++this.index;
            }
            this.pushCurrentToken();
            return this.tokens.toArray(new Token[this.tokens.size()]);
        }

        private char currentChar() {
            return this.template.charAt(this.index);
        }

        private boolean currentCharEquals(char character) {
            return this.currentChar() == character;
        }

        private boolean nextCharEquals(char character) {
            return this.index + 1 < this.template.length() && this.template.charAt(this.index + 1) == character;
        }

        private void pushCurrentToken() {
            if (this.currentToken.length() > 0) {
                this.tokens.add(new Token(this.currentToken.toString(), this.withinBrackets));
                this.currentToken = new StringBuilder();
            }
        }
    }

    static class Token {
        private final String string;
        private final boolean variable;

        Token(String string, boolean variable) {
            this.string = string;
            this.variable = variable;
        }

        boolean isVariable() {
            return this.variable;
        }

        public String toString() {
            return this.string;
        }
    }

    public static interface VariableWriter {
        public void writeVariable(PrintWriter var1, String var2);
    }
}

