/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Control;

public class LayoutUtil {
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private static final int BUTTON_WIDTH = 61;

    public static GridLayout createGridLayout(int columns, int margin, int spacing) {
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = margin;
        layout.marginHeight = margin;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        return layout;
    }

    public static GridData createHorizontalFillData() {
        return new GridData(4, 2, true, false);
    }

    public static GridData createFillData() {
        return new GridData(4, 4, true, true);
    }

    public static GridData createButtonLayoutData(Control control) {
        GridData layoutData = new GridData(256);
        int minWidth = LayoutUtil.getButtonMinWidth(control.getFont());
        Point preferedSize = control.computeSize(-1, -1, true);
        layoutData.widthHint = Math.max(minWidth, preferedSize.x);
        return layoutData;
    }

    private static int getButtonMinWidth(Font font) {
        float charWidth = TextSizeUtil.getAvgCharWidth((Font)font);
        float width = charWidth * 61.0f + 2.0f;
        return (int)(width / 4.0f);
    }

    private LayoutUtil() {
    }
}

