/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCDelegate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.graphics.GCAdapter;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.widgets.Control;

class ControlGC
extends GCDelegate {
    private final Control control;
    private Color background;
    private Color foreground;
    private Font font;
    private int alpha;
    private int lineWidth;
    private int lineCap;
    private int lineJoin;
    private int lineStyle;
    private int[] lineDash;
    private Rectangle clippingRect;
    private float[] transform = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};

    ControlGC(Control control) {
        this.control = control;
        this.background = control.getBackground();
        this.foreground = control.getForeground();
        this.font = control.getFont();
        this.alpha = 255;
        this.lineWidth = 0;
        this.lineCap = 1;
        this.lineJoin = 1;
        this.lineStyle = 1;
    }

    @Override
    void setBackground(Color color) {
        if (!this.background.equals(color)) {
            GCOperation.SetProperty operation = new GCOperation.SetProperty(1, color.getRGB());
            this.addGCOperation(operation);
        }
        this.background = color;
    }

    @Override
    Color getBackground() {
        return this.background;
    }

    @Override
    void setForeground(Color color) {
        if (!this.foreground.equals(color)) {
            GCOperation.SetProperty operation = new GCOperation.SetProperty(0, color.getRGB());
            this.addGCOperation(operation);
        }
        this.foreground = color;
    }

    @Override
    Color getForeground() {
        return this.foreground;
    }

    @Override
    void setFont(Font font) {
        if (!this.font.equals(font)) {
            GCOperation.SetProperty operation = new GCOperation.SetProperty(ControlGC.cloneFontData(FontUtil.getData(font)));
            this.addGCOperation(operation);
        }
        this.font = font;
    }

    @Override
    Font getFont() {
        return this.font;
    }

    @Override
    Font getDefaultFont() {
        return this.control.getDisplay().getSystemFont();
    }

    @Override
    void setAlpha(int alpha) {
        this.alpha = alpha;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(2, alpha);
        this.addGCOperation(operation);
    }

    @Override
    int getAlpha() {
        return this.alpha;
    }

    @Override
    void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(3, lineWidth);
        this.addGCOperation(operation);
    }

    @Override
    int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    void setLineCap(int lineCap) {
        this.lineCap = lineCap;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(4, lineCap);
        this.addGCOperation(operation);
    }

    @Override
    int getLineCap() {
        return this.lineCap;
    }

    @Override
    void setLineJoin(int lineJoin) {
        this.lineJoin = lineJoin;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(5, lineJoin);
        this.addGCOperation(operation);
    }

    @Override
    int getLineJoin() {
        return this.lineJoin;
    }

    @Override
    void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        if (lineStyle != 6) {
            GCOperation.SetProperty operation = new GCOperation.SetProperty(6, lineStyle);
            this.addGCOperation(operation);
        }
    }

    @Override
    int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    void setLineDash(int[] dashes) {
        this.lineDash = dashes;
        GCOperation.SetProperty operation = new GCOperation.SetProperty(7, this.lineDash);
        this.addGCOperation(operation);
    }

    @Override
    int[] getLineDash() {
        return this.lineDash;
    }

    @Override
    void setClipping(Rectangle rectangle) {
        if (this.clippingRect != null) {
            this.addGCOperation(new GCOperation.SetClipping());
        }
        this.clippingRect = rectangle;
        if (this.clippingRect != null) {
            GCOperation.SetClipping operation = new GCOperation.SetClipping(rectangle);
            this.addGCOperation(operation);
        }
    }

    @Override
    void setClipping(Path path) {
        if (this.clippingRect != null) {
            this.addGCOperation(new GCOperation.SetClipping());
        }
        this.clippingRect = this.getClippingRectangle(path);
        if (this.clippingRect != null) {
            PathData pathData = path.getPathData();
            GCOperation.SetClipping operation = new GCOperation.SetClipping(pathData.types, pathData.points);
            this.addGCOperation(operation);
        }
    }

    @Override
    Rectangle getClipping() {
        if (this.clippingRect == null) {
            return this.control.getBounds();
        }
        return new Rectangle(this.clippingRect.x, this.clippingRect.y, this.clippingRect.width, this.clippingRect.height);
    }

    @Override
    void setTransform(float[] elements) {
        this.addGCOperation(new GCOperation.SetTransform(elements));
        this.transform = elements;
    }

    @Override
    float[] getTransform() {
        return this.transform;
    }

    @Override
    Point stringExtent(String string) {
        return TextSizeUtil.stringExtent(this.font, string);
    }

    @Override
    Point textExtent(String string, int wrapWidth) {
        return TextSizeUtil.textExtent(this.font, string, wrapWidth);
    }

    @Override
    void drawPoint(int x, int y) {
        GCOperation.DrawPoint operation = new GCOperation.DrawPoint(x, y);
        this.addGCOperation(operation);
    }

    @Override
    void drawLine(int x1, int y1, int x2, int y2) {
        GCOperation.DrawLine operation = new GCOperation.DrawLine(x1, y1, x2, y2);
        this.addGCOperation(operation);
    }

    @Override
    void drawPolyline(int[] pointArray, boolean close, boolean fill) {
        GCOperation.DrawPolyline operation = new GCOperation.DrawPolyline(pointArray, close, fill);
        this.addGCOperation(operation);
    }

    @Override
    void drawRectangle(Rectangle bounds, boolean fill) {
        GCOperation.DrawRectangle operation = new GCOperation.DrawRectangle(bounds, fill);
        this.addGCOperation(operation);
    }

    @Override
    void drawRoundRectangle(Rectangle bounds, int arcWidth, int arcHeight, boolean fill) {
        GCOperation.DrawRoundRectangle operation = new GCOperation.DrawRoundRectangle(bounds, arcWidth, arcHeight, fill);
        this.addGCOperation(operation);
    }

    @Override
    void fillGradientRectangle(Rectangle bounds, boolean vertical) {
        GCOperation.FillGradientRectangle operation = new GCOperation.FillGradientRectangle(bounds, vertical);
        this.addGCOperation(operation);
    }

    @Override
    void drawArc(Rectangle bounds, int startAngle, int arcAngle, boolean fill) {
        GCOperation.DrawArc operation = new GCOperation.DrawArc(bounds, startAngle, arcAngle, fill);
        this.addGCOperation(operation);
    }

    @Override
    void drawImage(Image image, Rectangle src, Rectangle dest, boolean simple) {
        GCOperation.DrawImage operation = new GCOperation.DrawImage(image, src, dest, simple);
        this.addGCOperation(operation);
    }

    @Override
    void drawText(String string, int x, int y, int flags) {
        GCOperation.DrawText operation = new GCOperation.DrawText(string, x, y, flags);
        this.addGCOperation(operation);
    }

    @Override
    void drawPath(Path path, boolean fill) {
        PathData pathData = path.getPathData();
        GCOperation.DrawPath operation = new GCOperation.DrawPath(pathData.types, pathData.points, fill);
        this.addGCOperation(operation);
    }

    GCAdapter getGCAdapter() {
        return this.control.getAdapter(GCAdapter.class);
    }

    private void addGCOperation(GCOperation operation) {
        GCAdapter adapter = this.getGCAdapter();
        if (adapter != null) {
            adapter.addGCOperation(operation);
        }
    }

    private static FontData cloneFontData(FontData fontData) {
        FontData result = new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
        result.setLocale(fontData.getLocale());
        return result;
    }
}

