/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.ICommandHelpService;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.IUpdateService;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.services.help.EHelpService;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolItemUpdater;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class HandledContributionItem
extends ContributionItem {
    private static final long serialVersionUID = 1L;
    private static final String ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE_PARAMETER = "org.eclipse.ui.commands.radioStateParameter";
    private static final String ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE = "org.eclipse.ui.commands.radioState";
    private static final String ORG_ECLIPSE_UI_COMMANDS_TOGGLE_STATE = "org.eclipse.ui.commands.toggleState";
    private static final String FORCE_TEXT = "FORCE_TEXT";
    private static final String ICON_URI = "iconURI";
    private static final String DISABLED_URI = "disabledURI";
    private static final String DISPOSABLE_CHECK = "IDisposable";
    private static final String WW_SUPPORT = "org.eclipse.ui.IWorkbenchWindow";
    private static final String HCI_STATIC_CONTEXT = "HCI-staticContext";
    private MHandledItem model;
    private Widget widget;
    private Listener menuItemListener;
    private LocalResourceManager localResourceManager;
    @Inject
    @Optional
    private Logger logger;
    private boolean logged = false;
    @Inject
    private ECommandService commandService;
    @Inject
    private EModelService modelService;
    @Inject
    private EBindingService bindingService;
    @Inject
    @Optional
    private IUpdateService updateService;
    @Inject
    @Optional
    private EHelpService helpService;
    @Inject
    @Optional
    private ICommandHelpService commandHelpService;
    private Runnable unreferenceRunnable;
    private ISWTResourceUtilities resUtils = null;
    private IStateListener stateListener = new IStateListener(){

        public void handleStateChange(State state, Object oldValue) {
            HandledContributionItem.this.updateState();
        }
    };
    private IMenuListener menuListener = new IMenuListener(){
        private static final long serialVersionUID = 1L;

        public void menuAboutToShow(IMenuManager manager) {
            HandledContributionItem.this.update(null);
        }
    };
    private ISafeRunnable updateRunner;
    private IEclipseContext infoContext;
    private State styleState;
    private State toggleState;
    private State radioState;

    @Inject
    void setResourceUtils(IResourceUtilities<ImageDescriptor> utils) {
        this.resUtils = (ISWTResourceUtilities)utils;
    }

    private ISafeRunnable getUpdateRunner() {
        if (this.updateRunner == null) {
            this.updateRunner = new ISafeRunnable(){

                public void run() throws Exception {
                    boolean shouldEnable = HandledContributionItem.this.canExecuteItem(null);
                    if (shouldEnable != HandledContributionItem.this.model.isEnabled()) {
                        HandledContributionItem.this.model.setEnabled(shouldEnable);
                        HandledContributionItem.this.update();
                    }
                }

                public void handleException(Throwable exception) {
                    if (!HandledContributionItem.this.logged) {
                        HandledContributionItem.this.logged = true;
                        if (HandledContributionItem.this.logger != null) {
                            HandledContributionItem.this.logger.error(exception, "Internal error during tool item enablement updating, this is only logged once per tool item.");
                        }
                    }
                }
            };
        }
        return this.updateRunner;
    }

    protected void updateItemEnablement() {
        if (!(this.model.getWidget() instanceof ToolItem)) {
            return;
        }
        ToolItem widget = (ToolItem)this.model.getWidget();
        if (widget == null || widget.isDisposed()) {
            return;
        }
        SafeRunner.run((ISafeRunnable)this.getUpdateRunner());
    }

    public void setModel(MHandledItem item) {
        this.model = item;
        this.setId(this.model.getElementId());
        this.generateCommand();
        if (this.model.getCommand() == null && this.logger != null) {
            this.logger.error("Element " + this.model.getElementId() + " invalid, no command defined.");
        }
        this.updateVisible();
    }

    private void generateCommand() {
        if (this.model.getCommand() != null && this.model.getWbCommand() == null) {
            String cmdId = this.model.getCommand().getElementId();
            if (cmdId == null) {
                Activator.log((int)4, (String)("Unable to generate parameterized command for " + this.model + ". ElementId is not allowed to be null."));
                return;
            }
            List modelParms = this.model.getParameters();
            HashMap<String, String> parameters = new HashMap<String, String>(4);
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
            ParameterizedCommand parmCmd = this.commandService.createCommand(cmdId, parameters);
            Activator.trace((String)"/trace/menus", (String)("command: " + parmCmd), null);
            if (parmCmd == null) {
                Activator.log((int)4, (String)("Unable to generate parameterized command for " + this.model + " with " + parameters));
                return;
            }
            this.model.setWbCommand(parmCmd);
            this.styleState = parmCmd.getCommand().getState("STYLE");
            this.toggleState = parmCmd.getCommand().getState(ORG_ECLIPSE_UI_COMMANDS_TOGGLE_STATE);
            this.radioState = parmCmd.getCommand().getState(ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE);
            this.updateState();
            if (this.styleState != null) {
                this.styleState.addListener(this.stateListener);
            } else if (this.toggleState != null) {
                this.toggleState.addListener(this.stateListener);
            } else if (this.radioState != null) {
                this.radioState.addListener(this.stateListener);
            }
        }
    }

    private void updateState() {
        if (this.styleState != null) {
            this.model.setSelected(((Boolean)this.styleState.getValue()).booleanValue());
        } else if (this.toggleState != null) {
            this.model.setSelected(((Boolean)this.toggleState.getValue()).booleanValue());
        } else if (this.radioState != null && this.model.getWbCommand() != null) {
            ParameterizedCommand c = this.model.getWbCommand();
            Object parameter = c.getParameterMap().get(ORG_ECLIPSE_UI_COMMANDS_RADIO_STATE_PARAMETER);
            String value = (String)this.radioState.getValue();
            this.model.setSelected(value != null && value.equals(parameter));
        }
    }

    public void fill(Menu menu, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        int style = 8;
        if (this.model.getType() == ItemType.PUSH) {
            style = 8;
        } else if (this.model.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.model.getType() == ItemType.RADIO) {
            style = 16;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(menu, style, index) : new MenuItem(menu, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        item.addListener(28, this.getItemListener());
        this.widget = item;
        this.model.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.model);
        this.update(null);
        if (this.updateService != null) {
            this.unreferenceRunnable = this.updateService.registerElementForUpdate(this.model.getWbCommand(), (MItem)this.model);
        }
    }

    public void fill(ToolBar parent, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        boolean isDropdown = false;
        if (this.model instanceof MToolItem) {
            MMenu menu = ((MToolItem)this.model).getMenu();
            isDropdown = menu != null;
        }
        int style = 8;
        if (isDropdown) {
            style = 4;
        } else if (this.model.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.model.getType() == ItemType.RADIO) {
            style = 16;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, style, index) : new ToolItem(parent, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        this.widget = item;
        this.model.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.model);
        ToolItemUpdater updater = this.getUpdater();
        if (updater != null) {
            updater.registerItem(this);
        }
        this.update(null);
        this.hookCheckListener();
        if (this.updateService != null) {
            this.unreferenceRunnable = this.updateService.registerElementForUpdate(this.model.getWbCommand(), (MItem)this.model);
        }
    }

    private void hookCheckListener() {
        if (this.model.getType() != ItemType.CHECK) {
            return;
        }
        Object obj = this.model.getTransientData().get(ItemType.CHECK.toString());
        if (obj instanceof IContextFunction) {
            IEclipseContext context = this.getContext((MUIElement)this.model);
            IEclipseContext staticContext = this.getStaticContext(null);
            staticContext.set(MPart.class, (Object)((MPart)context.get(MPart.class)));
            staticContext.set(WW_SUPPORT, context.get(WW_SUPPORT));
            IContextFunction func = (IContextFunction)obj;
            obj = func.compute(staticContext, null);
            if (obj != null) {
                this.model.getTransientData().put(DISPOSABLE_CHECK, obj);
            }
        }
    }

    private void unhookCheckListener() {
        if (this.model.getType() != ItemType.CHECK) {
            return;
        }
        Object obj = this.model.getTransientData().remove(DISPOSABLE_CHECK);
        if (obj == null) {
            return;
        }
        ((Runnable)obj).run();
    }

    private void updateVisible() {
        this.setVisible(this.model.isVisible());
        IContributionManager parent = this.getParent();
        if (parent != null) {
            parent.markDirty();
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        this.updateIcons();
        if (this.widget instanceof MenuItem) {
            this.updateMenuItem();
        } else if (this.widget instanceof ToolItem) {
            this.updateToolItem();
        }
    }

    private void updateMenuItem() {
        MenuItem item = (MenuItem)this.widget;
        String text = this.model.getLocalizedLabel();
        ParameterizedCommand parmCmd = this.model.getWbCommand();
        String keyBindingText = null;
        if (parmCmd != null) {
            TriggerSequence binding;
            if (text == null || text.isEmpty()) {
                text = this.model.getCommand().getLocalizedCommandName();
            }
            if (this.bindingService != null && (binding = this.bindingService.getBestSequenceFor(parmCmd)) != null) {
                keyBindingText = binding.format();
            }
        }
        if (text != null) {
            int idx;
            String mnemonics;
            if (this.model instanceof MMenuElement && (mnemonics = ((MMenuElement)this.model).getMnemonics()) != null && !mnemonics.isEmpty() && (idx = text.indexOf(mnemonics)) != -1) {
                text = String.valueOf(text.substring(0, idx)) + '&' + text.substring(idx);
            }
            if (keyBindingText == null) {
                item.setText(text);
            } else {
                item.setText(String.valueOf(text) + '\t' + keyBindingText);
            }
        } else {
            item.setText("");
        }
        item.setSelection(this.model.isSelected());
        item.setEnabled(this.model.isEnabled());
    }

    private void updateToolItem() {
        ToolItem item = (ToolItem)this.widget;
        if (item.getImage() == null || this.model.getTags().contains(FORCE_TEXT)) {
            String text = this.model.getLocalizedLabel();
            if (text == null || text.length() == 0) {
                MCommand command = this.model.getCommand();
                if (command == null) {
                    item.setText("UnLabled");
                } else {
                    item.setText(command.getLocalizedCommandName());
                }
            } else {
                item.setText(text);
            }
        } else {
            item.setText("");
        }
        String tooltip = this.getToolTipText();
        item.setToolTipText(tooltip);
        item.setSelection(this.model.isSelected());
        item.setEnabled(this.model.isEnabled());
    }

    private String getToolTipText() {
        TriggerSequence sequence;
        String text = this.model.getLocalizedTooltip();
        ParameterizedCommand parmCmd = this.model.getWbCommand();
        if (parmCmd == null) {
            this.generateCommand();
            parmCmd = this.model.getWbCommand();
        }
        if (parmCmd != null && text == null) {
            try {
                text = parmCmd.getName();
            }
            catch (NotDefinedException notDefinedException) {
                return null;
            }
        }
        if ((sequence = this.bindingService.getBestSequenceFor(parmCmd)) != null) {
            text = String.valueOf(text) + " (" + sequence.format() + ')';
        }
        return text;
    }

    private void updateIcons() {
        if (!(this.widget instanceof Item)) {
            return;
        }
        Item item = (Item)this.widget;
        String iconURI = this.model.getIconURI() != null ? this.model.getIconURI() : "";
        String disabledURI = this.getDisabledIconURI((MItem)this.model);
        Object disabledData = item.getData(DISABLED_URI);
        if (disabledData == null) {
            disabledData = "";
        }
        if (!iconURI.equals(item.getData(ICON_URI)) || !disabledURI.equals(disabledData)) {
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
            Image iconImage = this.getImage(iconURI, resourceManager);
            item.setImage(iconImage);
            item.setData(ICON_URI, (Object)iconURI);
            if (item instanceof ToolItem) {
                iconImage = this.getImage(disabledURI, resourceManager);
                ((ToolItem)item).setDisabledImage(iconImage);
                item.setData(DISABLED_URI, (Object)disabledURI);
            }
            this.disposeOldImages();
            this.localResourceManager = resourceManager;
        }
    }

    private String getDisabledIconURI(MItem toolItem) {
        Object obj = toolItem.getTransientData().get("e4_disabled_icon_image_key");
        return obj instanceof String ? (String)obj : "";
    }

    private Image getImage(String iconURI, LocalResourceManager resourceManager) {
        ImageDescriptor iconDescriptor;
        Image image = null;
        if (iconURI != null && iconURI.length() > 0 && (iconDescriptor = (ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI))) != null) {
            try {
                image = resourceManager.createImage(iconDescriptor);
            }
            catch (DeviceResourceException e) {
                iconDescriptor = ImageDescriptor.getMissingImageDescriptor();
                image = resourceManager.createImage(iconDescriptor);
                Activator.trace((String)"/trace/menus", (String)("failed to create image " + iconURI), (Throwable)e);
            }
        }
        return image;
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){
                private static final long serialVersionUID = 1L;

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            HandledContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: 
                        case 14: {
                            if (event.widget == null) break;
                            HandledContributionItem.this.handleWidgetSelection(event);
                            break;
                        }
                        case 28: {
                            HandledContributionItem.this.handleHelpRequest();
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            if (this.unreferenceRunnable != null) {
                this.unreferenceRunnable.run();
                this.unreferenceRunnable = null;
            }
            this.unhookCheckListener();
            ToolItemUpdater updater = this.getUpdater();
            if (updater != null) {
                updater.removeItem(this);
            }
            if (this.infoContext != null) {
                this.infoContext.dispose();
                this.infoContext = null;
            }
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget.removeListener(14, this.getItemListener());
            this.widget.removeListener(28, this.getItemListener());
            this.widget = null;
            this.model.setWidget(null);
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            ParameterizedCommand command;
            if (this.unreferenceRunnable != null) {
                this.unreferenceRunnable.run();
                this.unreferenceRunnable = null;
            }
            if ((command = this.model.getWbCommand()) != null) {
                if (this.styleState != null) {
                    this.styleState.removeListener(this.stateListener);
                    this.styleState = null;
                }
                if (this.toggleState != null) {
                    this.toggleState.removeListener(this.stateListener);
                    this.toggleState = null;
                }
                if (this.radioState != null) {
                    this.radioState.removeListener(this.stateListener);
                    this.radioState = null;
                }
            }
            this.widget.dispose();
            this.widget = null;
            this.model.setWidget(null);
        }
    }

    private void handleWidgetSelection(Event event) {
        if (this.widget != null && !this.widget.isDisposed()) {
            if (this.dropdownEvent(event)) {
                return;
            }
            if (this.model.getType() == ItemType.CHECK || this.model.getType() == ItemType.RADIO) {
                boolean selection = false;
                if (this.widget instanceof MenuItem) {
                    selection = ((MenuItem)this.widget).getSelection();
                } else if (this.widget instanceof ToolItem) {
                    selection = ((ToolItem)this.widget).getSelection();
                }
                this.model.setSelected(selection);
            }
            if (this.canExecuteItem(event)) {
                this.executeItem(event);
            }
        }
    }

    private void handleHelpRequest() {
        MCommand command = this.model.getCommand();
        if (command == null || this.helpService == null || this.commandHelpService == null) {
            return;
        }
        String contextHelpId = this.commandHelpService.getHelpContextId(command.getElementId(), this.getContext((MUIElement)this.model));
        if (contextHelpId != null) {
            this.helpService.displayHelp(contextHelpId);
        }
    }

    private boolean dropdownEvent(Event event) {
        if (event.detail == 4 && this.model instanceof MToolItem) {
            ToolItem ti = (ToolItem)event.widget;
            MMenu mmenu = ((MToolItem)this.model).getMenu();
            if (mmenu == null) {
                return false;
            }
            Menu menu = this.getMenu(mmenu, ti);
            if (menu == null || menu.isDisposed()) {
                return true;
            }
            Rectangle itemBounds = ti.getBounds();
            Point displayAt = ti.getParent().toDisplay(itemBounds.x, itemBounds.y + itemBounds.height);
            menu.setLocation(displayAt);
            menu.setVisible(true);
            Display display = menu.getDisplay();
            while (!menu.isDisposed() && menu.isVisible()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return true;
        }
        return false;
    }

    protected Menu getMenu(final MMenu mmenu, ToolItem toolItem) {
        Object obj = mmenu.getWidget();
        if (obj instanceof Menu && !((Menu)obj).isDisposed()) {
            return (Menu)obj;
        }
        if (RenderedElementUtil.isRenderedMenu((MUIElement)mmenu)) {
            IMenuCreator creator;
            Menu menu;
            obj = RenderedElementUtil.getContributionManager((MUIElement)mmenu);
            if (obj instanceof IContextFunction) {
                IEclipseContext lclContext = this.getContext((MUIElement)mmenu);
                obj = ((IContextFunction)obj).compute(lclContext, null);
                RenderedElementUtil.setContributionManager((MUIElement)mmenu, (Object)obj);
            }
            if (obj instanceof IMenuCreator && (menu = (creator = (IMenuCreator)obj).getMenu((Control)toolItem.getParent().getShell())) != null) {
                toolItem.addDisposeListener(new DisposeListener(){
                    private static final long serialVersionUID = 1L;

                    public void widgetDisposed(DisposeEvent e) {
                        if (menu != null && !menu.isDisposed()) {
                            creator.dispose();
                            mmenu.setWidget(null);
                        }
                    }
                });
                menu.setData("modelElement", (Object)menu);
                return menu;
            }
        } else {
            IEclipseContext lclContext = this.getContext((MUIElement)this.model);
            IPresentationEngine engine = (IPresentationEngine)lclContext.get(IPresentationEngine.class);
            obj = engine.createGui((MUIElement)mmenu, (Object)toolItem.getParent(), lclContext);
            if (obj instanceof Menu) {
                Menu menu = (Menu)obj;
                return menu;
            }
            if (this.logger != null) {
                this.logger.debug("Rendering returned " + obj);
            }
        }
        return null;
    }

    private IEclipseContext getStaticContext(Event event) {
        if (this.infoContext == null) {
            this.infoContext = EclipseContextFactory.create((String)HCI_STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)this.model, (IEclipseContext)this.infoContext, (Class[])this.model.getClass().getInterfaces());
        }
        if (event == null) {
            this.infoContext.remove(Event.class);
        } else {
            this.infoContext.set(Event.class, (Object)event);
        }
        return this.infoContext;
    }

    private void executeItem(Event trigger) {
        ParameterizedCommand cmd = this.model.getWbCommand();
        if (cmd == null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)this.model);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
        IEclipseContext staticContext = this.getStaticContext(trigger);
        service.executeHandler(cmd, staticContext);
    }

    private boolean canExecuteItem(Event trigger) {
        ParameterizedCommand cmd = this.model.getWbCommand();
        if (cmd == null) {
            return false;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)this.model);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
        if (service == null) {
            return false;
        }
        IEclipseContext staticContext = this.getStaticContext(trigger);
        return service.canExecute(cmd, staticContext);
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }

    protected IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    protected IEclipseContext getContext(MUIElement part) {
        if (part instanceof MContext) {
            return ((MContext)part).getContext();
        }
        return this.getContextForParent(part);
    }

    public Widget getWidget() {
        return this.widget;
    }

    public MHandledItem getModel() {
        return this.model;
    }

    private ToolItemUpdater getUpdater() {
        Object obj;
        if (this.model != null && (obj = this.model.getRenderer()) instanceof ToolBarManagerRenderer) {
            return ((ToolBarManagerRenderer)((Object)obj)).getUpdater();
        }
        return null;
    }
}

