/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.lang.reflect.Field;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.internal.util.ActiveKeysUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ControlUtil;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.internal.widgets.IControlHolderAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlLCAUtil {
    private static final String PROP_ACTIVATE_LISTENER = "Activate";
    private static final String PROP_DEACTIVATE_LISTENER = "Deactivate";
    private static final String PROP_FOCUS_IN_LISTENER = "FocusIn";
    private static final String PROP_FOCUS_OUT_LISTENER = "FocusOut";
    private static final String PROP_MOUSE_DOWN_LISTENER = "MouseDown";
    private static final String PROP_MOUSE_DOUBLE_CLICK_LISTENER = "MouseDoubleClick";
    private static final String PROP_MOUSE_UP_LISTENER = "MouseUp";
    private static final String PROP_KEY_LISTENER = "KeyDown";
    private static final String PROP_TRAVERSE_LISTENER = "Traverse";
    private static final String PROP_MENU_DETECT_LISTENER = "MenuDetect";
    private static final String PROP_TAB_INDEX = "tabIndex";
    private static final String PROP_CURSOR = "cursor";
    private static final String PROP_BACKGROUND_IMAGE = "backgroundImage";
    private static final String PROP_CHILDREN = "children";
    static final int MAX_STATIC_ZORDER = 300;
    private static final String CURSOR_UPARROW = "rwt-resources/resource/widget/rap/cursors/up_arrow.cur";

    private ControlLCAUtil() {
    }

    public static void readBounds(Control control) {
        Rectangle current = control.getBounds();
        Rectangle newBounds = WidgetLCAUtil.readBounds(control, current);
        control.setBounds(newBounds);
    }

    public static void processMenuDetect(Control control) {
        if (WidgetLCAUtil.wasEventSent(control, PROP_MENU_DETECT_LISTENER)) {
            Event event = new Event();
            Point point = ControlLCAUtil.readEventXYProperties(control, PROP_MENU_DETECT_LISTENER);
            point = control.getDisplay().map(control, null, point);
            event.x = point.x;
            event.y = point.y;
            event.doit = true;
            control.notifyListeners(35, event);
        }
    }

    public static void processEvents(Control control) {
        ControlLCAUtil.processFocusEvents(control);
        ControlLCAUtil.processMouseEvents(control);
    }

    private static void processFocusEvents(Control control) {
        if (WidgetLCAUtil.wasEventSent(control, PROP_FOCUS_IN_LISTENER)) {
            control.notifyListeners(15, new Event());
        }
        if (WidgetLCAUtil.wasEventSent(control, PROP_FOCUS_OUT_LISTENER)) {
            control.notifyListeners(16, new Event());
        }
    }

    public static void processMouseEvents(Control control) {
        if (WidgetLCAUtil.wasEventSent(control, PROP_MOUSE_DOWN_LISTENER)) {
            ControlLCAUtil.sendMouseEvent(control, PROP_MOUSE_DOWN_LISTENER, 3);
        }
        if (WidgetLCAUtil.wasEventSent(control, PROP_MOUSE_DOUBLE_CLICK_LISTENER)) {
            ControlLCAUtil.sendMouseEvent(control, PROP_MOUSE_DOUBLE_CLICK_LISTENER, 8);
        }
        if (WidgetLCAUtil.wasEventSent(control, PROP_MOUSE_UP_LISTENER)) {
            ControlLCAUtil.sendMouseEvent(control, PROP_MOUSE_UP_LISTENER, 4);
        }
    }

    private static void sendMouseEvent(Control control, String eventName, int eventType) {
        Event event = new Event();
        event.widget = control;
        event.type = eventType;
        event.button = ControlLCAUtil.readEventIntProperty(control, eventName, "button");
        Point point = ControlLCAUtil.readEventXYProperties(control, eventName);
        event.x = point.x;
        event.y = point.y;
        event.time = ControlLCAUtil.readEventIntProperty(control, eventName, "time");
        event.stateMask = EventLCAUtil.readStateMask(control, eventName) | EventLCAUtil.translateButton(event.button);
        event.count = WidgetLCAUtil.wasEventSent(control, PROP_MOUSE_DOUBLE_CLICK_LISTENER) ? 2 : 1;
        ControlLCAUtil.checkAndProcessMouseEvent(event);
    }

    public static void processKeyEvents(Control control) {
        int stateMask;
        int charCode;
        int keyCode;
        if (WidgetLCAUtil.wasEventSent(control, PROP_TRAVERSE_LISTENER)) {
            keyCode = ControlLCAUtil.readEventIntProperty(control, PROP_TRAVERSE_LISTENER, "keyCode");
            charCode = ControlLCAUtil.readEventIntProperty(control, PROP_TRAVERSE_LISTENER, "charCode");
            stateMask = EventLCAUtil.readStateMask(control, PROP_TRAVERSE_LISTENER);
            int traverseKey = ControlLCAUtil.getTraverseKey(keyCode, stateMask);
            if (traverseKey != 0) {
                Event event = ControlLCAUtil.createKeyEvent(keyCode, charCode, stateMask);
                event.detail = traverseKey;
                control.notifyListeners(31, event);
            }
        }
        if (WidgetLCAUtil.wasEventSent(control, PROP_KEY_LISTENER)) {
            keyCode = ControlLCAUtil.readEventIntProperty(control, PROP_KEY_LISTENER, "keyCode");
            charCode = ControlLCAUtil.readEventIntProperty(control, PROP_KEY_LISTENER, "charCode");
            stateMask = EventLCAUtil.readStateMask(control, PROP_KEY_LISTENER);
            Event event = ControlLCAUtil.createKeyEvent(keyCode, charCode, stateMask);
            control.notifyListeners(1, event);
            event = ControlLCAUtil.createKeyEvent(keyCode, charCode, stateMask);
            control.notifyListeners(2, event);
        }
    }

    public static void processSelection(Widget widget, Item item, boolean readBounds) {
        if (WidgetLCAUtil.wasEventSent(widget, "Selection")) {
            Event event = ControlLCAUtil.createSelectionEvent(widget, readBounds, 13);
            event.item = item;
            widget.notifyListeners(13, event);
        }
    }

    public static void processDefaultSelection(Widget widget, Item item) {
        if (WidgetLCAUtil.wasEventSent(widget, "DefaultSelection")) {
            Event event = ControlLCAUtil.createSelectionEvent(widget, false, 14);
            event.item = item;
            widget.notifyListeners(14, event);
        }
    }

    public static void preserveValues(Control control) {
        WidgetAdapter adapter = WidgetUtil.getAdapter(control);
        WidgetLCAUtil.preserveBounds(control, control.getBounds());
        adapter.preserve(PROP_CHILDREN, ControlLCAUtil.getChildren(control));
        adapter.preserve(PROP_TAB_INDEX, new Integer(ControlLCAUtil.getTabIndex(control)));
        WidgetLCAUtil.preserveToolTipText(control, control.getToolTipText());
        adapter.preserve("menu", control.getMenu());
        adapter.preserve("visible", ControlLCAUtil.getVisible(control));
        WidgetLCAUtil.preserveEnabled(control, control.getEnabled());
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.preserveForeground(control, controlAdapter.getUserForeground());
        WidgetLCAUtil.preserveBackground(control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
        ControlLCAUtil.preserveBackgroundImage(control);
        WidgetLCAUtil.preserveFont(control, controlAdapter.getUserFont());
        adapter.preserve(PROP_CURSOR, control.getCursor());
        ControlLCAUtil.preserveActivateListeners(control);
        ControlLCAUtil.preserveMouseListeners(control);
        if ((control.getStyle() & 0x80000) == 0) {
            ControlLCAUtil.preserveFocusListeners(control);
        }
        WidgetLCAUtil.preserveListener(control, PROP_KEY_LISTENER, ControlLCAUtil.hasKeyListener(control));
        WidgetLCAUtil.preserveListener(control, PROP_TRAVERSE_LISTENER, EventLCAUtil.isListening(control, 31));
        WidgetLCAUtil.preserveListener(control, PROP_MENU_DETECT_LISTENER, EventLCAUtil.isListening(control, 35));
        WidgetLCAUtil.preserveHelpListener(control);
        ActiveKeysUtil.preserveActiveKeys(control);
        ActiveKeysUtil.preserveCancelKeys(control);
        WidgetLCAUtil.preserveData(control);
    }

    public static void preserveBackgroundImage(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        WidgetAdapter adapter = WidgetUtil.getAdapter(control);
        adapter.preserve(PROP_BACKGROUND_IMAGE, image);
    }

    public static void renderChanges(Control control) {
        ControlLCAUtil.renderBounds(control);
        ControlLCAUtil.renderChildren(control);
        ControlLCAUtil.renderTabIndex(control);
        ControlLCAUtil.renderToolTip(control);
        ControlLCAUtil.renderMenu(control);
        ControlLCAUtil.renderVisible(control);
        ControlLCAUtil.renderEnabled(control);
        ControlLCAUtil.renderForeground(control);
        ControlLCAUtil.renderBackground(control);
        ControlLCAUtil.renderBackgroundImage(control);
        ControlLCAUtil.renderFont(control);
        ControlLCAUtil.renderCursor(control);
        ActiveKeysUtil.renderActiveKeys(control);
        ActiveKeysUtil.renderCancelKeys(control);
        ControlLCAUtil.renderListenActivate(control);
        ControlLCAUtil.renderListenFocus(control);
        ControlLCAUtil.renderListenMouse(control);
        ControlLCAUtil.renderListenKey(control);
        ControlLCAUtil.renderListenTraverse(control);
        ControlLCAUtil.renderListenMenuDetect(control);
        WidgetLCAUtil.renderListenHelp(control);
        WidgetLCAUtil.renderData(control);
    }

    public static void renderBounds(Control control) {
        WidgetLCAUtil.renderBounds(control, control.getBounds());
    }

    static void renderChildren(Control control) {
        if (control instanceof Composite) {
            String[] newValue = ControlLCAUtil.getChildren(control);
            WidgetLCAUtil.renderProperty((Widget)control, PROP_CHILDREN, newValue, null);
        }
    }

    static void renderTabIndex(Control control) {
        int tabIndex;
        Integer newValue;
        if (control instanceof Shell) {
            ControlLCAUtil.resetTabIndices((Shell)control);
            ControlLCAUtil.computeTabIndices((Shell)control, 1);
        }
        if (WidgetLCAUtil.hasChanged(control, PROP_TAB_INDEX, newValue = new Integer(tabIndex = ControlLCAUtil.getTabIndex(control)))) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_TAB_INDEX, tabIndex);
        }
    }

    public static void renderToolTip(Control control) {
        WidgetLCAUtil.renderToolTip(control, control.getToolTipText());
    }

    public static void renderMenu(Control control) {
        WidgetLCAUtil.renderMenu(control, control.getMenu());
    }

    public static void renderVisible(Control control) {
        Boolean defValue;
        boolean visible = ControlLCAUtil.getVisible(control);
        Boolean newValue = visible;
        Boolean bl = defValue = control instanceof Shell ? Boolean.FALSE : Boolean.TRUE;
        if (WidgetLCAUtil.hasChanged(control, "visible", newValue, defValue)) {
            RemoteObjectFactory.getRemoteObject(control).set("visibility", visible);
        }
    }

    public static void renderEnabled(Control control) {
        WidgetLCAUtil.renderEnabled(control, control.getEnabled());
    }

    public static void renderForeground(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.renderForeground(control, controlAdapter.getUserForeground());
    }

    public static void renderBackground(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        WidgetLCAUtil.renderBackground(control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
    }

    public static void renderBackgroundImage(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Image image = controlAdapter.getUserBackgroundImage();
        WidgetLCAUtil.renderProperty((Widget)control, PROP_BACKGROUND_IMAGE, image, null);
    }

    public static void renderFont(Control control) {
        IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
        Font newValue = controlAdapter.getUserFont();
        WidgetLCAUtil.renderFont(control, newValue);
    }

    static void renderCursor(Control control) {
        Cursor newValue = control.getCursor();
        if (WidgetLCAUtil.hasChanged(control, PROP_CURSOR, newValue, null)) {
            RemoteObjectFactory.getRemoteObject(control).set(PROP_CURSOR, ControlLCAUtil.getQxCursor(newValue));
        }
    }

    static void renderListenActivate(Control control) {
        if (!control.isDisposed() && !(control instanceof Shell)) {
            ControlLCAUtil.renderListen(control, 26, PROP_ACTIVATE_LISTENER);
            ControlLCAUtil.renderListen(control, 27, PROP_DEACTIVATE_LISTENER);
        }
    }

    static void renderListenFocus(Control control) {
        if ((control.getStyle() & 0x80000) == 0) {
            ControlLCAUtil.renderListen(control, 15, PROP_FOCUS_IN_LISTENER);
            ControlLCAUtil.renderListen(control, 16, PROP_FOCUS_OUT_LISTENER);
        }
    }

    static void renderListenMouse(Control control) {
        ControlLCAUtil.renderListen(control, 3, PROP_MOUSE_DOWN_LISTENER);
        ControlLCAUtil.renderListen(control, 4, PROP_MOUSE_UP_LISTENER);
        ControlLCAUtil.renderListen(control, 8, PROP_MOUSE_DOUBLE_CLICK_LISTENER);
    }

    static void renderListenKey(Control control) {
        boolean newValue = ControlLCAUtil.hasKeyListener(control);
        WidgetLCAUtil.renderListener(control, PROP_KEY_LISTENER, newValue, false);
    }

    static void renderListenTraverse(Control control) {
        boolean newValue = EventLCAUtil.isListening(control, 31);
        WidgetLCAUtil.renderListener(control, PROP_TRAVERSE_LISTENER, newValue, false);
    }

    static void renderListenMenuDetect(Control control) {
        boolean newValue = EventLCAUtil.isListening(control, 35);
        WidgetLCAUtil.renderListener(control, PROP_MENU_DETECT_LISTENER, newValue, false);
    }

    private static void renderListen(Control control, int eventType, String eventName) {
        WidgetLCAUtil.renderListener(control, eventName, EventLCAUtil.isListening(control, eventType), false);
    }

    private static Event createSelectionEvent(Widget widget, boolean readBounds, int type) {
        Event result = new Event();
        if (widget instanceof Control && readBounds) {
            Control control = (Control)widget;
            Rectangle bounds = WidgetLCAUtil.readBounds(control, control.getBounds());
            result.setBounds(bounds);
        }
        String eventName = type == 13 ? "Selection" : "DefaultSelection";
        result.stateMask = EventLCAUtil.readStateMask(widget, eventName);
        String detail = ControlLCAUtil.readEventStringProperty(widget, eventName, "detail");
        if ("check".equals(detail)) {
            result.detail = 32;
        } else if ("search".equals(detail)) {
            result.detail = 512;
        } else if ("cancel".equals(detail)) {
            result.detail = 256;
        } else if ("hyperlink".equals(detail)) {
            result.detail = 0x4000000;
        }
        result.text = ControlLCAUtil.readEventStringProperty(widget, eventName, "text");
        return result;
    }

    private static Event createKeyEvent(int keyCode, int charCode, int stateMask) {
        Event result = new Event();
        result.keyCode = ControlLCAUtil.translateKeyCode(keyCode);
        if (charCode == 0) {
            if ((result.keyCode & 0x1000000) == 0) {
                result.character = ControlLCAUtil.translateCharacter(result.keyCode);
            }
        } else {
            result.character = ControlLCAUtil.translateCharacter(charCode);
            if (Character.isLetter(charCode)) {
                result.keyCode = Character.toLowerCase(charCode);
            }
        }
        result.stateMask = stateMask;
        return result;
    }

    private static void checkAndProcessMouseEvent(Event event) {
        boolean pass = false;
        Control control = (Control)event.widget;
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            Rectangle clientArea = scrollable.getClientArea();
            pass = clientArea.contains(event.x, event.y);
        } else {
            boolean bl = pass = event.x >= 0 && event.y >= 0;
        }
        if (pass) {
            event.widget.notifyListeners(event.type, event);
        }
    }

    private static Point readEventXYProperties(Control control, String eventName) {
        int x = ControlLCAUtil.readEventIntProperty(control, eventName, "x");
        int y = ControlLCAUtil.readEventIntProperty(control, eventName, "y");
        return control.getDisplay().map(null, control, x, y);
    }

    private static int readEventIntProperty(Widget widget, String eventName, String property) {
        return ProtocolUtil.readEventPropertyValue(WidgetUtil.getId(widget), eventName, property).asInt();
    }

    private static String readEventStringProperty(Widget widget, String eventName, String property) {
        JsonValue value = ProtocolUtil.readEventPropertyValue(WidgetUtil.getId(widget), eventName, property);
        return value != null ? value.asString() : null;
    }

    private static String[] getChildren(Control control) {
        String[] result = null;
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            IControlHolderAdapter controlHolder = composite.getAdapter(IControlHolderAdapter.class);
            Control[] children = controlHolder.getControls();
            result = new String[children.length];
            int i = 0;
            while (i < result.length) {
                result[i] = WidgetUtil.getId(children[i]);
                ++i;
            }
        }
        return result;
    }

    private static boolean getVisible(Control control) {
        Point size = control.getSize();
        return control.getVisible() && size.x > 0 && size.y > 0;
    }

    private static boolean takesFocus(Control control) {
        boolean result = true;
        result &= (control.getStyle() & 0x80000) == 0;
        result &= control.getClass() != Composite.class;
        return result &= control.getClass() != SashForm.class;
    }

    private static int getTabIndex(Control control) {
        int result = -1;
        if (ControlLCAUtil.takesFocus(control)) {
            result = ControlUtil.getControlAdapter(control).getTabIndex();
        }
        return result;
    }

    private static void resetTabIndices(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            ControlUtil.getControlAdapter(control).setTabIndex(-1);
            if (control instanceof Composite) {
                ControlLCAUtil.resetTabIndices((Composite)control);
            }
            ++n2;
        }
    }

    private static int computeTabIndices(Composite composite, int startIndex) {
        int result = startIndex;
        Control[] controlArray = composite.getTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            IControlAdapter controlAdapter = ControlUtil.getControlAdapter(control);
            controlAdapter.setTabIndex(result);
            result += control instanceof Link ? 300 : 1;
            if (control instanceof Composite) {
                result = ControlLCAUtil.computeTabIndices((Composite)control, result);
            }
            ++n2;
        }
        return result;
    }

    static int getTraverseKey(int keyCode, int stateMask) {
        int result = 0;
        switch (keyCode) {
            case 27: {
                result = 2;
                break;
            }
            case 13: {
                result = 4;
                break;
            }
            case 9: {
                if ((stateMask & SWT.MODIFIER_MASK) == 0) {
                    result = 16;
                    break;
                }
                if (stateMask != 131072) break;
                result = 8;
            }
        }
        return result;
    }

    static int translateKeyCode(int keyCode) {
        int result;
        switch (keyCode) {
            case 16: {
                result = 131072;
                break;
            }
            case 17: {
                result = 262144;
                break;
            }
            case 18: {
                result = 65536;
                break;
            }
            case 20: {
                result = 16777298;
                break;
            }
            case 38: {
                result = 0x1000001;
                break;
            }
            case 37: {
                result = 0x1000003;
                break;
            }
            case 39: {
                result = 0x1000004;
                break;
            }
            case 40: {
                result = 0x1000002;
                break;
            }
            case 33: {
                result = 0x1000005;
                break;
            }
            case 34: {
                result = 0x1000006;
                break;
            }
            case 35: {
                result = 0x1000008;
                break;
            }
            case 36: {
                result = 0x1000007;
                break;
            }
            case 45: {
                result = 0x1000009;
                break;
            }
            case 46: {
                result = 127;
                break;
            }
            case 112: {
                result = 0x100000A;
                break;
            }
            case 113: {
                result = 0x100000B;
                break;
            }
            case 114: {
                result = 0x100000C;
                break;
            }
            case 115: {
                result = 0x100000D;
                break;
            }
            case 116: {
                result = 0x100000E;
                break;
            }
            case 117: {
                result = 0x100000F;
                break;
            }
            case 118: {
                result = 0x1000010;
                break;
            }
            case 119: {
                result = 0x1000011;
                break;
            }
            case 120: {
                result = 0x1000012;
                break;
            }
            case 121: {
                result = 0x1000013;
                break;
            }
            case 122: {
                result = 0x1000014;
                break;
            }
            case 123: {
                result = 0x1000015;
                break;
            }
            case 144: {
                result = 16777299;
                break;
            }
            case 44: {
                result = 16777303;
                break;
            }
            case 145: {
                result = 16777300;
                break;
            }
            case 19: {
                result = 0x1000055;
                break;
            }
            default: {
                result = keyCode;
            }
        }
        return result;
    }

    private static char translateCharacter(int keyCode) {
        char result = '\u0000';
        if (Character.isDefined((char)keyCode)) {
            result = (char)keyCode;
        }
        return result;
    }

    private static String getQxCursor(Cursor newValue) {
        String result = null;
        if (newValue != null) {
            int value = 0;
            try {
                Class<Cursor> cursorClass = Cursor.class;
                Field field = cursorClass.getDeclaredField("value");
                field.setAccessible(true);
                value = field.getInt(newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            switch (value) {
                case 0: {
                    result = "default";
                    break;
                }
                case 1: {
                    result = "wait";
                    break;
                }
                case 3: {
                    result = "progress";
                    break;
                }
                case 2: {
                    result = "crosshair";
                    break;
                }
                case 4: {
                    result = "help";
                    break;
                }
                case 5: {
                    result = "move";
                    break;
                }
                case 7: {
                    result = "row-resize";
                    break;
                }
                case 9: {
                    result = "col-resize";
                    break;
                }
                case 10: {
                    result = "n-resize";
                    break;
                }
                case 11: {
                    result = "s-resize";
                    break;
                }
                case 12: {
                    result = "e-resize";
                    break;
                }
                case 13: {
                    result = "w-resize";
                    break;
                }
                case 6: 
                case 14: {
                    result = "ne-resize";
                    break;
                }
                case 15: {
                    result = "se-resize";
                    break;
                }
                case 16: {
                    result = "sw-resize";
                    break;
                }
                case 8: 
                case 17: {
                    result = "nw-resize";
                    break;
                }
                case 19: {
                    result = "text";
                    break;
                }
                case 21: {
                    result = "pointer";
                    break;
                }
                case 20: {
                    result = "not-allowed";
                    break;
                }
                case 18: {
                    result = CURSOR_UPARROW;
                }
            }
        }
        return result;
    }

    private static boolean hasKeyListener(Control control) {
        return EventLCAUtil.isListening(control, 2) || EventLCAUtil.isListening(control, 1);
    }

    private static void preserveMouseListeners(Control control) {
        WidgetLCAUtil.preserveListener(control, PROP_MOUSE_DOWN_LISTENER, EventLCAUtil.isListening(control, 3));
        WidgetLCAUtil.preserveListener(control, PROP_MOUSE_UP_LISTENER, EventLCAUtil.isListening(control, 4));
        WidgetLCAUtil.preserveListener(control, PROP_MOUSE_DOUBLE_CLICK_LISTENER, EventLCAUtil.isListening(control, 8));
    }

    private static void preserveFocusListeners(Control control) {
        WidgetLCAUtil.preserveListener(control, PROP_FOCUS_IN_LISTENER, EventLCAUtil.isListening(control, 15));
        WidgetLCAUtil.preserveListener(control, PROP_FOCUS_OUT_LISTENER, EventLCAUtil.isListening(control, 16));
    }

    private static void preserveActivateListeners(Control control) {
        if (!(control instanceof Shell)) {
            WidgetLCAUtil.preserveListener(control, PROP_ACTIVATE_LISTENER, EventLCAUtil.isListening(control, 26));
            WidgetLCAUtil.preserveListener(control, PROP_DEACTIVATE_LISTENER, EventLCAUtil.isListening(control, 27));
        }
    }
}

