/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart.basic;

import org.eclipse.rap.addons.chart.NvChart;
import org.eclipse.rap.addons.chart.basic.DataItem;
import org.eclipse.rap.addons.chart.internal.ColorUtil;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.swt.widgets.Composite;

public class BarChart
extends NvChart {
    private boolean showValues = true;
    private boolean showXAxis = true;
    private boolean showYAxis = true;
    private String xAxisLabel = "";
    private String yAxisLabel = "";
    private boolean staggerLabels;

    public BarChart(Composite parent, int style) {
        super(parent, style, "nv-bar");
        this.requireJs(this.registerResource("chart/nv/nv-bar.js"));
    }

    public void setShowValues(boolean show) {
        this.checkWidget();
        if (show != this.showValues) {
            this.showValues = show;
            this.setOption("showValues", show);
        }
    }

    public boolean getShowValues() {
        this.checkWidget();
        return this.showValues;
    }

    public void setXAxisLabel(String label) {
        this.checkWidget();
        if (label != null && !label.equals(this.xAxisLabel)) {
            this.xAxisLabel = label;
            this.setOption("xAxis.axisLabel", label);
        }
    }

    public String getXAxisLabel() {
        this.checkWidget();
        return this.xAxisLabel;
    }

    public void setYAxisLabel(String label) {
        this.checkWidget();
        if (label != null && !label.equals(this.yAxisLabel)) {
            this.yAxisLabel = label;
            this.setOption("yAxis.axisLabel", label);
        }
    }

    public String getYAxisLabel() {
        this.checkWidget();
        return this.yAxisLabel;
    }

    public void setShowXAxis(boolean show) {
        this.checkWidget();
        if (this.showXAxis != show) {
            this.showXAxis = show;
            this.setOption("showXAxis", show);
        }
    }

    public boolean getShowXAxis() {
        this.checkWidget();
        return this.showXAxis;
    }

    public void setShowYAxis(boolean show) {
        this.checkWidget();
        if (this.showYAxis != show) {
            this.showYAxis = show;
            this.setOption("showYAxis", show);
        }
    }

    public boolean getShowYAxis() {
        this.checkWidget();
        return this.showYAxis;
    }

    public void setStaggerLabels(boolean staggerLabels) {
        this.checkWidget();
        if (this.staggerLabels != staggerLabels) {
            this.staggerLabels = staggerLabels;
            this.setOption("staggerLabels", staggerLabels);
        }
    }

    public boolean getStaggerLabels() {
        this.checkWidget();
        return this.staggerLabels;
    }

    public void setItems(DataItem ... items) {
        JsonArray values = new JsonArray();
        DataItem[] dataItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            DataItem item = dataItemArray[n2];
            values.add((JsonValue)BarChart.toJson(item));
            ++n2;
        }
        this.setItems((JsonValue)new JsonArray().add((JsonValue)new JsonObject().add("values", (JsonValue)values)));
    }

    private static JsonObject toJson(DataItem item) {
        JsonObject json = new JsonObject().add("value", item.value);
        if (item.text != null) {
            json.add("label", item.text);
        }
        if (item.color != null) {
            json.add("color", ColorUtil.toHtmlString(item.color));
        }
        return json;
    }
}

