/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.addons.chart.internal.CssLoader;
import org.eclipse.rap.addons.chart.internal.Resources;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.OperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.service.UISession;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class Chart
extends Canvas {
    private static final String PROP_D3_JS_URL = "org.eclipse.rap.addons.chart.d3JsUrl";
    private static final String DEF_D3_JS_URL = "https://d3js.org/d3.v3.min.js";
    private static final String REMOTE_TYPE = "rwt.chart.Chart";
    private Resources resources;
    private CssLoader cssLoader;
    protected final RemoteObject remoteObject = RWT.getUISession().getConnection().createRemoteObject("rwt.chart.Chart");

    protected Chart(Composite parent, int style, String renderer) {
        super(parent, style);
        this.remoteObject.set("parent", WidgetUtil.getId((Widget)this));
        this.remoteObject.set("renderer", renderer);
        this.remoteObject.setHandler((OperationHandler)new AbstractOperationHandler(){

            public void handleNotify(String eventName, JsonObject properties) {
                if ("Selection".equals(eventName)) {
                    JsonValue text;
                    Event event = new Event();
                    event.index = properties.get("index").asInt();
                    JsonValue detail = properties.get("detail");
                    if (detail != null) {
                        event.detail = detail.asInt();
                    }
                    if ((text = properties.get("text")) != null) {
                        event.text = text.asString();
                    }
                    Chart.this.notifyListeners(13, event);
                }
            }
        });
        this.resources = (Resources)SingletonUtil.getUniqueInstance(Resources.class, (ApplicationContext)RWT.getApplicationContext());
        this.cssLoader = (CssLoader)SingletonUtil.getUniqueInstance(CssLoader.class, (UISession)RWT.getUISession());
        this.requireJs(System.getProperty(PROP_D3_JS_URL, DEF_D3_JS_URL));
        this.requireJs(this.registerResource("chart/chart.js"));
    }

    protected void setItems(JsonValue data) {
        this.checkWidget();
        this.remoteObject.set("items", data);
    }

    protected void setOption(String name, int value) {
        this.setOption(name, JsonValue.valueOf((int)value));
    }

    protected void setOption(String name, double value) {
        this.setOption(name, JsonValue.valueOf((double)value));
    }

    protected void setOption(String name, boolean value) {
        this.setOption(name, JsonValue.valueOf((boolean)value));
    }

    protected void setOption(String name, String value) {
        this.setOption(name, JsonValue.valueOf((String)value));
    }

    protected void setOption(String name, JsonValue value) {
        this.remoteObject.call("setOptions", new JsonObject().add(name, value));
    }

    protected void requireJs(String url) {
        ((JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class)).require(url);
    }

    protected void requireCss(String url) {
        this.cssLoader.requireCss(url);
    }

    protected String registerResource(String resourceName) {
        return this.resources.register(resourceName, resourceName, this.getResourceLoader());
    }

    private ResourceLoader getResourceLoader() {
        final ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        return new ResourceLoader(){

            public InputStream getResourceAsStream(String resourceName) throws IOException {
                return classLoader.getResourceAsStream(resourceName);
            }
        };
    }

    public void dispose() {
        super.dispose();
        this.remoteObject.destroy();
    }

    public void addListener(int eventType, Listener listener) {
        boolean wasListening = this.isListening(13);
        super.addListener(eventType, listener);
        if (eventType == 13 && !wasListening) {
            this.remoteObject.listen("Selection", true);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        boolean wasListening = this.isListening(13);
        super.removeListener(eventType, listener);
        if (eventType == 13 && wasListening && !this.isListening(13)) {
            this.remoteObject.listen("Selection", false);
        }
    }
}

