/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.rap.tools.launch.internal.RAPLaunchConfig;

public final class URLBuilder {
    private static final String EMPTY = "";
    static final String SLASH = "/";
    private static final String PROTOCOL = "http";
    private static final String HOST = "127.0.0.1";

    public static String getHost() {
        return HOST;
    }

    public static String fromLaunchConfig(RAPLaunchConfig config, int port, boolean testMode) throws CoreException {
        return URLBuilder.fromLaunchConfig(config, Integer.toString(port), testMode);
    }

    public static String fromLaunchConfig(RAPLaunchConfig config, String port, boolean testMode) throws CoreException {
        String path = URLBuilder.getUrlPath(config);
        return "http://127.0.0.1:" + port + path;
    }

    private static String getUrlPath(RAPLaunchConfig config) throws CoreException {
        String contextPath = URLBuilder.getContextPath(config);
        String servletPath = URLBuilder.getServletPath(config);
        StringBuffer buffer = new StringBuffer();
        buffer.append(SLASH);
        if (!EMPTY.equals(contextPath)) {
            buffer.append(contextPath);
            buffer.append(SLASH);
        }
        buffer.append(servletPath);
        return buffer.toString();
    }

    private static String getServletPath(RAPLaunchConfig config) throws CoreException {
        String servletPath = config.getServletPath();
        return URLBuilder.stripLeadingAndTrailingSlashes(servletPath);
    }

    private static String getContextPath(RAPLaunchConfig config) throws CoreException {
        String contextPath = EMPTY;
        if (config.getUseManualContextPath()) {
            contextPath = config.getContextPath();
        }
        return URLBuilder.stripLeadingAndTrailingSlashes(contextPath);
    }

    private static String stripLeadingAndTrailingSlashes(String input) {
        String result = input;
        if (result.startsWith(SLASH)) {
            result = result.substring(1);
        }
        if (result.endsWith(SLASH)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private URLBuilder() {
    }
}

