/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.TrackingExecutor;
import org.eclipse.jetty.util.thread.TryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="A thread non-pool for virtual threads")
public class VirtualThreadPool
extends ContainerLifeCycle
implements ThreadPool,
Dumpable,
TryExecutor,
VirtualThreads.Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualThreadPool.class);
    private final AutoLock.WithCondition _joinLock = new AutoLock.WithCondition();
    private String _name = null;
    private Executor _virtualExecutor;
    private Thread _main;
    private boolean _externalExecutor;
    private boolean _tracking;
    private boolean _detailedDump;

    public VirtualThreadPool() {
        if (!VirtualThreads.areSupported()) {
            throw new IllegalStateException("Virtual Threads not supported");
        }
    }

    @ManagedAttribute(value="name of the thread pool")
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        if (StringUtil.isBlank(name) && name != null) {
            throw new IllegalArgumentException("Blank name");
        }
        this._name = name;
    }

    @ManagedAttribute(value="virtual threads are tracked")
    public boolean isTracking() {
        return this._tracking;
    }

    public void setTracking(boolean tracking) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._tracking = tracking;
    }

    @ManagedAttribute(value="reports additional details in the dump")
    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
        Executor executor = this._virtualExecutor;
        if (executor instanceof TrackingExecutor) {
            TrackingExecutor trackingExecutor = (TrackingExecutor)executor;
            trackingExecutor.setDetailedDump(detailedDump);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._main = new Thread("jetty-virtual-thread-pool-keepalive"){

            @Override
            public void run() {
                try (AutoLock.WithCondition l = VirtualThreadPool.this._joinLock.lock();){
                    while (VirtualThreadPool.this.isRunning()) {
                        l.await();
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this._main.start();
        if (this._virtualExecutor == null) {
            this._externalExecutor = false;
            this._virtualExecutor = Objects.requireNonNull(StringUtil.isBlank(this._name) ? VirtualThreads.getDefaultVirtualThreadsExecutor() : VirtualThreads.getNamedVirtualThreadsExecutor(this._name));
        }
        if (this._tracking && !(this._virtualExecutor instanceof TrackingExecutor)) {
            this._virtualExecutor = new TrackingExecutor(this._virtualExecutor, this._detailedDump);
        }
        this.addBean(this._virtualExecutor);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this._virtualExecutor);
        if (!this._externalExecutor) {
            this._virtualExecutor = null;
        }
        this._main = null;
        try (AutoLock.WithCondition l = this._joinLock.lock();){
            l.signalAll();
        }
    }

    @Override
    public Executor getVirtualThreadsExecutor() {
        return this._virtualExecutor;
    }

    @Override
    public void setVirtualThreadsExecutor(Executor executor) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.getState());
        }
        this._externalExecutor = executor != null;
        this._virtualExecutor = executor;
    }

    @Override
    public void join() throws InterruptedException {
        try (AutoLock.WithCondition l = this._joinLock.lock();){
            while (this.isRunning()) {
                l.await();
            }
        }
        while (this.isStopping()) {
            Thread.onSpinWait();
        }
    }

    @Override
    public int getThreads() {
        int n;
        Executor executor = this._virtualExecutor;
        if (executor instanceof TrackingExecutor) {
            TrackingExecutor tracking = (TrackingExecutor)executor;
            n = tracking.size();
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int getIdleThreads() {
        return 0;
    }

    @Override
    public boolean isLowOnThreads() {
        return false;
    }

    @Override
    public boolean tryExecute(Runnable task) {
        try {
            this._virtualExecutor.execute(task);
            return true;
        }
        catch (RejectedExecutionException e) {
            LOG.warn("tryExecute {} failed", (Object)this._name, (Object)e);
            return false;
        }
    }

    @Override
    public void execute(Runnable task) {
        this._virtualExecutor.execute(task);
    }
}

