/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.internal.actions;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.sphinx.emf.explorer.internal.Activator;
import org.eclipse.sphinx.emf.explorer.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveableFilter;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class CloseResourceOverrideAction
extends CloseResourceAction {
    public static final String ID = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".CloseResourceAction";

    public CloseResourceOverrideAction(IShellProvider provider) {
        this(provider, IDEWorkbenchMessages.CloseResourceAction_text);
    }

    public CloseResourceOverrideAction(IShellProvider provider, String text) {
        super(provider, text);
        Assert.isNotNull((Object)provider);
        this.initAction();
    }

    private void initAction() {
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseResourceAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_resource_action_context");
    }

    public void run() {
        if (!this.saveDirtyModels()) {
            return;
        }
        super.run();
    }

    protected boolean saveDirtyModels() {
        final List projects = this.getSelectedResources();
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        final boolean[] canceled = new boolean[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(Messages.error_failedToSaveModelsInWorkbench){

                    public void run() {
                        IWorkbenchWindow[] windows;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                            window = windows[0];
                        }
                        if (window != null) {
                            canceled[0] = !PlatformUI.getWorkbench().saveAll((IShellProvider)window, (IRunnableContext)window, (ISaveableFilter)new BasicModelSaveableFilter((Collection)projects), true);
                        }
                    }
                });
            }
        });
        if (canceled[0]) {
            return false;
        }
        for (IProject project : projects) {
            Set projectGroup = ExtendedPlatform.getProjectGroup((IProject)project, (boolean)true);
            for (IProject proj : projectGroup) {
                ModelSaveManager.INSTANCE.setSaved((IContainer)proj);
            }
        }
        return true;
    }
}

