/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.validation.ui.views.ShowInAction;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowInMenu
extends ContributionItem {
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoTargets;
    private IWorkbenchWindow window;
    private Map actions = new HashMap(21);
    private boolean dirty = true;
    private String targetObjectURI = null;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ShowInMenu.this.dirty = true;
        }
    };

    public ShowInMenu(IWorkbenchWindow window, String id, String uri) {
        super(id);
        this.window = window;
        this.targetObjectURI = uri;
    }

    protected IWorkbenchWindow getWindow() {
        return this.window;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index++);
            item.setText(NO_TARGETS_MSG);
            item.setEnabled(false);
        } else {
            IContributionItem[] iContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem element = iContributionItemArray[n2];
                element.fill(menu, index++);
                ++n2;
            }
        }
        this.dirty = false;
    }

    private void fillMenu(IMenuManager innerMgr) {
        innerMgr.removeAll();
        IWorkbenchPart sourcePart = this.getSourcePart();
        if (sourcePart == null) {
            return;
        }
        ShowInContext context = this.getContext(sourcePart);
        if (context == null) {
            return;
        }
        if (context.getInput() == null && (context.getSelection() == null || context.getSelection().isEmpty())) {
            return;
        }
        IViewDescriptor[] viewDescs = this.getViewDescriptors(sourcePart);
        if (viewDescs.length == 0) {
            return;
        }
        int i = 0;
        while (i < viewDescs.length) {
            IAction action = this.getAction(viewDescs[i]);
            if (action != null) {
                innerMgr.add(action);
            }
            ++i;
        }
    }

    private IAction getAction(IViewDescriptor desc) {
        Object action = (IAction)this.actions.get(desc.getId());
        if (action == null && desc != null) {
            action = new ShowInAction(this.window, desc);
            this.actions.put(desc.getId(), action);
        }
        return action;
    }

    private ArrayList getShowInPartIds(IWorkbenchPart sourcePart) {
        String[] partIds;
        IShowInTargetList targetList;
        ArrayList<String> targetIds = new ArrayList<String>();
        WorkbenchPage page = (WorkbenchPage)this.getWindow().getActivePage();
        if (page != null) {
            targetIds.addAll(page.getShowInPartIds());
        }
        if ((targetList = this.getShowInTargetList(sourcePart)) != null && (partIds = targetList.getShowInTargetIds()) != null) {
            int i = 0;
            while (i < partIds.length) {
                if (!targetIds.contains(partIds[i])) {
                    targetIds.add(partIds[i]);
                }
                ++i;
            }
        }
        page.sortShowInPartIds(targetIds);
        return targetIds;
    }

    private IWorkbenchPart getSourcePart() {
        IWorkbenchPage page = this.getWindow().getActivePage();
        if (page != null) {
            return page.getActivePart();
        }
        return null;
    }

    private IShowInSource getShowInSource(IWorkbenchPart sourcePart) {
        return (IShowInSource)Util.getAdapter((Object)sourcePart, IShowInSource.class);
    }

    private IShowInTargetList getShowInTargetList(IWorkbenchPart sourcePart) {
        return (IShowInTargetList)Util.getAdapter((Object)sourcePart, IShowInTargetList.class);
    }

    private ShowInContext getContext(IWorkbenchPart sourcePart) {
        IShowInSource source = this.getShowInSource(sourcePart);
        if (source != null) {
            ShowInContext context = source.getShowInContext();
            if (context != null) {
                return context;
            }
        } else if (sourcePart instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)sourcePart).getEditorInput();
            ISelectionProvider sp = sourcePart.getSite().getSelectionProvider();
            ISelection sel = sp == null ? null : sp.getSelection();
            return new ShowInContext((Object)input, sel);
        }
        return null;
    }

    private IViewDescriptor[] getViewDescriptors(IWorkbenchPart sourcePart) {
        String srcId = sourcePart.getSite().getId();
        ArrayList ids = this.getShowInPartIds(sourcePart);
        ArrayList<IViewDescriptor> descs = new ArrayList<IViewDescriptor>();
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        for (String id : ids) {
            IViewDescriptor desc;
            if (id.equals(srcId) || (desc = reg.find(id)) == null) continue;
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((URI)URI.createURI((String)this.targetObjectURI, (boolean)true));
            if (editingDomain != null) {
                EObject targetObject = editingDomain.getResourceSet().getEObject(URI.createURI((String)this.targetObjectURI, (boolean)true), false);
                if (targetObject != null) {
                    INavigatorContentService contentService = NavigatorContentServiceFactory.INSTANCE.createContentService(id);
                    INavigatorContentDescriptor[] navigatorContentDesList = contentService.getVisibleExtensions();
                    boolean ableToShow = false;
                    INavigatorContentDescriptor[] iNavigatorContentDescriptorArray = navigatorContentDesList;
                    int n = navigatorContentDesList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        INavigatorContentDescriptor des = iNavigatorContentDescriptorArray[n2];
                        if (des.isPossibleChild((Object)targetObject)) {
                            ableToShow = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!ableToShow) continue;
                    descs.add(desc);
                    continue;
                }
                descs.add(desc);
                continue;
            }
            descs.add(desc);
        }
        return descs.toArray(new IViewDescriptor[descs.size()]);
    }
}

