/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.diagnostic.filters;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;

public class ConstraintCategoryFilter
implements IConstraintFilter {
    private String categoryIdPattern;

    public ConstraintCategoryFilter(String categoryIdPattern) {
        Assert.isNotNull((Object)categoryIdPattern);
        this.categoryIdPattern = categoryIdPattern;
    }

    public boolean accept(IConstraintDescriptor constraint, EObject target) {
        if (constraint != null) {
            for (Category category : constraint.getCategories()) {
                while (category != null) {
                    if (category.getId().matches(this.categoryIdPattern)) {
                        return true;
                    }
                    category = category.getParent();
                }
            }
        }
        return false;
    }
}

