/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.server.renv;

import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.eclipse.statet.internal.rhelp.server.renv.REnvConfigurationImpl;
import org.eclipse.statet.internal.rhelp.server.renv.REnvManagerConfiguration;
import org.eclipse.statet.internal.rhelp.server.renv.REnvManagerImpl;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.rj.renv.core.BasicREnvManager;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@NonNullByDefault
public class REnvManagerImpl
extends BasicREnvManager
implements REnvManager {
    private final REnvManagerConfiguration configuration;
    private final Path rEnvsDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Autowired
    public REnvManagerImpl(REnvManagerConfiguration configuration) {
        this.configuration = configuration;
        ArrayList<REnvConfiguration> configs = new ArrayList<REnvConfiguration>();
        try {
            this.rEnvsDir = this.configuration.getRootDirectory();
            try (DirectoryStream<Path> rEnvDirs = Files.newDirectoryStream(this.rEnvsDir, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path rEnvDir : rEnvDirs) {
                    REnvConfiguration config = this.readConfig(rEnvDir);
                    if (config == null) continue;
                    configs.add(config);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize R environments.", e);
        }
        REnvManagerImpl rEnvManagerImpl = this;
        synchronized (rEnvManagerImpl) {
            ArrayList<BasicREnvManager.ActualREnv> envs = new ArrayList<BasicREnvManager.ActualREnv>(configs.size());
            for (REnvConfiguration config : configs) {
                BasicREnvManager.ActualREnv env = (BasicREnvManager.ActualREnv)config.getREnv();
                this.updateEnv(env, config);
                envs.add(env);
            }
            this.setActualEnvs(ImCollections.toList(envs));
        }
    }

    private @Nullable REnvConfiguration readConfig(Path path) {
        String id = ((Path)ObjectUtils.nonNullAssert((Object)path.getFileName())).toString();
        try {
            BasicREnvManager.ActualREnv env = this.newEnv(id);
            REnvConfigurationImpl config = new REnvConfigurationImpl((REnv)env, path);
            return config;
        }
        catch (Exception e) {
            CommonsRuntime.log((Status)new ErrorStatus("org.eclipse.statet.rhelp.server", String.format("An error occurred when loading R environment configuration '%1$s'.", id), (Throwable)e));
            return null;
        }
    }

    protected BasicREnvManager.ActualREnv newEnv(String id) {
        if (!this.isValidId(id)) {
            throw new IllegalArgumentException("id=" + id);
        }
        return new ActualServerREnv(id.intern());
    }
}

