/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source;

import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.yaml.core.source.YamlChunkHeuristicTokenScanner;
import org.eclipse.statet.yaml.core.source.YamlDocumentConstants;

public class YamlHeuristicTokenScanner
extends BasicHeuristicTokenScanner {
    public static final int CURLY_BRACKET_TYPE = 0;
    public static final int SQUARE_BRACKET_TYPE = 1;

    public static int getBracketType(char c) {
        switch (c) {
            case '{': 
            case '}': {
                return 0;
            }
            case '[': 
            case ']': {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public static YamlHeuristicTokenScanner create(DocContentSections documentContentInfo) {
        return documentContentInfo.getPrimaryType() == "org.eclipse.statet.Yaml" ? new YamlHeuristicTokenScanner(documentContentInfo) : new YamlChunkHeuristicTokenScanner(documentContentInfo);
    }

    protected YamlHeuristicTokenScanner(DocContentSections documentContentInfo) {
        super(documentContentInfo, YamlDocumentConstants.YAML_DEFAULT_CONTENT_CONSTRAINT);
    }

    public int[] computeBracketBalance(int backwardOffset, int forwardOffset, int[] initial, int searchType) {
        int[] compute = new int[3];
        BracketBalanceCondition condition = new BracketBalanceCondition();
        int breakType = -1;
        while (--backwardOffset >= 0) {
            if ((backwardOffset = this.scanBackward(backwardOffset, -1, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                compute[n] = compute[n] + 1;
                if (condition.type == searchType || compute[condition.type] <= 0) continue;
                breakType = condition.type;
                break;
            }
            int n = condition.type;
            compute[n] = compute[n] - 1;
        }
        int bound = this.getDocument().getLength();
        int i = 0;
        while (i < compute.length) {
            if (compute[i] < 0) {
                compute[i] = 0;
            }
            compute[i] = compute[i] + initial[i];
            ++i;
        }
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                compute[n] = compute[n] + 1;
            } else {
                int n = condition.type;
                compute[n] = compute[n] - 1;
            }
            if (breakType >= 0 && compute[breakType] == 0) break;
            ++forwardOffset;
        }
        return compute;
    }

    private class BracketBalanceCondition
    extends BasicHeuristicTokenScanner.PartitionBasedCondition {
        private int type;
        private boolean open;

        private BracketBalanceCondition() {
            super((BasicHeuristicTokenScanner)YamlHeuristicTokenScanner.this);
        }

        protected boolean matchesChar() {
            switch (YamlHeuristicTokenScanner.this.ch) {
                case '{': {
                    this.type = 0;
                    this.open = true;
                    return true;
                }
                case '}': {
                    this.type = 0;
                    this.open = false;
                    return true;
                }
                case '[': {
                    this.type = 1;
                    this.open = true;
                    return true;
                }
                case ']': {
                    this.type = 1;
                    this.open = false;
                    return true;
                }
            }
            return false;
        }
    }
}

