/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.internal.rj.renv.core.REnvCoreInternals;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.lang.SystemUtils;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.rj.renv.core.BasicREnvConfiguration;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;

@NonNullByDefault
public class DefaultLocalConfigurator {
    public static final int MINIMAL_SETUP = 1;
    private final REnvConfiguration config;

    private static final @Nullable Path getFirstDirectory(Path baseDirectory, String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Path directory = baseDirectory.resolve(name);
            if (Files.isDirectory(directory, new LinkOption[0])) {
                return directory;
            }
            ++n2;
        }
        return null;
    }

    private static final @Nullable Path getFirstDirectoryWith(List<Path> directories, String name) {
        for (Path directory : directories) {
            Path file = directory.resolve(name);
            if (!Files.isRegularFile(file, new LinkOption[0])) continue;
            return directory;
        }
        return null;
    }

    public DefaultLocalConfigurator(REnvConfiguration config) {
        this.config = config;
    }

    protected REnvConfiguration getConfig() {
        return this.config;
    }

    protected @Nullable String getSystemEnvVar(String name) {
        return System.getenv(name);
    }

    public @Nullable String getRArch() {
        String arch;
        block11: {
            arch = this.config.getRArch();
            if (arch == null) {
                return null;
            }
            if (SystemUtils.getLocalOs() != 1) break block11;
            switch (arch) {
                case "x86_64": {
                    return "x64";
                }
                case "x86_32": {
                    return "i386";
                }
            }
        }
        return arch;
    }

    public Map<String, String> getEnvironmentsVariables(int options) throws StatusException {
        if (!this.config.isLocal() || this.config instanceof BasicREnvConfiguration && (((BasicREnvConfiguration)this.config).getFlags() & 4) == 0) {
            throw new UnsupportedOperationException();
        }
        this.config.getValidationStatus().getSeverity();
        HashMap<String, String> envp = new HashMap<String, String>();
        envp.put("R_HOME", this.getRHomeDirectory().toString());
        switch (SystemUtils.getLocalOs()) {
            case 1: {
                this.putPrepend(envp, "PATH", this.checkLibDirectory(this.getRBinDirectoryCandidates(), "R.dll"));
                break;
            }
            case 2: {
                this.putPrepend(envp, "PATH", this.getRHomeDirectory().resolve("bin"));
                if ((options & 1) != 0) break;
                this.putPrepend(envp, "DYLD_LIBRARY_PATH", this.getRHomeDirectory().resolve("lib"));
                break;
            }
            default: {
                this.putPrepend(envp, "PATH", this.getRHomeDirectory().resolve("bin"));
                if ((options & 1) != 0) break;
                this.putPrepend(envp, "LD_LIBRARY_PATH", this.checkLibDirectory(this.getRLibDirectoryCandidates(), "libR.so"));
            }
        }
        if ((options & 1) == 0) {
            String rArch = this.getRArch();
            if (rArch != null && this.isArchAvailable(rArch)) {
                envp.put("R_ARCH", String.valueOf('/') + rArch);
            }
            this.putIfNonNull(envp, "R_SHARE_DIR", this.config.getRShareDirectoryPath());
            this.putIfNonNull(envp, "R_INCLUDE_DIR", this.config.getRIncludeDirectoryPath());
            this.putIfNonNull(envp, "R_DOC_DIR", this.config.getRDocDirectoryPath());
            this.putIfNonNull(envp, "R_LIBS_SITE", this.getLibPathString(this.config.getRLibGroup("r.site")));
            this.putIfNonNull(envp, "R_LIBS_USER", this.getLibPathString(this.config.getRLibGroup("r.user")));
            this.putIfNonNull(envp, "R_LIBS", this.getLibPathString(this.config.getRLibGroup("r.common")));
        }
        envp.put("LC_NUMERIC", "C");
        return envp;
    }

    protected final Path getRHomeDirectory() {
        return (Path)ObjectUtils.nonNullAssert((Object)this.config.getRHomeDirectoryPath());
    }

    protected boolean isArchAvailable(String rArch) {
        try {
            String name;
            Path rHomeBinSub;
            Path rHomeBin = this.getRHomeDirectory().resolve("bin");
            switch (SystemUtils.getLocalOs()) {
                case 1: {
                    rHomeBinSub = rHomeBin;
                    name = "R.exe";
                    break;
                }
                default: {
                    rHomeBinSub = rHomeBin.resolve("exec");
                    name = "R";
                }
            }
            Path file = rHomeBinSub.resolve(rArch).resolve(name);
            return Files.isRegularFile(file, new LinkOption[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected @Nullable Path getArchDirectory(Path baseDirectory) {
        String arch = this.config.getRArch();
        if (arch == null) {
            arch = SystemUtils.getLocalArch();
        }
        switch (arch) {
            case "x86_64": {
                return DefaultLocalConfigurator.getFirstDirectory(baseDirectory, "x86_64", "x64");
            }
            case "x86_32": {
                return DefaultLocalConfigurator.getFirstDirectory(baseDirectory, "x86", "i386", "i586", "i686");
            }
        }
        return DefaultLocalConfigurator.getFirstDirectory(baseDirectory, arch);
    }

    protected List<Path> getRBinDirectoryCandidates() {
        Path rHomeBinArch;
        Path rHomeBinSub;
        ArrayList<Path> directories = new ArrayList<Path>(4);
        Path rHomeBin = this.getRHomeDirectory().resolve("bin");
        switch (SystemUtils.getLocalOs()) {
            case 1: {
                rHomeBinSub = rHomeBin;
                break;
            }
            default: {
                rHomeBinSub = null;
            }
        }
        if (rHomeBinSub != null && (rHomeBinArch = this.getArchDirectory(rHomeBinSub)) != null) {
            directories.add(rHomeBinArch);
        }
        directories.add(rHomeBin);
        return directories;
    }

    protected List<Path> getRLibDirectoryCandidates() {
        Path rHomeLibArch;
        Path rHomeLib;
        ArrayList<Path> directories = new ArrayList<Path>(4);
        switch (SystemUtils.getLocalOs()) {
            case 1: {
                rHomeLib = this.getRHomeDirectory().resolve("bin");
                break;
            }
            default: {
                rHomeLib = this.getRHomeDirectory().resolve("lib");
            }
        }
        if (SystemUtils.getLocalOs() != 2 && (rHomeLibArch = this.getArchDirectory(rHomeLib)) != null) {
            directories.add(rHomeLibArch);
        }
        directories.add(rHomeLib);
        return directories;
    }

    private Path checkLibDirectory(List<Path> candidates, String fileName) throws StatusException {
        Path directory = DefaultLocalConfigurator.getFirstDirectoryWith(this.getRLibDirectoryCandidates(), fileName);
        if (directory == null) {
            REnvCoreInternals.log((Status)new WarningStatus("org.eclipse.statet.rj.services", String.format("Could not find R library directory (file= '%1$s') for R environment '%2$s.", fileName, this.config.getREnv().getId())));
            directory = candidates.get(candidates.size() - 1);
        }
        return directory;
    }

    protected @Nullable String getLibPathString(@Nullable RLibGroup group) {
        if (group == null) {
            return null;
        }
        List<? extends RLibLocation> libLocations = group.getLibLocations();
        if (libLocations.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (RLibLocation rLibLocation : libLocations) {
            Path path = rLibLocation.getDirectoryPath();
            if (path != null) {
                sb.append(this.toEnvVarString(path));
            }
            sb.append(File.pathSeparatorChar);
        }
        return sb.substring(0, sb.length() - 1);
    }

    protected void putIfNonNull(Map<String, String> envp, String name, @Nullable Path path) {
        if (path == null) {
            return;
        }
        String value = this.toEnvVarString(path);
        envp.put(name, value);
    }

    protected void putIfNonNull(Map<String, String> envp, String name, @Nullable String value) {
        if (value == null) {
            return;
        }
        envp.put(name, value);
    }

    protected void putPrepend(Map<String, String> envp, String name, Path path) {
        String value = this.toEnvVarString(path);
        String currentValue = this.getSystemEnvVar(name);
        if (currentValue != null) {
            value = String.valueOf(value) + File.pathSeparatorChar + currentValue;
        }
        envp.put(name, value);
    }

    protected String toEnvVarString(Path path) {
        return path.toString();
    }
}

