/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.command.StructuralRefreshCommandHandler;
import org.eclipse.statet.ecommons.waltable.command.VisualRefreshCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.ecommons.waltable.edit.UpdateDataCommandHandler;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.SizeConfig;
import org.eclipse.statet.ecommons.waltable.layer.SizeConfigDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.layer.event.StructuralRefreshEvent;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;
import org.eclipse.statet.ecommons.waltable.resize.ColumnResizeEvent;
import org.eclipse.statet.ecommons.waltable.resize.MultiColumnResizeCommandHandler;
import org.eclipse.statet.ecommons.waltable.resize.MultiRowResizeCommandHandler;
import org.eclipse.statet.ecommons.waltable.resize.PositionResizeCommandHandler;
import org.eclipse.statet.ecommons.waltable.resize.RowResizeEvent;

public class DataLayer
extends AbstractLayer
implements ILayer {
    public static final String PERSISTENCE_KEY_ROW_HEIGHT = ".rowHeight";
    public static final String PERSISTENCE_KEY_COLUMN_WIDTH = ".columnWidth";
    public static final int DEFAULT_COLUMN_WIDTH = 100;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    protected IDataProvider dataProvider;
    private final long columnIdCat;
    private final SizeConfig columnWidthConfig;
    private final long rowIdCat;
    private final SizeConfig rowHeightConfig;

    public DataLayer(IDataProvider dataProvider, long idCat) {
        this(dataProvider, idCat, 100, idCat, 20);
    }

    public DataLayer(IDataProvider dataProvider, long columnIdCat, int defaultColumnWidth, long rowIdCat, int defaultRowHeight) {
        this(dataProvider, columnIdCat, new SizeConfig(defaultColumnWidth), rowIdCat, new SizeConfig(defaultRowHeight));
    }

    public DataLayer(IDataProvider dataProvider, long columnIdCat, SizeConfig columnWidthConfig, long rowIdCat, SizeConfig rowHeightConfig) {
        this.columnIdCat = columnIdCat;
        this.columnWidthConfig = columnWidthConfig;
        this.rowIdCat = rowIdCat;
        this.rowHeightConfig = rowHeightConfig;
        this.initDims();
        this.registerCommandHandlers();
        this.setDataProvider(dataProvider);
    }

    @Override
    protected void initDims() {
        if (this.columnIdCat == 0L || this.rowIdCat == 0L) {
            return;
        }
        this.setDim(new SizeConfigDim<ILayer>((ILayer)this, Orientation.HORIZONTAL, this.columnIdCat, this.columnWidthConfig){

            @Override
            public long getPositionCount() {
                return DataLayer.this.dataProvider.getColumnCount();
            }
        });
        this.setDim(new SizeConfigDim<ILayer>((ILayer)this, Orientation.VERTICAL, this.rowIdCat, this.rowHeightConfig){

            @Override
            public long getPositionCount() {
                return DataLayer.this.dataProvider.getRowCount();
            }
        });
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        this.columnWidthConfig.saveState(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.saveState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_HEIGHT, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.columnWidthConfig.loadState(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.loadState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_HEIGHT, properties);
        this.fireLayerEvent(new StructuralRefreshEvent(this));
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new PositionResizeCommandHandler(this));
        this.registerCommandHandler(new MultiColumnResizeCommandHandler(this));
        this.registerCommandHandler(new MultiRowResizeCommandHandler(this));
        this.registerCommandHandler(new UpdateDataCommandHandler(this));
        this.registerCommandHandler(new StructuralRefreshCommandHandler());
        this.registerCommandHandler(new VisualRefreshCommandHandler());
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected void setDataProvider(IDataProvider dataProvider) {
        if (this.dataProvider instanceof IPersistable) {
            this.unregisterPersistable((IPersistable)((Object)this.dataProvider));
        }
        this.dataProvider = dataProvider;
        if (dataProvider instanceof IPersistable) {
            this.registerPersistable((IPersistable)((Object)dataProvider));
        }
    }

    public void setColumnWidthByPosition(long columnPosition, int width) {
        this.columnWidthConfig.setSize(columnPosition, width);
        this.fireLayerEvent(new ColumnResizeEvent((ILayer)this, columnPosition));
    }

    public void setDefaultColumnWidth(int width) {
        this.columnWidthConfig.setDefaultSize(width);
    }

    public void setDefaultColumnWidthByPosition(long columnPosition, int width) {
        this.columnWidthConfig.setDefaultSize(columnPosition, width);
    }

    public void setColumnPositionResizable(long columnPosition, boolean resizable) {
        this.columnWidthConfig.setPositionResizable(columnPosition, resizable);
    }

    public void setColumnsResizableByDefault(boolean resizableByDefault) {
        this.columnWidthConfig.setResizableByDefault(resizableByDefault);
    }

    public void setRowHeightByPosition(long rowPosition, int height) {
        this.rowHeightConfig.setSize(rowPosition, height);
        this.fireLayerEvent(new RowResizeEvent((ILayer)this, rowPosition));
    }

    public void setDefaultRowHeight(int height) {
        this.rowHeightConfig.setDefaultSize(height);
    }

    public void setDefaultRowHeightByPosition(long rowPosition, int height) {
        this.rowHeightConfig.setDefaultSize(rowPosition, height);
    }

    public void setRowPositionResizable(long rowPosition, boolean resizable) {
        this.rowHeightConfig.setPositionResizable(rowPosition, resizable);
    }

    public void setRowsResizableByDefault(boolean resizableByDefault) {
        this.rowHeightConfig.setResizableByDefault(resizableByDefault);
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        ILayerDim hDim = this.getDim(Orientation.HORIZONTAL);
        ILayerDim vDim = this.getDim(Orientation.VERTICAL);
        long columnId = hDim.getPositionId(columnPosition, columnPosition);
        long rowId = vDim.getPositionId(rowPosition, rowPosition);
        return new DataLayerCell((ILayerCellDim)new LayerCellDim(Orientation.HORIZONTAL, columnId, columnPosition), (ILayerCellDim)new LayerCellDim(Orientation.VERTICAL, rowId, rowPosition));
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        return null;
    }

    protected class DataLayerCell
    extends LayerCell {
        public DataLayerCell(ILayerCellDim horizontalDim, ILayerCellDim verticalDim) {
            super(DataLayer.this, horizontalDim, verticalDim);
        }

        @Override
        public Object getDataValue(int flags, IProgressMonitor monitor) {
            return DataLayer.this.dataProvider.getDataValue(this.getColumnPosition(), this.getRowPosition(), flags, monitor);
        }
    }
}

