/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.AbstractLayer;
import org.eclipse.statet.ecommons.waltable.selection.SelectDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportSelectDimPositionsCommand;

public class ViewportSelectDimPositionsCommandHandler
extends AbstractLayerCommandHandler<ViewportSelectDimPositionsCommand> {
    private final AbstractLayer viewportLayer;
    private final Orientation orientation;

    public ViewportSelectDimPositionsCommandHandler(AbstractLayer viewportLayer) {
        this(viewportLayer, null);
    }

    public ViewportSelectDimPositionsCommandHandler(AbstractLayer viewportLayer, Orientation orientation) {
        this.viewportLayer = viewportLayer;
        this.orientation = orientation;
    }

    @Override
    public Class<ViewportSelectDimPositionsCommand> getCommandClass() {
        return ViewportSelectDimPositionsCommand.class;
    }

    @Override
    protected boolean doCommand(ViewportSelectDimPositionsCommand command) {
        if (this.orientation != null && command.getOrientation() != this.orientation) {
            return false;
        }
        this.viewportLayer.doCommand(new SelectDimPositionsCommand(this.viewportLayer.getDim(command.getOrientation()), command.getRefPosition(), command.getPositions(), 0L, command.getSelectionFlags(), command.getPositionToReveal()));
        return true;
    }
}

