/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.debug.ui.ECommonsDebugUIResources;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.statushandlers.StatusManager;

public class ECommonsDebugUIImageDescriptor
extends CompositeImageDescriptor {
    public static final int ENABLED = 1;
    public static final int INSTALLED = 2;
    public static final int SCRIPT = 16;
    public static final int CONDITIONAL = 256;
    public static final int ENTRY = 4096;
    public static final int EXIT = 8192;
    private final ImageDescriptor baseImage;
    private final int flags;
    private final Point size;

    private static ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.statet.ecommons.debug.ui", "Image data not available: " + descriptor.toString()));
        }
        return data;
    }

    public ECommonsDebugUIImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        if (baseImage == null) {
            throw new NullPointerException("baseImage");
        }
        this.baseImage = baseImage;
        this.flags = flags;
        if (size != null) {
            this.size = size;
        } else {
            ImageData data = ECommonsDebugUIImageDescriptor.getImageData(baseImage);
            this.size = new Point(data.width, data.height);
        }
    }

    protected final ImageDescriptor getBaseImage() {
        return this.baseImage;
    }

    protected final int getFlags() {
        return this.flags;
    }

    protected final Point getSize() {
        return this.size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData data = ECommonsDebugUIImageDescriptor.getImageData(this.getBaseImage());
        this.drawImage(data, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        ImageData data;
        int y;
        int x;
        int flags = this.getFlags();
        if (flags == 0) {
            return;
        }
        ECommonsDebugUIResources commonsUIResources = ECommonsDebugUIResources.INSTANCE;
        if ((flags & 0x12) == 2) {
            x = 0;
            y = this.getSize().y;
            data = ECommonsDebugUIImageDescriptor.getImageData(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.Installed" : "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.Installed.disabled"));
            this.drawImage(data, 0, y -= data.height);
        }
        if ((flags & 0x100) != 0) {
            x = 0;
            y = 0;
            data = ECommonsDebugUIImageDescriptor.getImageData(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.Conditional" : "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.Conditional.disabled"));
            this.drawImage(data, 0, 0);
        }
        if ((flags & 0x1000) != 0) {
            x = this.getSize().x;
            y = 0;
            data = ECommonsDebugUIImageDescriptor.getImageData(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.MethodEntry" : "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.MethodEntry.disabled"));
            x -= data.width;
            this.drawImage(data, --x, 0);
        }
        if ((flags & 0x2000) != 0) {
            x = this.getSize().x;
            y = this.getSize().y;
            data = ECommonsDebugUIImageDescriptor.getImageData(commonsUIResources.getImageDescriptor((flags & 1) != 0 ? "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.MethodExit" : "org.eclipse.statet.ecommons.debugimage/ovr/Breakpoint.MethodExit.disabled"));
            x -= data.width;
            this.drawImage(data, --x, y -= data.height);
        }
    }

    public int hashCode() {
        return (this.baseImage.hashCode() ^ this.flags) + this.size.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass())) {
            ECommonsDebugUIImageDescriptor other = (ECommonsDebugUIImageDescriptor)((Object)obj);
            return this.baseImage.equals(other.baseImage) && this.flags == other.flags && this.size.equals((Object)other.size);
        }
        return false;
    }
}

