/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.text.r;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartition;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.rsource.RLexer;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.text.r.RBracketPairMatcher;

@NonNullByDefault
public class RDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private final String partitioning;
    private final ICharPairMatcher pairMatcher;
    private final RHeuristicTokenScanner scanner;

    public RDoubleClickStrategy(RHeuristicTokenScanner scanner) {
        this.scanner = scanner;
        this.partitioning = scanner.getDocumentPartitioning();
        this.pairMatcher = new RBracketPairMatcher(this.scanner);
    }

    public RDoubleClickStrategy(RHeuristicTokenScanner scanner, ICharPairMatcher pairMatcher) {
        this.scanner = scanner;
        this.partitioning = scanner.getDocumentPartitioning();
        this.pairMatcher = pairMatcher;
    }

    private @Nullable TreePartition getPartition(IDocument document, int offset) throws BadLocationException {
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)this.partitioning, (int)offset, (boolean)false);
        if (partition instanceof TreePartition) {
            return (TreePartition)partition;
        }
        return null;
    }

    public void doubleClicked(ITextViewer textViewer) {
        IDocument document = textViewer.getDocument();
        int offset = textViewer.getSelectedRange().x;
        if (document == null || offset < 0) {
            return;
        }
        try {
            IRegion region = null;
            TreePartition partition = this.getPartition(document, offset);
            if (partition != null) {
                IRegion match;
                if (partition.getType() == "R.Default" && (match = this.pairMatcher.match(document, offset)) != null && match.getLength() >= 2) {
                    region = new Region(match.getOffset() + 1, match.getLength() - 2);
                }
                if (region == null) {
                    region = this.getOpenClose(document, partition, offset);
                }
                if (region == null && partition.getOffset() == offset && offset > 0 && (partition = this.getPartition(document, offset - 1)) != null) {
                    region = this.getOpenClose(document, partition, offset);
                }
            }
            if (region == null) {
                this.scanner.configure(document);
                region = this.scanner.findRWord(offset, true, false);
            }
            if (region == null) {
                region = this.scanner.findBlankRegion(offset, false);
            }
            if (region != null) {
                textViewer.setSelectedRange(region.getOffset(), region.getLength());
                return;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        textViewer.setSelectedRange(offset, 0);
    }

    private final @Nullable IRegion getOpenClose(IDocument document, TreePartition partition, int offset) throws BadLocationException {
        if (partition.getType() == "R.String" || partition.getType() == "R.QuotedSymbol") {
            TextRegion textRegion = this.getTextRegion(document, partition);
            if (textRegion == null) {
                return null;
            }
            if (offset >= partition.getStartOffset() && offset <= textRegion.getStartOffset() || offset <= partition.getEndOffset() && offset >= textRegion.getEndOffset()) {
                return JFaceTextRegion.toJFaceRegion((TextRegion)textRegion);
            }
            this.scanner.configure(document);
            IRegion region = this.scanner.findCommonWord(offset);
            if (region != null) {
                return region;
            }
            return new Region(offset, 0);
        }
        if (partition.getType() == "R.Op.Infix") {
            return partition;
        }
        if (!(partition.getType() != "R.Comment" && partition.getType() != "R.Roxygen" || offset != partition.getStartOffset() && offset != partition.getStartOffset() + 1)) {
            return partition;
        }
        return null;
    }

    private final @Nullable TextRegion getTextRegion(IDocument document, TreePartition partition) throws BadLocationException {
        RLexer rLexer = new RLexer(16);
        int partitionStart = partition.getOffset();
        IRegion lineInformation = document.getLineInformationOfOffset(partitionStart);
        int parseEnd = Math.min(partitionStart + partition.getLength(), lineInformation.getOffset() + lineInformation.getLength());
        rLexer.reset((TextParserInput)new StringParserInput(document.get(partitionStart, parseEnd - partitionStart)).init());
        switch (rLexer.next()) {
            case SYMBOL_G: 
            case STRING_D: 
            case STRING_S: 
            case STRING_R: {
                TextRegion textRegion = rLexer.getTextRegion();
                if (textRegion == null) {
                    return null;
                }
                if ((partition.getTreeNode().getFlags() & 0x100) != 0) {
                    return new BasicTextRegion(partitionStart + textRegion.getStartOffset(), partition.getOffset() + partition.getLength());
                }
                switch (rLexer.getType()) {
                    case SYMBOL_G: 
                    case STRING_D: 
                    case STRING_S: {
                        return new BasicTextRegion(partitionStart + textRegion.getStartOffset(), partitionStart + partition.getLength() - 1);
                    }
                    case STRING_R: {
                        return new BasicTextRegion(partitionStart + textRegion.getStartOffset(), partitionStart + partition.getLength() - textRegion.getStartOffset() + 1);
                    }
                }
                throw new AssertionError();
            }
        }
        return null;
    }
}

