/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;

public class FixDocumentPartitioner
implements IDocumentPartitioner {
    private final String[] contentTypes;
    private IDocument document;
    private final List<ITypedRegion> partitions = new ArrayList<ITypedRegion>();

    public FixDocumentPartitioner(String[] contentTypes) {
        this.contentTypes = contentTypes;
    }

    public void append(String contentType, int length) {
        if (this.partitions.isEmpty()) {
            this.partitions.add((ITypedRegion)new TypedRegion(0, length, contentType));
        } else {
            ITypedRegion previous = this.partitions.get(this.partitions.size() - 1);
            if (previous.getType() == contentType) {
                this.partitions.set(this.partitions.size() - 1, (ITypedRegion)new TypedRegion(previous.getOffset(), previous.getLength() + length, contentType));
            } else {
                this.partitions.add((ITypedRegion)new TypedRegion(previous.getOffset() + previous.getLength(), length, contentType));
            }
        }
    }

    public void connect(IDocument document) {
        this.document = document;
    }

    public void disconnect() {
        this.document = null;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return true;
    }

    public String[] getLegalContentTypes() {
        return this.contentTypes;
    }

    private int indexOf(int offset, boolean prefereOpen) {
        ITypedRegion partition;
        int last = this.partitions.size() - 1;
        int i = 0;
        if (prefereOpen) {
            while (i < last) {
                partition = this.partitions.get(i);
                if (offset < partition.getOffset() + partition.getLength()) {
                    return i;
                }
                ++i;
            }
        }
        while (i <= last) {
            partition = this.partitions.get(i);
            if (offset <= partition.getOffset() + partition.getLength()) {
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("offset: " + Integer.toString(offset));
    }

    public String getContentType(int offset) {
        return this.partitions.get(this.indexOf(offset, false)).getType();
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        int startIdx = this.indexOf(offset, false);
        int endIdx = this.indexOf(offset + length, true);
        List<ITypedRegion> list = this.partitions.subList(startIdx, endIdx);
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        return this.partitions.get(this.indexOf(offset, false));
    }
}

