/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rlang;

import java.util.Arrays;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class RTokens {
    public static final String[] CONSTANT_WORDS = new String[]{"NULL", "NA", "NA_real_", "NA_integer_", "NA_complex_", "NA_character_", "Inf", "NaN", "TRUE", "FALSE"};
    public static final String[] FLOWCONTROL_WORDS = new String[]{"if", "else", "for", "in", "while", "repeat", "next", "break", "function"};
    public static final String[] PREDIFINED_INFIX_OPERATORS = new String[]{"%%", "%*%", "%/%", "%in%", "%o%", "%x%"};
    private static final char[] SEPARATOR_CHARS = new char[]{'!', '$', '%', '&', '(', ')', '*', '+', ',', '-', '/', ':', ';', '<', '=', '>', '[', ']', '^', '{', '|', '}', '~', '@'};
    private static final char[] WHITESPACE_CHARS = new char[]{' ', '\t'};
    private static final char[] NEWLINE_CHARS = new char[]{'\r', '\n'};
    private static boolean[] SEPARATOR_MAP = new boolean[128];

    static {
        Arrays.fill(SEPARATOR_MAP, false);
        int i = 0;
        while (i < SEPARATOR_CHARS.length) {
            RTokens.SEPARATOR_MAP[RTokens.SEPARATOR_CHARS[i]] = true;
            ++i;
        }
        i = 0;
        while (i < WHITESPACE_CHARS.length) {
            RTokens.SEPARATOR_MAP[RTokens.WHITESPACE_CHARS[i]] = true;
            ++i;
        }
        i = 0;
        while (i < NEWLINE_CHARS.length) {
            RTokens.SEPARATOR_MAP[RTokens.NEWLINE_CHARS[i]] = true;
            ++i;
        }
    }

    public static boolean isSeparator(int c) {
        return c < 0 || c <= 127 && SEPARATOR_MAP[c];
    }

    public static boolean isRobustSeparator(int c, boolean isDotSeparator) {
        switch (c) {
            case 46: {
                return isDotSeparator;
            }
            case 95: {
                return false;
            }
        }
        return !Character.isLetterOrDigit(c);
    }

    public static boolean isRobustSeparator(int c) {
        switch (c) {
            case 46: 
            case 95: {
                return false;
            }
        }
        return !Character.isLetterOrDigit(c);
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public static boolean isHexDigit(int c) {
        return c >= 48 && (c <= 57 || c >= 65 && (c <= 70 || c >= 97 && c <= 102));
    }

    public static boolean isWhitespace(int c) {
        switch (c) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

