/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.config;

import org.eclipse.statet.ecommons.waltable.config.AbstractRegistryConfiguration;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.TextPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.statet.ecommons.waltable.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.style.Style;
import org.eclipse.statet.ecommons.waltable.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class DefaultColumnHeaderStyleConfiguration
extends AbstractRegistryConfiguration {
    public Font font = GUIHelper.getFont(new FontData("Verdana", 10, 0));
    public Color bgColor = GUIHelper.COLOR_WIDGET_BACKGROUND;
    public Color fgColor = GUIHelper.COLOR_WIDGET_FOREGROUND;
    public Color gradientBgColor = GUIHelper.COLOR_WHITE;
    public Color gradientFgColor = GUIHelper.getColor(136, 212, 215);
    public HorizontalAlignment hAlign = HorizontalAlignment.CENTER;
    public VerticalAlignment vAlign = VerticalAlignment.MIDDLE;
    public BorderStyle borderStyle = null;
    public ICellPainter cellPainter = new BeveledBorderDecorator(new TextPainter());

    @Override
    public void configureRegistry(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, this.cellPainter, DisplayMode.NORMAL, "COLUMN_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, this.cellPainter, DisplayMode.NORMAL, "CORNER");
        Style cellStyle = new Style();
        cellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, this.bgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, this.fgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_BACKGROUND_COLOR, this.gradientBgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.GRADIENT_FOREGROUND_COLOR, this.gradientFgColor);
        cellStyle.setAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT, this.hAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT, this.vAlign);
        cellStyle.setAttributeValue(CellStyleAttributes.BORDER_STYLE, this.borderStyle);
        cellStyle.setAttributeValue(CellStyleAttributes.FONT, this.font);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.NORMAL, "COLUMN_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, cellStyle, DisplayMode.NORMAL, "CORNER");
    }
}

