/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserSession;
import org.eclipse.statet.ecommons.ui.mpbv.ManagedPageBookView;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserPage;
import org.eclipse.statet.ecommons.ui.mpbv.PageBookBrowserView;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.IBreadcrumb;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpBreadcrumb;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpLabelProvider;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.rhelp.core.RHelpUtils;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class RHelpViewPage
extends PageBookBrowserPage
implements IAdaptable {
    private IBreadcrumb breadcrumb;
    private Control breadcrumbControl;
    private @Nullable Object helpObject;
    private final ILabelProvider labelProvider = new RHelpLabelProvider();

    public RHelpViewPage(PageBookBrowserView view, BrowserSession session) {
        super((ManagedPageBookView)view, session);
    }

    public void dispose() {
        super.dispose();
        this.labelProvider.dispose();
    }

    public Object getHelpObject() {
        return this.helpObject;
    }

    public void setUrl(@Nullable String url) {
        if (url != null && url.startsWith("erhelp:")) {
            try {
                URI uri = new URI(url);
                uri = RCore.getRHelpHttpService().toHttpUrl(uri);
                super.setUrl(uri);
                return;
            }
            catch (URISyntaxException e) {
                return;
            }
        }
        super.setUrl(url);
    }

    public void setUrl(@Nullable URI url) {
        if (url != null && url.getScheme().equals("erhelp")) {
            try {
                url = RCore.getRHelpHttpService().toHttpUrl(url);
            }
            catch (URISyntaxException e) {
                return;
            }
        }
        super.setUrl(url);
    }

    protected Control createAddressBar(Composite parent) {
        this.breadcrumb = new RHelpBreadcrumb(this);
        if (this.breadcrumb != null) {
            this.breadcrumbControl = this.breadcrumb.createContent(parent);
            this.updateBreadcrumbInput();
        }
        return this.breadcrumbControl;
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        super.initActions(serviceLocator, handlers);
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        IContextService contextService = (IContextService)serviceLocator.getService(IContextService.class);
        AbstractHandler breadcrumbHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                if (RHelpViewPage.this.breadcrumb != null) {
                    RHelpViewPage.this.breadcrumb.activate();
                }
                return null;
            }
        };
        handlers.add("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb", (IHandler2)breadcrumbHandler);
        handlerService.activateHandler("org.eclipse.jdt.ui.edit.text.java.gotoBreadcrumb", (IHandler)breadcrumbHandler);
        contextService.activateContext("org.eclipse.statet.ecommons.ui.viewers.contexts.WithBreadcrumbContext");
    }

    protected void onPageChanged() {
        super.onPageChanged();
        try {
            Object input;
            BrowserSession session = this.getSession();
            this.helpObject = input = RCore.getRHelpHttpService().getContentOfUrl(session.getUrl());
            Image image = this.labelProvider.getImage(input);
            if (image != null) {
                RHelpViewPage.setIcon((BrowserSession)session, (ImageDescriptor)ImageDescriptor.createFromImage((Image)image));
            }
            this.updateBreadcrumbInput();
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, "An error occurred when updating the R help view address bar/breadcrumbs.", (Throwable)e));
        }
    }

    public void changed(TitleEvent event) {
        super.changed(event);
        if (this.helpObject == null) {
            this.updateBreadcrumbInput();
        }
    }

    private void showBreadcrumb() {
        if (this.breadcrumb == null || this.breadcrumbControl.isVisible()) {
            return;
        }
        this.breadcrumbControl.setVisible(true);
        this.breadcrumbControl.getParent().layout(true, true);
    }

    private void hideBreadcrumb() {
        if (this.breadcrumb == null || !this.breadcrumbControl.isVisible()) {
            return;
        }
        this.breadcrumbControl.setVisible(false);
        this.breadcrumbControl.getParent().layout(true, true);
    }

    private void updateBreadcrumbInput() {
        if (this.breadcrumb == null) {
            return;
        }
        Object input = this.helpObject;
        if (input == null) {
            if (this.getCurrentUrl().length() > 0) {
                input = this.getCurrentTitle();
            }
        } else if (input instanceof Object[]) {
            Object[] array = (Object[])input;
            if (array.length >= 2) {
                array[array.length - 1] = this.getCurrentTitle();
            } else {
                input = null;
            }
        }
        this.breadcrumb.setInput(input);
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == REnv.class) {
            Object input = this.helpObject;
            if (input != null) {
                if (input instanceof REnv) {
                    return (T)input;
                }
                return (T)RHelpUtils.getREnv((Object)input);
            }
            return null;
        }
        return null;
    }
}

