/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.content;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.statet.ecommons.ui.components.IIntValueListener;
import org.eclipse.statet.ecommons.ui.components.IntValueEvent;
import org.eclipse.statet.ecommons.ui.components.WaScale;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class IntValue2Double2TextBinding
extends AbstractObservableValue
implements IIntValueListener,
Listener {
    private static IConverter gDouble2TextConverter;
    private static IConverter gText2DoubleConverter;
    private final WaScale fIntWidget;
    private final int fIdx;
    private final Text fTextWidget;
    private boolean fIgnoreChanges;
    private double fLastValue;
    private String fLastText;
    private boolean fCorrect;
    private final IConverter fDouble2TextConverter;
    private final IConverter fText2IntConverter;
    private double fBias = 0.0;
    private double fFactor = 1.0;

    static {
        class Access
        extends UpdateValueStrategy {
            Access() {
            }

            public IConverter createConverter(Object fromType, Object toType) {
                return super.createConverter(fromType, toType);
            }
        }
        Access access = new Access();
        gDouble2TextConverter = access.createConverter(Double.TYPE, String.class);
        gText2DoubleConverter = access.createConverter(String.class, Double.TYPE);
    }

    public IntValue2Double2TextBinding(WaScale scale, int knobIdx, Text text, Realm realm, IConverter double2textConverter, IConverter text2doubleConverter) {
        super(realm);
        if (scale == null) {
            throw new NullPointerException("scale");
        }
        if (text == null) {
            throw new NullPointerException("text");
        }
        this.fIntWidget = scale;
        this.fIdx = knobIdx;
        this.fTextWidget = text;
        scale.addValueListener(this);
        text.addListener(24, (Listener)this);
        text.addListener(16, (Listener)this);
        this.fLastText = this.fTextWidget.getText();
        if (double2textConverter != null) {
            if (!double2textConverter.getFromType().equals(Double.TYPE) || !double2textConverter.getToType().equals(String.class)) {
                throw new IllegalArgumentException("int2TextConverter");
            }
        } else {
            double2textConverter = gDouble2TextConverter;
        }
        this.fDouble2TextConverter = double2textConverter;
        if (text2doubleConverter != null) {
            if (!text2doubleConverter.getFromType().equals(String.class) || !text2doubleConverter.getToType().equals(Double.TYPE)) {
                throw new IllegalArgumentException("text2IntConverter");
            }
        } else {
            text2doubleConverter = gText2DoubleConverter;
        }
        this.fText2IntConverter = text2doubleConverter;
    }

    @Override
    public void valueAboutToChange(IntValueEvent event) {
        if (event.valueIdx != this.fIdx) {
            return;
        }
        event.newValue = this.double2int(this.checkValue(this.int2double(event.newValue)));
    }

    @Override
    public void valueChanged(IntValueEvent event) {
        if (event.valueIdx != this.fIdx) {
            return;
        }
        this.setValue(this.checkValue(this.int2double(event.newValue)), false);
    }

    protected void setValue(double value, boolean updateKnob) {
        if (this.fIgnoreChanges) {
            return;
        }
        this.fIgnoreChanges = true;
        try {
            String text = this.double2text(value);
            this.fTextWidget.setText(text);
            if (updateKnob) {
                this.fIntWidget.setValue(this.fIdx, this.double2int(value));
            }
            this.fCorrect = false;
            this.setLast(value, text);
        }
        finally {
            this.fIgnoreChanges = false;
        }
    }

    protected void setLast(double value, String text) {
        ValueDiff diff = this.fLastValue != value ? Diffs.createValueDiff((Object)this.fLastValue, (Object)value) : null;
        this.fLastValue = value;
        this.fLastText = text;
        if (diff != null) {
            this.fireValueChange(diff);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleEvent(Event event) {
        switch (event.type) {
            case 24: {
                if (this.fIgnoreChanges) {
                    return;
                }
                this.fIgnoreChanges = true;
                try {
                    try {
                        String text = this.fTextWidget.getText();
                        double value = this.text2double(text);
                        double validValue = this.checkValue(value);
                        this.fIntWidget.setValue(this.fIdx, this.double2int(validValue));
                        if (value == validValue) {
                            this.fCorrect = false;
                            this.setLast(value, text);
                            return;
                        }
                        this.fCorrect = true;
                        this.setLast(validValue, this.double2text(validValue));
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        this.fCorrect = true;
                        this.fIgnoreChanges = false;
                    }
                    return;
                }
                finally {
                    this.fIgnoreChanges = false;
                }
            }
            case 16: {
                try {
                    if (!this.fCorrect) return;
                    this.fTextWidget.setText(this.fLastText);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    protected double text2double(String text) {
        return (Double)this.fText2IntConverter.convert((Object)text);
    }

    protected int double2int(double value) {
        return (int)Math.round((value - this.fBias) * this.fFactor);
    }

    protected double int2double(int value) {
        return (double)value / this.fFactor + this.fBias;
    }

    protected String double2text(double value) {
        return (String)this.fDouble2TextConverter.convert((Object)value);
    }

    public void setFactor(double bias, double factor) {
        this.fBias = bias;
        this.fFactor = factor;
    }

    public double checkValue(double value) {
        return value;
    }

    public Object getValueType() {
        return this.fDouble2TextConverter.getFromType();
    }

    protected void doSetValue(Object value) {
        this.setValue(value != null ? (Double)value : 0.0, true);
    }

    protected Object doGetValue() {
        return this.fLastValue;
    }

    public static class LowerUpperGroup {
        private final int FACTOR_TARGET_UP = 0x73333332;
        private final int FACTOR_TARGET_LOW = 1739461753;
        private final WaScale fScale;
        private final IntValue2Double2TextBinding fLower;
        private final IntValue2Double2TextBinding fUpper;
        private double fMin;
        private double fMax;

        public LowerUpperGroup(WaScale scale, Text lowerText, Text upperText, Realm realm, IConverter double2textConverter, IConverter text2doubleConverter) {
            this.fScale = scale;
            this.fLower = new IntValue2Double2TextBinding(scale, 0, lowerText, realm, double2textConverter, text2doubleConverter){

                @Override
                public double checkValue(double value) {
                    if (value > fUpper.fLastValue) {
                        value = fUpper.fLastValue;
                    }
                    return this.checkMinMax(value);
                }
            };
            this.fUpper = new IntValue2Double2TextBinding(scale, 1, upperText, realm, double2textConverter, text2doubleConverter){

                @Override
                public double checkValue(double value) {
                    if (value < fLower.fLastValue) {
                        value = fLower.fLastValue;
                    }
                    return this.checkMinMax(value);
                }
            };
        }

        public IntValue2Double2TextBinding getLower() {
            return this.fLower;
        }

        public IntValue2Double2TextBinding getUpper() {
            return this.fUpper;
        }

        private double checkMinMax(double value) {
            if (value < this.fMin) {
                return this.fMin;
            }
            if (value > this.fMax) {
                return this.fMax;
            }
            return value;
        }

        public void setMinMax(double min, double max) {
            this.fMin = min;
            this.fMax = max;
            double bias = min;
            double factor = 1.0;
            double range = max - min;
            if (range > 1.932735282E9 || range < 1.739461753E9) {
                factor = 1.932735282E9 / range;
            }
            this.fLower.setFactor(bias, factor);
            this.fUpper.setFactor(bias, factor);
            this.fScale.setMinimum(this.fLower.double2int(min));
            this.fScale.setMaximum(this.fUpper.double2int(max));
            this.fScale.setIncrement(Math.max(1, (this.fScale.getMaximum() - this.fScale.getMinimum()) / 100));
            this.fScale.setPageIncrement(Math.max(10, (this.fScale.getMaximum() - this.fScale.getMinimum()) / 10));
            this.fLower.setValue(this.fLower.getValue());
            this.fUpper.setValue(this.fUpper.getValue());
        }
    }
}

