/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class LTKUIPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.ltk.ui";
    private static LTKUIPlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();
    private WorkbenchLabelProvider workbenchLabelProvider;

    public static LTKUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        LTKUIPlugin plugin = LTKUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            LTKUIPlugin lTKUIPlugin = this;
            synchronized (lTKUIPlugin) {
                this.started = false;
                if (this.workbenchLabelProvider != null) {
                    try {
                        if (PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isClosing()) {
                            this.workbenchLabelProvider.dispose();
                        }
                    }
                    catch (Exception e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, BUNDLE_ID, -1, "An error occurred when disposing the shared WorkbenchLabelProvider.", (Throwable)e));
                    }
                    this.workbenchLabelProvider = null;
                }
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    LTKUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, "Error occured when dispose module", e));
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        LTKUIPlugin lTKUIPlugin = this;
        synchronized (lTKUIPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.ltk.ui/image/obj/text.template", "obj_16", "text-template.png");
        util.register("org.eclipse.statet.ltk.ui/image/obj/text.at_tag", "obj_16", "text-at_tag.png");
        util.register("org.eclipse.statet.ltk.ui/image/obj/assist.linked_rename", "obj_16", "text-linked_rename.png");
    }

    public synchronized WorkbenchLabelProvider getWorkbenchLabelProvider() {
        if (this.workbenchLabelProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.workbenchLabelProvider = new WorkbenchLabelProvider();
        }
        return this.workbenchLabelProvider;
    }
}

