/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;

public abstract class AbstractRObject
implements RObject {
    protected static final RObject[] EMPTY_ROBJECT_ARRAY = new RObject[0];
    protected static final RObject[][] EMPTY_ROBJECT_2dARRAY = new RObject[0][];
    private RList attributes;

    protected static final long check2dArrayLength(RObject[][] array, int segmentLength) {
        long length = 0L;
        if (array.length > 0) {
            int last = array.length - 1;
            int i = 0;
            while (i < last) {
                if (array[i].length != segmentLength) {
                    throw new IllegalArgumentException("Unexpected list segment length (" + array[i].length + ", but " + segmentLength + " expected)");
                }
                ++i;
            }
            length = (long)last * (long)segmentLength;
            if (array[last].length > segmentLength) {
                throw new IllegalArgumentException("Unexpected list segment length (" + array[last].length + ", but max " + segmentLength + " expected)");
            }
            length += (long)array[last].length;
        }
        return length;
    }

    protected static final RObject[][] new2dRObjectArray(long length, int segmentLength) {
        if (length == 0L) {
            return EMPTY_ROBJECT_2dARRAY;
        }
        RObject[][] array = new RObject[1 + (int)((length - 1L) / (long)segmentLength)][];
        int last = array.length - 1;
        int i = 0;
        while (i < last) {
            array[i] = new RObject[segmentLength];
            ++i;
        }
        int restLength = (int)(length % (long)segmentLength);
        array[last] = new RObject[restLength == 0 ? segmentLength : restLength];
        return array;
    }

    protected static final int checkShortLength(long length) throws IOException {
        if (length >= Integer.MAX_VALUE) {
            throw new IOException("Long length (" + length + ") not supported by this implementation.");
        }
        return (int)length;
    }

    protected static final int getNewArraySize(int length) {
        if (length >= 0xFFFFFFF) {
            return Integer.MAX_VALUE;
        }
        return (length + 7 | 0xF) + 1;
    }

    protected static final RObject[] ensureCapacity(RObject[] currentValues, int length) {
        if (currentValues.length >= length) {
            return currentValues;
        }
        return new RObject[AbstractRObject.getNewArraySize(length)];
    }

    protected static final RStore<?>[] ensureCapacity(RStore<?>[] currentValues, int length) {
        if (currentValues.length >= length) {
            return currentValues;
        }
        return new RStore[AbstractRObject.getNewArraySize(length)];
    }

    protected static final RObject[] prepareInsert(RObject[] currentValues, int currentLength, int[] idxs) {
        RObject[] newValues = AbstractRObject.ensureCapacity(currentValues, currentLength + idxs.length);
        int i = idxs.length - 1;
        System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, currentLength - idxs[i]);
        --i;
        while (i >= 0) {
            System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, idxs[i + 1] - idxs[i]);
            --i;
        }
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        return newValues;
    }

    protected static final RStore<?>[] prepareInsert(RStore<?>[] currentValues, int currentLength, int[] idxs) {
        RStore<?>[] newValues = AbstractRObject.ensureCapacity(currentValues, currentLength + idxs.length);
        int i = idxs.length - 1;
        System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, currentLength - idxs[i]);
        --i;
        while (i >= 0) {
            System.arraycopy(currentValues, idxs[i], newValues, idxs[i] + i + 1, idxs[i + 1] - idxs[i]);
            --i;
        }
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        return newValues;
    }

    protected static final RObject[] remove(RObject[] currentValues, int currentLength, int[] idxs) {
        RObject[] newValues = AbstractRObject.ensureCapacity(currentValues, currentLength - idxs.length);
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        int i = 0;
        while (i < idxs.length - 1) {
            System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, idxs[i + 1] - idxs[i]);
            ++i;
        }
        System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, currentLength - idxs[i] - 1);
        return newValues;
    }

    protected static final RStore<?>[] remove(RStore<?>[] currentValues, int currentLength, int[] idxs) {
        RStore<?>[] newValues = AbstractRObject.ensureCapacity(currentValues, currentLength - idxs.length);
        if (currentValues != newValues) {
            System.arraycopy(currentValues, 0, newValues, 0, idxs[0]);
        }
        int i = 0;
        while (i < idxs.length - 1) {
            System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, idxs[i + 1] - idxs[i]);
            ++i;
        }
        System.arraycopy(currentValues, idxs[i] + 1, newValues, idxs[i] - i, currentLength - idxs[i] - 1);
        return newValues;
    }

    protected void setAttributes(RList attributes) {
        this.attributes = attributes;
    }

    @Override
    public final RList getAttributes() {
        return this.attributes;
    }
}

