/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config.actions;

import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;

@NonNullByDefault
public class RunActiveConfigLaunchShortcut<TElement>
implements ILaunchShortcut {
    private final ActionUtil<TElement> util;
    private final ImIdentitySet<String> launchFlags;

    public RunActiveConfigLaunchShortcut(ActionUtil<TElement> util, ImIdentitySet<String> launchFlags) {
        this.util = util;
        this.launchFlags = launchFlags;
    }

    public RunActiveConfigLaunchShortcut(ActionUtil<TElement> util) {
        this(util, (ImIdentitySet<String>)ImCollections.newIdentitySet());
    }

    protected ActionUtil<TElement> getUtil() {
        return this.util;
    }

    protected ImIdentitySet<String> getLaunchFlags() {
        return this.launchFlags;
    }

    public void launch(ISelection selection, String mode) {
        IWorkbenchWindow window = ActionUtil.getWindow(null);
        @Nullable TElement element = this.util.getLaunchElement(selection);
        if (element == null) {
            return;
        }
        LaunchConfigManager<TElement> manager = this.util.getManager(window, element);
        if (manager == null) {
            return;
        }
        this.util.launchActive(window, manager, element, this.launchFlags);
    }

    public void launch(IEditorPart editor, String mode) {
        IWorkbenchWindow window = editor.getEditorSite().getWorkbenchWindow();
        @Nullable TElement element = this.util.getLaunchElement(editor);
        if (element == null) {
            return;
        }
        LaunchConfigManager<TElement> manager = this.util.getManager(window, element);
        if (manager == null) {
            return;
        }
        this.util.launchActive(window, manager, element, this.getLaunchFlags());
    }
}

