/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.resize;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.command.AbstractDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.command.LayerCommandUtil;
import org.eclipse.statet.ecommons.waltable.coordinate.ColumnPositionCoordinate;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;

public class MultiColumnResizeCommand
extends AbstractDimPositionsCommand {
    private int commonColumnWidth = -1;
    protected Map<ColumnPositionCoordinate, Integer> colPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>();

    public MultiColumnResizeCommand(ILayer layer, Collection<LRange> columnPositions, int commonColumnWidth) {
        super(layer.getDim(Orientation.HORIZONTAL), columnPositions);
        this.commonColumnWidth = commonColumnWidth;
    }

    public MultiColumnResizeCommand(ILayer layer, long[] columnPositions, int[] columnWidths) {
        super(layer.getDim(Orientation.HORIZONTAL), new LRangeList(columnPositions));
        int i = 0;
        while (i < columnPositions.length) {
            this.colPositionToWidth.put(new ColumnPositionCoordinate(layer, columnPositions[i]), columnWidths[i]);
            ++i;
        }
    }

    protected MultiColumnResizeCommand(MultiColumnResizeCommand command) {
        super(command);
        this.commonColumnWidth = command.commonColumnWidth;
        this.colPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>(command.colPositionToWidth);
    }

    @Override
    public MultiColumnResizeCommand cloneCommand() {
        return new MultiColumnResizeCommand(this);
    }

    public long getCommonColumnWidth() {
        return this.commonColumnWidth;
    }

    public int getColumnWidth(long columnPosition) {
        for (ColumnPositionCoordinate columnPositionCoordinate : this.colPositionToWidth.keySet()) {
            if (columnPositionCoordinate.getColumnPosition() != columnPosition) continue;
            return this.colPositionToWidth.get(columnPositionCoordinate);
        }
        return this.commonColumnWidth;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        if (super.convertToTargetLayer(targetLayer)) {
            HashMap<ColumnPositionCoordinate, Integer> targetColPositionToWidth = new HashMap<ColumnPositionCoordinate, Integer>();
            for (ColumnPositionCoordinate columnPositionCoordinate : this.colPositionToWidth.keySet()) {
                ColumnPositionCoordinate targetColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(columnPositionCoordinate, targetLayer);
                if (targetColumnPositionCoordinate == null) continue;
                targetColPositionToWidth.put(targetColumnPositionCoordinate, this.colPositionToWidth.get(columnPositionCoordinate));
            }
            this.colPositionToWidth = targetColPositionToWidth;
            return true;
        }
        return false;
    }
}

