/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.runtime;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.rj.renv.core.REnvCoreInternals;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RIntegerStore;
import org.eclipse.statet.rj.data.RNumericStore;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.renv.core.BasicRLibGroup;
import org.eclipse.statet.rj.renv.core.BasicRLibLocation;
import org.eclipse.statet.rj.renv.core.BasicRLibPaths;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.core.RLibGroup;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.core.RLibPaths;
import org.eclipse.statet.rj.renv.runtime.RLibLocationInfo;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class RuntimeRLibPathsLoader {
    public static final int WRITABLE_CHECK = 1;
    public static final int FIRST_USER_LIB_CHECK = 2;
    public static final int FULL_CHECK = 3;
    private final RLibPaths rLibPaths;
    private final boolean isLocal;
    private final @Nullable String rHomeDirectory;

    private static long toJavaStamp(double rStamp) {
        return (long)(rStamp * 1000.0);
    }

    private static boolean contains(List<RLibLocationInfo> locationInfos, RLibLocation location) {
        for (RLibLocationInfo locationInfo : locationInfos) {
            if (locationInfo.getLibLocation() != location) continue;
            return true;
        }
        return false;
    }

    public RuntimeRLibPathsLoader(REnvConfiguration rEnvConfig) {
        this.isLocal = rEnvConfig.isLocal() && rEnvConfig.getRHomeDirectoryPath() != null;
        this.rHomeDirectory = null;
        this.rLibPaths = rEnvConfig;
    }

    public RuntimeRLibPathsLoader(String rHomeDirectory, List<RLibGroup> libGroups) {
        this.isLocal = false;
        this.rHomeDirectory = rHomeDirectory;
        ArrayList<RLibLocation> locations = new ArrayList<RLibLocation>();
        Object[] encodedLibGroups = new RLibGroup[libGroups.size()];
        int i = 0;
        while (i < encodedLibGroups.length) {
            RLibGroup libGroup = libGroups.get(i);
            List<? extends RLibLocation> libLocations = libGroup.getLibLocations();
            locations.clear();
            for (RLibLocation rLibLocation : libLocations) {
                String encodedPath = this.encodePath(rLibLocation.getDirectory());
                locations.add(encodedPath == rLibLocation.getDirectory() ? rLibLocation : new BasicRLibLocation(rLibLocation.getSource(), encodedPath, null));
            }
            encodedLibGroups[i] = new BasicRLibGroup(libGroup.getId(), libGroup.getLabel(), (List<? extends RLibLocation>)ImCollections.toList(locations));
            ++i;
        }
        this.rLibPaths = new BasicRLibPaths((List<? extends RLibGroup>)ImCollections.newList((Object[])encodedLibGroups));
    }

    protected String encodePath(String pathString) {
        String rHomeDirectory = this.rHomeDirectory;
        if (rHomeDirectory != null && pathString.startsWith(rHomeDirectory) && (pathString.length() == rHomeDirectory.length() || pathString.charAt(rHomeDirectory.length()) == '/')) {
            return "${r_home}" + pathString.substring(rHomeDirectory.length());
        }
        return pathString;
    }

    protected @Nullable RLibLocation getLibLocationByRPath(String pathString) {
        if (this.isLocal) {
            try {
                Path path = Path.of(pathString, new String[0]);
                return this.rLibPaths.getRLibLocationByDirectoryPath(path);
            }
            catch (Exception e) {
                REnvCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rj.services", "An error occurred when detecting R library location.", (Throwable)e));
            }
        } else {
            String encodedPath = this.encodePath(pathString);
            return this.rLibPaths.getRLibLocationByDirectory(encodedPath);
        }
        return null;
    }

    protected @Nullable RLibLocation getFirstUserLibLocation(RLibPaths rLibPaths) {
        RLibGroup libGroup = rLibPaths.getRLibGroup("r.user");
        if (libGroup != null) {
            List<? extends RLibLocation> libraries = libGroup.getLibLocations();
            return !libraries.isEmpty() ? libraries.get(0) : null;
        }
        return null;
    }

    public RVector<RNumericStore> loadLibStamps(RService r, ProgressMonitor m) throws StatusException {
        try {
            return RDataUtils.checkRNumVector((RObject)r.evalData("rj:::renv.checkLibs()", m));
        }
        catch (StatusException | UnexpectedRDataException e) {
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services", "An error occurred when checking R library locations.", e));
        }
    }

    public RuntimeRLibPaths load(RVector<RNumericStore> rLibsStamps, int options, RService r, ProgressMonitor m) throws StatusException {
        int l = (int)rLibsStamps.getLength();
        ArrayList<RLibLocationInfo> libLocationInfos = new ArrayList<RLibLocationInfo>(l + 1);
        if ((options & 1) != 0) {
            try {
                RVector rLibsAccess = RDataUtils.checkRIntVector((RObject)r.evalData("file.access(.libPaths(), 3L)", m));
                int i = 0;
                while (i < l) {
                    String rPath = rLibsStamps.getNames().getChar(i);
                    RLibLocation location = this.getLibLocationByRPath(rPath);
                    if (location != null) {
                        libLocationInfos.add(new RLibLocationInfo(location, rPath, true, location.getSource() != "eplugin" && ((RIntegerStore)rLibsAccess.getData()).getInt(i) == 0, RuntimeRLibPathsLoader.toJavaStamp(((RNumericStore)rLibsStamps.getData()).getNum(i)), i));
                    }
                    ++i;
                }
            }
            catch (StatusException | UnexpectedRDataException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services", "An error occurred when checking R library locations for access.", e));
            }
        } else {
            int i = 0;
            while (i < l) {
                String rPath = rLibsStamps.getNames().getChar(i);
                RLibLocation location = this.getLibLocationByRPath(rPath);
                if (location != null) {
                    libLocationInfos.add(new RLibLocationInfo(location, rPath, true, false, RuntimeRLibPathsLoader.toJavaStamp(((RNumericStore)rLibsStamps.getData()).getNum(i)), i));
                }
                ++i;
            }
        }
        if ((options & 2) != 0) {
            try {
                Path directoryPath;
                RLibLocation location = this.getFirstUserLibLocation(this.rLibPaths);
                if (location != null && !RuntimeRLibPathsLoader.contains(libLocationInfos, location) && (directoryPath = location.getDirectoryPath()) != null && directoryPath.toUri().getScheme().equals("file")) {
                    FunctionCall call = r.createFunctionCall("rj:::renv.isValidLibLocation");
                    call.addChar(directoryPath.toString());
                    RVector data = RDataUtils.checkRIntVector((RObject)call.evalData(m));
                    int state = RDataUtils.checkSingleIntValue((RObject)data);
                    if (state == 0) {
                        libLocationInfos.add(new RLibLocationInfo(location, data.getNames().getChar(0).replace('\\', '/'), false, true, 0L, -1));
                    }
                }
            }
            catch (StatusException | UnexpectedRDataException e) {
                REnvCoreInternals.log((Status)new ErrorStatus("org.eclipse.statet.rj.services", "An error occurred when checking missing R user library location.", e));
            }
        }
        return new RuntimeRLibPaths((List<? extends RLibGroup>)this.rLibPaths.getRLibGroups(), (List<? extends RLibLocationInfo>)libLocationInfos);
    }

    public RuntimeRLibPaths load(int options, RService r, ProgressMonitor m) throws StatusException {
        return this.load(this.loadLibStamps(r, m), options, r, m);
    }
}

