/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.nico.core.runtime.ITrack;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public class OpenTrackingFilesContributionItem
extends CompoundContributionItem {
    private final ToolProcess fTool;

    public static void open(String name, IFileStore fileStore) {
        block5: {
            try {
                IFile workspaceFile = FileUtil.getAsWorkspaceFile((URI)fileStore.toURI());
                if (workspaceFile != null) {
                    new RefreshFileJob(name, workspaceFile).schedule();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    IDE.openEditor((IWorkbenchPage)UIAccess.getActiveWorkbenchPage((boolean)true), (IFile)workspaceFile);
                    break block5;
                }
                IDE.openEditorOnFileStore((IWorkbenchPage)UIAccess.getActiveWorkbenchPage((boolean)true), (IFileStore)fileStore);
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.nico.core", -1, "An error occurred when opening the editor on the track file of " + name + ".", (Throwable)e));
            }
        }
    }

    public OpenTrackingFilesContributionItem(ToolProcess tool) {
        if (tool == null) {
            throw new NullPointerException();
        }
        this.fTool = tool;
    }

    protected IContributionItem[] getContributionItems() {
        ImList tracks = this.fTool.getTracks();
        ArrayList<1> items = new ArrayList<1>(tracks.size());
        int i = 0;
        while (i < tracks.size()) {
            final ITrack track = (ITrack)tracks.get(i);
            IFileStore file = track.getFile();
            if (file != null) {
                SimpleContributionItem item = new SimpleContributionItem(track.getName(), null){

                    protected void execute() throws ExecutionException {
                        track.flush();
                        OpenTrackingFilesContributionItem.open(track.getName(), track.getFile());
                    }
                };
                items.add(item);
            }
            ++i;
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    private static class RefreshFileJob
    extends Job {
        private final IFile fFile;

        public RefreshFileJob(String name, IFile file) {
            super("Refresh track file of '" + name + "'");
            this.fFile = file;
            this.setSystem(true);
            this.setUser(false);
            IResourceRuleFactory ruleFactory = file.getWorkspace().getRuleFactory();
            this.setRule(ruleFactory.refreshRule((IResource)file));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.fFile.refreshLocal(1, monitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            return Status.OK_STATUS;
        }
    }
}

