/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsComConfig;
import org.eclipse.statet.rj.server.RjsStatus;

public final class DataCmdItem
extends MainCmdItem {
    public static final byte EVAL_EXPR_VOID_OP = 1;
    public static final Operation EVAL_EXPR_VOID = new Operation(1, "EVAL_EXPR_VOID", 1, 0, false);
    public static final byte EVAL_FCALL_VOID_OP = 2;
    public static final Operation EVAL_FCALL_VOID = new Operation(2, "EVAL_FCALL_VOID", 3, 0, false);
    public static final byte EVAL_EXPR_DATA_OP = 3;
    public static final Operation EVAL_EXPR_DATA = new Operation(3, "EVAL_EXPR_DATA", 1, 0, true);
    public static final byte EVAL_FCALL_DATA_OP = 4;
    public static final Operation EVAL_FCALL_DATA = new Operation(4, "EVAL_FCALL_DATA", 3, 0, true);
    public static final byte RESOLVE_DATA_OP = 5;
    public static final Operation RESOLVE_DATA = new Operation(5, "RESOLVE_DATA", 2, 0, true);
    public static final byte ASSIGN_DATA_OP = 6;
    public static final Operation ASSIGN_DATA = new Operation(6, "ASSIGN_DATA", 4, 1, false);
    public static final byte ASSIGN_FCALL_OP = 7;
    public static final Operation ASSIGN_FCALL = new Operation(7, "ASSIGN_FCALL", 3, 1, false);
    public static final byte FIND_DATA_OP = 8;
    public static final Operation FIND_DATA = new Operation(8, "FIND_DATA", 1, 0, true);
    public static final byte EVAL_NAMESPACE_DATA_OP = 9;
    public static final Operation EVAL_NAMESPACE_DATA = new Operation(9, "EVAL_NAMESPACE_DATA", 1, 0, true);
    public static final byte EVAL_NAMESPACE_EXPORTS_DATA_OP = 10;
    public static final Operation EVAL_NAMESPACE_EXPORTS_DATA = new Operation(10, "EVAL_NAMESPACE_EXPORTS_DATA", 1, 0, true);
    private static final Operation[] OPERATIONS = new Operation[11];
    private static final int OV_WITHDATA = 0x2000000;
    private static final int OV_WITHRHO = 0x4000000;
    private static final int OV_WITHSTATUS = 0x8000000;
    public static final String DEFAULT_FACTORY_ID = "default";
    static RObjectFactory gDefaultFactory;
    static final Map<String, RObjectFactory> gFactories;
    private final Operation operation;
    private byte depth;
    private String sourceExpr;
    private String targetExpr;
    private RObject rdata;
    private RObject rho;
    private String factoryId;
    private RjsStatus status;

    static {
        DataCmdItem.addOp(EVAL_EXPR_VOID);
        DataCmdItem.addOp(EVAL_FCALL_VOID);
        DataCmdItem.addOp(EVAL_EXPR_DATA);
        DataCmdItem.addOp(EVAL_FCALL_DATA);
        DataCmdItem.addOp(RESOLVE_DATA);
        DataCmdItem.addOp(ASSIGN_DATA);
        DataCmdItem.addOp(ASSIGN_FCALL);
        DataCmdItem.addOp(FIND_DATA);
        DataCmdItem.addOp(EVAL_NAMESPACE_DATA);
        DataCmdItem.addOp(EVAL_NAMESPACE_EXPORTS_DATA);
        gFactories = new ConcurrentHashMap<String, RObjectFactory>();
        RjsComConfig.setDefaultRObjectFactory((RObjectFactory)DefaultRObjectFactory.INSTANCE);
    }

    private static final void addOp(Operation operation) {
        if (OPERATIONS[operation.op] != null) {
            throw new IllegalArgumentException();
        }
        DataCmdItem.OPERATIONS[operation.op] = operation;
    }

    private static final Operation getOperation(byte op) {
        if (op <= 0 || op >= OPERATIONS.length) {
            throw new UnsupportedOperationException("data op: " + op);
        }
        return OPERATIONS[op];
    }

    private static final RObjectFactory getFactory(String id) {
        RObjectFactory factory = gFactories.get(id);
        if (factory != null) {
            return factory;
        }
        return gDefaultFactory;
    }

    private static int checkCustomOptions(int options) {
        if ((options & 5) == 5) {
            throw new IllegalArgumentException("options: RObjectFactory.F_LOAD_DBG & RObjectFactory.F_ONLY_STRUCT");
        }
        return options & 0xFFFF;
    }

    public DataCmdItem(Operation op, int options, byte depth, String sourceExpr, RObject data, String targetExpr, RObject rho, String factoryId) {
        assert (op.reqSourceExpr == (sourceExpr != null));
        assert (op.reqRData == (data != null));
        assert (op.reqTargetExpr == (targetExpr != null));
        assert (factoryId == null || gFactories.containsKey(factoryId));
        this.operation = op;
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.options = Integer.MIN_VALUE | DataCmdItem.checkCustomOptions(options);
        if (data != null) {
            this.rdata = data;
            this.options |= 0x2000000;
        }
        if (rho != null) {
            this.rho = rho;
            this.options |= 0x4000000;
        }
        this.depth = depth;
        this.factoryId = factoryId != null ? factoryId : DEFAULT_FACTORY_ID;
    }

    public DataCmdItem(Operation op, int options, String sourceExpr, RObject data, String targetExpr, RObject rho) {
        assert (op.reqSourceExpr == (sourceExpr != null));
        assert (op.reqRData == (data != null));
        assert (op.reqTargetExpr == (targetExpr != null));
        this.operation = op;
        this.sourceExpr = sourceExpr;
        this.targetExpr = targetExpr;
        this.options = Integer.MIN_VALUE | DataCmdItem.checkCustomOptions(options);
        if (data != null) {
            this.rdata = data;
            this.options |= 0x2000000;
        }
        if (rho != null) {
            this.rho = rho;
            this.options |= 0x4000000;
        }
        this.factoryId = "";
    }

    public DataCmdItem(RJIO in) throws IOException {
        this.requestId = in.readInt();
        this.operation = DataCmdItem.getOperation(in.readByte());
        this.options = in.readInt();
        if ((this.options & 0x8000000) != 0) {
            this.status = new RjsStatus(in);
            return;
        }
        this.depth = in.readByte();
        this.factoryId = in.readString();
        if ((this.options & 0x40000000) == 0) {
            if (this.operation.reqSourceExpr) {
                this.sourceExpr = in.readString();
            }
            if (this.operation.reqRData) {
                in.flags = 0;
                this.rdata = gDefaultFactory.readObject(in);
            }
            if (this.operation.reqTargetExpr) {
                this.targetExpr = in.readString();
            }
            if ((this.options & 0x4000000) != 0) {
                in.flags = 0;
                this.rho = gDefaultFactory.readObject(in);
            }
        } else {
            if ((this.options & 0x2000000) != 0) {
                in.flags = this.options & 0xFF;
                this.rdata = DataCmdItem.getFactory(this.factoryId).readObject(in);
            }
            if ((this.options & 0x4000000) != 0) {
                in.flags = 1;
                this.rho = DataCmdItem.getFactory(this.factoryId).readObject(in);
            }
        }
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeInt(this.requestId);
        out.writeByte(this.operation.op);
        out.writeInt(this.options);
        if ((this.options & 0x8000000) != 0) {
            this.status.writeExternal(out);
            return;
        }
        out.writeByte(this.depth);
        out.writeString(this.factoryId);
        if ((this.options & 0x40000000) == 0) {
            if (this.operation.reqSourceExpr) {
                out.writeString(this.sourceExpr);
            }
            if (this.operation.reqRData) {
                out.flags = 0;
                gDefaultFactory.writeObject(this.rdata, out);
            }
            if (this.operation.reqTargetExpr) {
                out.writeString(this.targetExpr);
            }
            if ((this.options & 0x4000000) != 0) {
                out.flags = 0;
                gDefaultFactory.writeObject(this.rho, out);
            }
        } else {
            if ((this.options & 0x2000000) != 0) {
                out.flags = this.options & 0xFF;
                gDefaultFactory.writeObject(this.rdata, out);
            }
            if ((this.options & 0x4000000) != 0) {
                out.flags = 1;
                gDefaultFactory.writeObject(this.rho, out);
            }
        }
    }

    @Override
    public byte getCmdType() {
        return 17;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        assert (status != null);
        if (status == RjsStatus.OK_STATUS) {
            this.options = this.options & 0xF00FFFFF | 0x40000000;
            this.status = null;
            this.sourceExpr = null;
            this.rdata = null;
            this.targetExpr = null;
            this.rho = null;
        } else {
            this.options = this.options & 0xF00FFFFF | 0x48000000;
            this.status = status;
            this.sourceExpr = null;
            this.rdata = null;
            this.targetExpr = null;
            this.rho = null;
        }
    }

    public void setAnswer(RObject rdata, RObject rho) {
        this.options = this.options & 0xF00FFFFF | 0x40000000;
        if (rdata != null) {
            this.options |= 0x2000000;
        }
        if (rho != null) {
            this.options |= 0x4000000;
        }
        this.status = null;
        this.sourceExpr = null;
        this.rdata = rdata;
        this.targetExpr = null;
        this.rho = rho;
    }

    @Override
    public byte getOp() {
        return this.operation.op;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public boolean isOK() {
        return this.status == null || this.status.getSeverity() == 0;
    }

    @Override
    public RjsStatus getStatus() {
        return this.status;
    }

    @Override
    public String getDataText() {
        return this.sourceExpr;
    }

    public RObject getData() {
        return this.rdata;
    }

    public String getTargetExpr() {
        return this.targetExpr;
    }

    public RObject getRho() {
        return this.rho;
    }

    public byte getDepth() {
        return this.depth;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (other instanceof DataCmdItem) {
            DataCmdItem otherItem = (DataCmdItem)other;
            if (this.getOp() != otherItem.getOp()) {
                return false;
            }
            if (this.options != otherItem.options) {
                return false;
            }
            if (this.sourceExpr != null ? !this.sourceExpr.equals(otherItem.sourceExpr) : otherItem.sourceExpr != null) {
                return false;
            }
            if (this.rdata != null ? !this.rdata.equals(otherItem.rdata) : otherItem.rdata != null) {
                return false;
            }
            if (this.targetExpr != null ? !this.targetExpr.equals(otherItem.targetExpr) : otherItem.targetExpr != null) {
                return false;
            }
            return !(this.rho != null ? !this.rho.equals(otherItem.rho) : otherItem.rho != null);
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("DataCmdItem ");
        sb.append(this.operation.name);
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        if (this.sourceExpr != null) {
            sb.append("\n<SOURCE-EXPR>\n");
            sb.append(this.sourceExpr);
            sb.append("\n</SOURCE-EXPR>");
        } else {
            sb.append("\n<SOURCE-EXPR/>");
        }
        if ((this.options & 0x2000000) != 0) {
            sb.append("\n<DATA>\n");
            sb.append(this.rdata);
            sb.append("\n</DATA>");
        } else {
            sb.append("\n<DATA/>");
        }
        if (this.targetExpr != null) {
            sb.append("\n<TARGET-EXPR>\n");
            sb.append(this.targetExpr);
            sb.append("\n</TARGET-EXPR>");
        } else {
            sb.append("\n<TARGET-EXPR/>");
        }
        if ((this.options & 0x4000000) != 0) {
            sb.append("\n<RHO>\n");
            sb.append(this.rho);
            sb.append("\n</RHO>");
        }
        if ((this.options & 0x8000000) != 0) {
            sb.append("\n<STATUS>\n");
            sb.append(this.status);
            sb.append("\n</STATUS>");
        }
        return sb.toString();
    }

    public static final class Operation {
        public static final byte NONE = 0;
        public static final byte EXPR = 1;
        public static final byte POINTER = 2;
        public static final byte FCALL = 3;
        public static final byte RDATA = 4;
        public final byte op;
        public final String name;
        public final byte source;
        public final byte target;
        public final boolean returnData;
        private final boolean reqSourceExpr;
        private final boolean reqRData;
        private final boolean reqTargetExpr;

        private Operation(int op, String name, byte source, byte target, boolean returnData) {
            this.op = (byte)op;
            this.name = name;
            this.source = source;
            this.target = target;
            this.returnData = returnData;
            this.reqSourceExpr = source == 1 || source == 2 || source == 3;
            this.reqRData = source == 3 || source == 4;
            this.reqTargetExpr = target == 1 || target == 2;
        }

        public String toString() {
            return this.name;
        }
    }
}

