/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.rmi.Remote;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.net.PortRange;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.server.BinExchange;
import org.eclipse.statet.rj.server.ComHandler;
import org.eclipse.statet.rj.server.DataCmdItem;
import org.eclipse.statet.rj.server.MainCmdS2CList;

@NonNullByDefault
public class RjsComConfig {
    public static final String RJ_COM_S2C_ID_PROPERTY_ID = "rj.com.s2c.id";
    public static final String RJ_DATA_STRUCTS_LISTS_MAX_LENGTH_PROPERTY_ID = "rj.data.structs.lists.max_length";
    public static final String RJ_DATA_STRUCTS_ENVS_MAX_LENGTH_PROPERTY_ID = "rj.data.structs.envs.max_length";
    private static final Map<String, Object> PROPERTIES = new ConcurrentHashMap<String, Object>();
    private static final ThreadLocal<@Nullable RMIClientSocketFactory> gRMIClientSocketFactoriesInit = new ThreadLocal();
    private static final ConcurrentHashMap<String, RMIClientSocketFactory> gRMIClientSocketFactories = new ConcurrentHashMap();
    private static final Random RANDOM = new Random();
    private static final String RMISERVER_CLIENTSOCKET_FACTORY_KEY = "org.eclipse.statet.rj.rmi.disableSocketFactory";
    private static final String RMISERVER_SERVERSOCKET_PORT_RANGE_KEY = "org.eclipse.statet.rj.server.TcpPort";
    private static final boolean RMISERVER_CLIENTSOCKET_FACTORY_ENABLED;
    private static final @Nullable PortRange RMISERVER_SERVERSOCKET_PORT_RANGE;
    private static @Nullable RMIClientSocketFactory RMISERVER_CLIENTSOCKET_CUSTOM_FACTORY;

    static {
        boolean enabled = true;
        try {
            if ("true".equalsIgnoreCase(System.getProperty(RMISERVER_CLIENTSOCKET_FACTORY_KEY))) {
                enabled = false;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        RMISERVER_CLIENTSOCKET_FACTORY_ENABLED = enabled;
        PortRange range = null;
        try {
            String s = System.getProperty(RMISERVER_SERVERSOCKET_PORT_RANGE_KEY);
            if (s == null) {
                s = System.getProperty("org.eclipse.statet.rj.server.TcpPortRange");
            }
            if (s != null) {
                range = PortRange.valueOf((String)s);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        RMISERVER_SERVERSOCKET_PORT_RANGE = range;
    }

    public static void setServerPathResolver(PathResolver resolver) {
        BinExchange.gSPathResolver = resolver;
    }

    public static int registerClientComHandler(ComHandler handler) {
        int id = MainCmdS2CList.gComHandlers.put((ComHandler)ObjectUtils.nonNullAssert((Object)handler));
        if (id < 65535) {
            return id;
        }
        MainCmdS2CList.gComHandlers.remove(id);
        throw new UnsupportedOperationException("Too much open clients");
    }

    public static void unregisterClientComHandler(int id) {
        MainCmdS2CList.gComHandlers.remove(id);
    }

    public static final void registerRObjectFactory(String id, RObjectFactory factory) {
        if (id == null || factory == null) {
            throw new NullPointerException();
        }
        if (id.equals("default")) {
            throw new IllegalArgumentException();
        }
        DataCmdItem.gFactories.put(id, factory);
    }

    public static final void setDefaultRObjectFactory(RObjectFactory factory) {
        DataCmdItem.gDefaultFactory = (RObjectFactory)ObjectUtils.nonNullAssert((Object)factory);
        DataCmdItem.gFactories.put("default", factory);
    }

    public static final void setProperty(String key, Object value) {
        PROPERTIES.put(key, value);
    }

    public static final @Nullable Object getProperty(String key) {
        return PROPERTIES.get(key);
    }

    private static RMIClientSocketFactory getSystemRMIClientSocketFactory() {
        RMISocketFactory factory = RMISocketFactory.getSocketFactory();
        if (factory == null) {
            factory = RMISocketFactory.getDefaultSocketFactory();
        }
        return factory;
    }

    public static final synchronized @Nullable RMIClientSocketFactory getRMIServerClientSocketFactory(boolean isSsl) {
        RMIClientSocketFactory factory;
        if (isSsl) {
            factory = new SslRMIClientSocketFactory();
        } else if (RMISERVER_CLIENTSOCKET_FACTORY_ENABLED) {
            factory = RMISERVER_CLIENTSOCKET_CUSTOM_FACTORY;
            if (factory == null) {
                factory = new RjRmiClientSocketFactory("S/");
                RMISERVER_CLIENTSOCKET_CUSTOM_FACTORY = factory;
            }
        } else {
            factory = null;
        }
        return factory;
    }

    public static final synchronized @Nullable RMIServerSocketFactory getRMIServerServerSocketFactory(boolean isSsl) {
        RMIServerSocketFactory factory = isSsl ? new SslRMIServerSocketFactory(null, null, true) : RMISocketFactory.getDefaultSocketFactory();
        if (RMISERVER_SERVERSOCKET_PORT_RANGE != null) {
            factory = new RjRmiServerSocketFactory(factory, RMISERVER_SERVERSOCKET_PORT_RANGE);
        }
        return factory;
    }

    public static final void setRMIClientSocketFactory(@Nullable RMIClientSocketFactory factory) {
        if (factory == null) {
            factory = RjsComConfig.getSystemRMIClientSocketFactory();
        }
        gRMIClientSocketFactoriesInit.set(factory);
    }

    public static final void clearRMIClientSocketFactory() {
        gRMIClientSocketFactoriesInit.set(null);
    }

    public static interface PathResolver {
        public Path resolve(Remote var1, String var2) throws InvalidPathException, RjException;
    }

    private static final class RjRmiClientSocketFactory
    implements RMIClientSocketFactory,
    Externalizable {
        private static final long serialVersionUID = -2470426070934072117L;
        private String id;
        private @Nullable RMIClientSocketFactory resolvedFactory;

        private static String getLocalHostName() {
            try {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return "unknown";
        }

        public RjRmiClientSocketFactory(String init) {
            StringBuilder sb = new StringBuilder(init);
            sb.append(RjRmiClientSocketFactory.getLocalHostName());
            sb.append('/').append(System.nanoTime()).append('/').append(Math.random());
            this.id = sb.toString();
        }

        public RjRmiClientSocketFactory() {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.id);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readUTF();
        }

        @Override
        public Socket createSocket(@Nullable String host, int port) throws IOException {
            RMIClientSocketFactory factory = null;
            factory = gRMIClientSocketFactoriesInit.get();
            if (factory != null) {
                this.resolvedFactory = factory;
                gRMIClientSocketFactories.put(this.id, factory);
            } else {
                factory = this.resolvedFactory;
                if (factory == null) {
                    factory = gRMIClientSocketFactories.get(this.id);
                    if (factory != null) {
                        this.resolvedFactory = factory;
                    } else {
                        factory = RjsComConfig.getSystemRMIClientSocketFactory();
                    }
                }
            }
            return factory.createSocket(host, port);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof RjRmiClientSocketFactory && this.id.equals(((RjRmiClientSocketFactory)obj).id);
        }
    }

    private static final class RjRmiServerSocketFactory
    implements RMIServerSocketFactory {
        private final RMIServerSocketFactory factory;
        private final PortRange portRange;
        private volatile int lastPortNumber;

        public RjRmiServerSocketFactory(RMIServerSocketFactory factory, PortRange portRange) {
            this.factory = factory;
            this.portRange = portRange;
        }

        private ServerSocket createSocket(int port) throws IOException {
            ServerSocket socket = this.factory.createServerSocket(port);
            this.lastPortNumber = port;
            return socket;
        }

        private static int nextInt(int r, int l) {
            r = l < 10 ? ++r : (r += 1 + RANDOM.nextInt(l / 4));
            return r < l ? r : r - l;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            if (port == 0) {
                int i;
                int r;
                int l;
                IOException e0 = null;
                int total = 0;
                int base = this.lastPortNumber;
                if (base != 0) {
                    int iCount = Math.min(5, this.portRange.getMax() - ++base + 1);
                    int i2 = 0;
                    while (i2 < iCount) {
                        try {
                            return this.createSocket(base + i2);
                        }
                        catch (IOException e) {
                            e0 = e;
                            ++i2;
                        }
                    }
                    total += iCount;
                }
                base = this.portRange.getMin();
                if (this.portRange.getLength() >= 100) {
                    l = this.portRange.getLength() / 10;
                    r = RANDOM.nextInt(l);
                    int iCount = Math.min(20, l);
                    i = 0;
                    while (i < iCount) {
                        try {
                            return this.createSocket(base + r * 10);
                        }
                        catch (IOException e) {
                            e0 = e;
                            r = RjRmiServerSocketFactory.nextInt(r, l);
                            ++i;
                        }
                    }
                    total += iCount;
                }
                l = this.portRange.getLength();
                r = RANDOM.nextInt(l);
                int iCount = Math.min(50 - total, l);
                i = 0;
                while (i < iCount) {
                    try {
                        return this.createSocket(base + r);
                    }
                    catch (IOException e) {
                        e0 = e;
                        r = RjRmiServerSocketFactory.nextInt(r, l);
                        ++i;
                    }
                }
                total += iCount;
                throw new IOException("Failed to create server socket. No port available in range " + this.portRange.getText() + "?", e0);
            }
            return this.factory.createServerSocket(port);
        }
    }
}

