/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.IStructuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.RowVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.StructuralDiff;

public abstract class RowStructuralChangeEvent
extends RowVisualChangeEvent
implements IStructuralChangeEvent {
    public RowStructuralChangeEvent(ILayer layer, LRange ... rowPositionRanges) {
        this(layer, Arrays.asList(rowPositionRanges));
    }

    public RowStructuralChangeEvent(ILayer layer, Collection<LRange> rowPositionRanges) {
        super(layer, rowPositionRanges);
    }

    protected RowStructuralChangeEvent(RowStructuralChangeEvent event) {
        super(event);
    }

    @Override
    public Collection<LRectangle> getChangedPositionRectangles() {
        ArrayList<LRectangle> changedPositionRectangles = new ArrayList<LRectangle>();
        long columnCount = this.getLayer().getColumnCount();
        long rowCount = this.getLayer().getRowCount();
        for (LRange lRange : this.getRowPositionRanges()) {
            changedPositionRectangles.add(new LRectangle(0L, lRange.start, columnCount, rowCount - lRange.start));
        }
        return changedPositionRectangles;
    }

    @Override
    public boolean isHorizontalStructureChanged() {
        return false;
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        return null;
    }

    @Override
    public boolean isVerticalStructureChanged() {
        return true;
    }
}

