/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.List;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.rmodel.RChunkElement;
import org.eclipse.statet.r.core.rmodel.RLangElement;
import org.eclipse.statet.r.core.source.ast.SourceComponent;

public class RSourceCodeAdapter
extends RRefactoringAdapter {
    protected void getSourceCode(SourceElement element, AbstractDocument doc, BasicHeuristicTokenScanner scanner, List<String> codeFragments) throws BadLocationException, BadPartitioningException {
        if (element instanceof RLangElement) {
            if (element instanceof RChunkElement) {
                List components = (List)element.getAdapter(SourceComponent.class);
                for (SourceComponent component : components) {
                    TextRegion range = this.expandSourceRange(component.getStartOffset(), component.getEndOffset(), doc, scanner);
                    if (range == null || range.getLength() <= 0) continue;
                    codeFragments.add(doc.get(range.getStartOffset(), range.getLength()));
                }
                return;
            }
            super.getSourceCode(element, doc, scanner, codeFragments);
            return;
        }
        if (element instanceof SourceStructElement) {
            List children = ((SourceStructElement)element).getSourceChildren(null);
            for (SourceStructElement child : children) {
                this.getSourceCode((SourceElement)child, doc, scanner, codeFragments);
            }
        }
    }
}

