/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.editors;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.ui.search.RElementSearch;
import org.eclipse.statet.internal.r.ui.search.RElementSearchQuery;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.statet.r.core.refactoring.RElementSearchProcessor;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RElementSearchHandler
extends AbstractHandler
implements IExecutableExtension {
    private String commandId;
    private final RRefactoringAdapter ltkAdapter = new RRefactoringAdapter();

    public static RElementSearchProcessor.Mode parScope2Mode(String par) {
        if (par == "workspace") {
            return RElementSearchProcessor.Mode.WORKSPACE;
        }
        if (par == "project") {
            return RElementSearchProcessor.Mode.CURRENT_PROJECT;
        }
        if (par == "file") {
            return RElementSearchProcessor.Mode.CURRENT_FILE;
        }
        return null;
    }

    public RElementSearchHandler(String commandId) {
        this.commandId = commandId;
    }

    public RElementSearchHandler() {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (this.commandId != null) {
            return;
        }
        String s = config.getAttribute("commandId");
        if (s != null && !s.isEmpty()) {
            this.commandId = s.intern();
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        RElementSearchProcessor.Mode mode = RElementSearchHandler.parScope2Mode(event.getParameter("scope"));
        if (part == null || mode == null) {
            return null;
        }
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        Status status = null;
        if (selection instanceof ITextSelection) {
            SourceUnit su;
            ITextSelection textSelection = (ITextSelection)selection;
            SourceEditor editor = (SourceEditor)part.getAdapter(SourceEditor.class);
            if (editor != null && (su = editor.getSourceUnit()) instanceof RSourceUnit) {
                NullProgressMonitor monitor = new NullProgressMonitor();
                RAstNode node = this.ltkAdapter.searchPotentialNameNode(su, LTKSelectionUtils.toTextRegion((ITextSelection)textSelection), false, (IProgressMonitor)monitor);
                if (node != null) {
                    RElementAccess mainAccess = RElementAccess.getMainElementAccessOfNameNode((RAstNode)node);
                    RElementAccess subAccess = RElementAccess.getElementAccessOfNameNode((RAstNode)node);
                    if (mainAccess != null && subAccess != null) {
                        RElementName name = RElementName.create((RElementName)mainAccess, (RElementName)subAccess.getNextSegment(), (boolean)false);
                        status = this.startSearch(name, (RSourceUnit)su, mainAccess, mode);
                    }
                }
            }
        }
        if (status == null) {
            status = new Status(4, "org.eclipse.statet.r.ui", "The operation is unavailable on the current selection.");
        }
        if (status.getSeverity() == 4) {
            LTKWorkbenchUIUtil.indicateStatus((IStatus)status, (ExecutionEvent)event);
        }
        return status;
    }

    protected IStatus startSearch(RElementName name, RSourceUnit sourceUnit, RElementAccess mainAccess, RElementSearchProcessor.Mode mode) {
        RElementSearch searchProcessor = new RElementSearch(name, sourceUnit, mainAccess, mode, this.commandId == "org.eclipse.statet.ltk.commands.SearchWriteElementAccess");
        if (searchProcessor.getStatus().getSeverity() >= 4 || searchProcessor.getMode() == RElementSearchProcessor.Mode.LOCAL_FRAME) {
            return null;
        }
        if (searchProcessor.getMode() != mode && searchProcessor.getMode() == RElementSearchProcessor.Mode.CURRENT_FILE) {
            return new Status(4, "org.eclipse.statet.r.ui", "The search scope is not available for the current selection.");
        }
        RElementSearchQuery query = new RElementSearchQuery(searchProcessor);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return Status.OK_STATUS;
    }
}

