/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.AbstractOpenDeclarationHandler;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.rmodel.RElementAccess;
import org.eclipse.statet.r.core.rmodel.RModel;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;
import org.eclipse.statet.r.core.rmodel.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.ui.sourceediting.ROpenDeclaration;
import org.eclipse.ui.PartInitException;

@NonNullByDefault
public class ROpenDeclarationHandler
extends AbstractOpenDeclarationHandler {
    public static @Nullable RElementAccess searchAccess(SourceEditor editor, TextRegion region) {
        IDocument document;
        block6: {
            document = editor.getViewer().getDocument();
            if (document != null) break block6;
            return null;
        }
        try {
            RAstNode node;
            AstInfo astInfo;
            AstSelection astSelection;
            AstNode covering;
            RSourceUnitModelInfo modelInfo;
            RHeuristicTokenScanner scanner = RHeuristicTokenScanner.create((DocContentSections)editor.getDocumentContentInfo());
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)scanner.getDocumentPartitioning(), (int)region.getStartOffset(), (boolean)false);
            SourceUnit su = editor.getSourceUnit();
            if (su instanceof RSourceUnit && region.getStartOffset() < document.getLength() && (RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(partition.getType()) && !RTokens.isRobustSeparator((int)document.getChar(region.getStartOffset()), (boolean)false) || partition.getType() == "R.QuotedSymbol" || partition.getType() == "R.String") && (modelInfo = (RSourceUnitModelInfo)su.getModelInfo("R", 2, (IProgressMonitor)new NullProgressMonitor())) != null && (covering = (astSelection = AstSelection.search((AstNode)(astInfo = modelInfo.getAst()).getRoot(), (int)region.getStartOffset(), (int)region.getEndOffset(), (int)3)).getCovering()) instanceof RAstNode && ((node = (RAstNode)covering).getNodeType() == NodeType.SYMBOL || node.getNodeType() == NodeType.STRING_CONST)) {
                RAstNode current = node;
                do {
                    ImList attachments = current.getAttachments();
                    for (Object attachment : attachments) {
                        RElementAccess access;
                        if (!(attachment instanceof RElementAccess) || (access = (RElementAccess)attachment).getNameNode() != node) continue;
                        return access;
                    }
                } while ((current = current.getRParent()) != null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public boolean execute(SourceEditor editor, TextRegion selection) {
        RElementAccess access = ROpenDeclarationHandler.searchAccess(editor, selection);
        if (access != null) {
            try {
                List list = RModel.searchDeclaration((RElementAccess)access, (RSourceUnit)((RSourceUnit)editor.getSourceUnit()));
                ROpenDeclaration open = new ROpenDeclaration();
                SourceElement element = (SourceElement)open.selectElement(list, editor.getWorkbenchPart());
                if (element != null) {
                    open.open(element, true);
                    return true;
                }
            }
            catch (PartInitException e) {
                this.logError((Exception)((Object)e), access.getDisplayName());
            }
            catch (CoreException e) {
                return true;
            }
        }
        return false;
    }
}

