/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.statet.internal.r.console.core.RObjectDB;
import org.eclipse.statet.internal.r.rdata.REnvironmentVar;
import org.eclipse.statet.internal.r.rdata.RReferenceVar;
import org.eclipse.statet.internal.r.rdata.VirtualMissingVar;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.nico.core.NicoVariables;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.pkgmanager.IRPkgChangeSet;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RModel;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.r.nico.RWorkspaceConfig;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RReference;
import org.eclipse.statet.rj.renv.core.REnv;

public class RWorkspace
extends ToolWorkspace {
    public static final int REFRESH_AUTO = 1;
    public static final int REFRESH_COMPLETE = 2;
    public static final int REFRESH_PACKAGES = 16;
    public static final int RESOLVE_UPTODATE = 2;
    public static final int RESOLVE_FORCE = 4;
    public static final int RESOLVE_RECURSIVE = 8;
    public static final int RESOLVE_INDICATE_NA = 32;
    public static final ImList<IStringVariable> ADDITIONAL_R_VARIABLES = ImCollections.newList((Object[])new IStringVariable[]{NicoVariables.SESSION_STARTUP_DATE_VARIABLE, NicoVariables.SESSION_STARTUP_TIME_VARIABLE, NicoVariables.SESSION_CONNECTION_DATE_VARIABLE, NicoVariables.SESSION_CONNECTION_TIME_VARIABLE, NicoVariables.SESSION_STARTUP_WD_VARIABLE});
    private boolean rObjectDBEnabled;
    private RObjectDB rObjectDB;
    private boolean autoRefreshDirty;
    private IRPkgManager pkgManager;
    private IRPkgManager.Listener pkgManagerListener;
    private final HashSet<RElementName> changedEnvirs = new HashSet();

    private static RReferenceVar verifyVar(@Nullable RElementName fullName, ICombinedRDataAdapter r, ProgressMonitor m) {
        if (fullName == null) {
            return null;
        }
        try {
            return (RReferenceVar)r.evalCombinedStruct(fullName, 0, 0, m);
        }
        catch (Exception e) {
            return null;
        }
    }

    public RWorkspace(AbstractRController controller, String remoteHost, RWorkspaceConfig config) {
        super((ToolController)controller, new Prompt("> ", 2), "\n", '\u0000', remoteHost);
        REnv rEnv;
        if (config != null) {
            this.rObjectDBEnabled = config.getEnableObjectDB();
            this.setAutoRefresh(config.getEnableAutoRefresh());
        }
        if ((rEnv = this.getProcess().getREnv()) != null) {
            this.pkgManager = RCore.getRPkgManager((REnv)rEnv);
            if (this.pkgManager != null) {
                this.pkgManagerListener = new IRPkgManager.Listener(){

                    public void handleChange(IRPkgManager.Event event) {
                        RObjectDB db;
                        IRPkgChangeSet changeSet;
                        if ((event.pkgsChanged() & 1) != 0 && (changeSet = event.getInstalledPkgChangeSet()) != null && !changeSet.getNames().isEmpty() && (db = RWorkspace.this.rObjectDB) != null) {
                            db.handleRPkgChange(changeSet.getNames());
                        }
                    }
                };
                this.pkgManager.addListener(this.pkgManagerListener);
            }
        }
        this.controlBriefChanged(null, 2);
    }

    public RProcess getProcess() {
        return (RProcess)super.getProcess();
    }

    private AbstractRController getController() {
        return (AbstractRController)this.getProcess().getController();
    }

    public IFileStore toFileStore(IPath toolPath) throws CoreException {
        if (!toolPath.isAbsolute() && toolPath.getDevice() == null && "~".equals(toolPath.segment(0))) {
            IPath homePath;
            AbstractRController controller = this.getController();
            if (controller != null && (homePath = this.createToolPath(controller.getProperty("R:file.~"))) != null) {
                return super.toFileStore(homePath.append(toolPath.removeFirstSegments(1)));
            }
            return null;
        }
        return super.toFileStore(toolPath);
    }

    public IFileStore toFileStore(String toolPath) throws CoreException {
        if (toolPath.startsWith("~/")) {
            return this.toFileStore(this.createToolPath(toolPath));
        }
        return super.toFileStore(toolPath);
    }

    public boolean hasRObjectDB() {
        return this.rObjectDBEnabled;
    }

    protected void enableRObjectDB(boolean enable) {
        this.rObjectDBEnabled = enable;
        if (enable) {
            AbstractRController controller = this.getController();
            if (controller != null) {
                controller.briefChanged(2);
            }
        } else {
            this.rObjectDB = null;
        }
    }

    private int getStamp() {
        AbstractRController controller = this.getController();
        return controller != null ? controller.getChangeStamp() : 0;
    }

    protected void controlBriefChanged(Object obj, int flags) {
        RElementName name;
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            for (Object child : collection) {
                this.controlBriefChanged(child, flags);
            }
            return;
        }
        if (obj instanceof RElementName && RElementName.isSearchScopeType((int)(name = (RElementName)obj).getType())) {
            this.changedEnvirs.add(name);
            return;
        }
        super.controlBriefChanged(obj, flags);
    }

    protected Changes saveChanges() {
        return new Changes(this.getChangeFlags(), !this.changedEnvirs.isEmpty() ? (Set)this.changedEnvirs.clone() : Collections.EMPTY_SET);
    }

    protected void restoreChanges(Changes changes) {
        super.controlBriefChanged(null, changes.changeFlags);
        this.changedEnvirs.addAll(changes.changedEnvirs);
    }

    private boolean hasBriefedChanges() {
        return this.getChangeFlags() != 0 || !this.changedEnvirs.isEmpty();
    }

    protected void clearBriefedChanges() {
        super.clearBriefedChanges();
        this.changedEnvirs.clear();
    }

    public List<? extends RProcessREnvironment> getRSearchEnvironments() {
        RObjectDB db = this.rObjectDB;
        return db != null ? db.getSearchEnvs() : null;
    }

    private boolean checkResolve(CombinedRElement resolved, int resolve) {
        int stamp;
        return (resolve & 2) == 0 || resolved instanceof REnvironmentVar && (stamp = this.getStamp()) != 0 && ((REnvironmentVar)resolved).getStamp() == stamp;
    }

    private CombinedRElement filterResolve(CombinedRElement resolved, int resolve) {
        return (resolve & 0x20) == 0 && resolved instanceof VirtualMissingVar ? null : resolved;
    }

    private CombinedRElement doResolve(RObjectDB db, RReference reference, int resolve) {
        REnvironmentVar resolved = db.getEnv(reference.getHandle());
        if (resolved != null ? this.checkResolve(resolved, resolve) : reference instanceof CombinedRElement && (resolved = db.getByName(((CombinedRElement)reference).getElementName())) != null && this.checkResolve(resolved, resolve)) {
            return resolved;
        }
        return null;
    }

    public CombinedRElement resolve(RReference reference, int resolve) {
        RObjectDB db = this.rObjectDB;
        if (db != null) {
            return this.filterResolve(this.doResolve(db, reference, resolve), resolve);
        }
        return null;
    }

    public CombinedRElement resolve(RElementName name, int resolve) {
        CombinedRElement resolved;
        RObjectDB db = this.rObjectDB;
        if (db != null && (resolved = db.getByName(name)) != null && this.checkResolve(resolved, resolve)) {
            return this.filterResolve(resolved, resolve);
        }
        return null;
    }

    public boolean isNamespaceLoaded(String name) {
        RObjectDB db = this.rObjectDB;
        return db != null && db.isNamespaceLoaded(name);
    }

    /*
     * Unable to fully structure code
     */
    public boolean isUptodate(CombinedRElement element) {
        block2: {
            controller = this.getController();
            if (controller == null) break block2;
            if (!(element instanceof VirtualMissingVar)) ** GOTO lbl10
            var = (VirtualMissingVar)element;
            return var.getSource() == controller.getTool() && var.getStamp() == controller.getChangeStamp();
lbl-1000:
            // 1 sources

            {
                if (element.getRObjectType() == 8) {
                    var = (REnvironmentVar)element;
                    return var.getSource() == controller.getTool() && var.getStamp() == controller.getChangeStamp();
                }
                element = element.getModelParent();
lbl10:
                // 2 sources

                ** while (element != null)
            }
        }
        return false;
    }

    public boolean isNA(CombinedRElement element) {
        return element instanceof VirtualMissingVar;
    }

    public CombinedRElement resolve(RReference reference, int resolve, int loadOptions, ProgressMonitor m) throws StatusException {
        CombinedRElement resolved;
        AbstractRController controller = this.getController();
        if (controller == null || !(controller instanceof ICombinedRDataAdapter)) {
            return null;
        }
        RObjectDB db = this.rObjectDB;
        if (db != null && (resolve & 4) == 0 && (resolved = this.doResolve(db, reference, resolve)) != null) {
            return this.filterResolve(resolved, resolve);
        }
        RReferenceVar ref = null;
        if (reference instanceof RReferenceVar && ((ref = (RReferenceVar)reference).getHandle() == 0L || !this.isUptodate(ref))) {
            ref = RWorkspace.verifyVar(RModel.getFQElementName((RElement)ref), (ICombinedRDataAdapter)((Object)controller), m);
        }
        if (ref == null) {
            return null;
        }
        if (db == null) {
            this.rObjectDB = db = new RObjectDB(this, controller.getChangeStamp() - 1000, controller, m);
        } else if (db.getLazyEnvsStamp() != controller.getChangeStamp()) {
            db.updateLazyEnvs(controller, m);
        }
        return db.resolve(ref, resolve, loadOptions, (ICombinedRDataAdapter)((Object)controller), m);
    }

    public CombinedRElement resolve(RElementName name, int resolve, int loadOptions, ProgressMonitor m) throws StatusException {
        RReferenceVar ref;
        CombinedRElement resolved;
        AbstractRController controller = this.getController();
        if (controller == null || !(controller instanceof ICombinedRDataAdapter)) {
            return null;
        }
        RObjectDB db = this.rObjectDB;
        if ((resolve & 4) == 0 && db != null && (resolved = db.getByName(name)) != null && this.checkResolve(resolved, resolve)) {
            return this.filterResolve(resolved, resolve);
        }
        if (name.getNextSegment() == null && name.getType() == 33) {
            ref = new RReferenceVar(0L, 8, "environment", null, name);
        } else {
            REnvironmentVar resolved2;
            ref = RWorkspace.verifyVar(name, (ICombinedRDataAdapter)((Object)controller), m);
            if (ref != null && db != null && (resolved2 = db.getEnv(ref.getHandle())) != null && this.checkResolve(resolved2, resolve)) {
                return this.filterResolve(resolved2, resolve);
            }
        }
        if (ref == null) {
            return null;
        }
        if (db == null) {
            this.rObjectDB = db = new RObjectDB(this, controller.getChangeStamp() - 1000, controller, m);
        } else if (db.getLazyEnvsStamp() != controller.getChangeStamp()) {
            db.updateLazyEnvs(controller, m);
        }
        return db.resolve(ref, resolve, loadOptions, (ICombinedRDataAdapter)((Object)controller), m);
    }

    public boolean isRObjectDBDirty() {
        return this.autoRefreshDirty;
    }

    protected final void autoRefreshFromTool(ConsoleService adapter, ProgressMonitor m) throws StatusException {
        AbstractRController controller = this.getController();
        if (this.hasBriefedChanges() || controller.isSuspended()) {
            this.refreshFromTool(controller, this.getChangeFlags(), m);
        }
    }

    protected final void refreshFromTool(int options, ConsoleService adapter, ProgressMonitor m) throws StatusException {
        AbstractRController controller = this.getController();
        if ((options & 3) != 0) {
            options |= this.getChangeFlags();
        }
        this.refreshFromTool(controller, options, m);
    }

    protected void refreshFromTool(AbstractRController controller, int options, ProgressMonitor m) throws StatusException {
        boolean dirty;
        m.beginSubTask("Update Workspace Data");
        if (controller.getTool().isProvidingFeatureSet("org.eclipse.statet.r.data")) {
            IRDataAdapter r = (IRDataAdapter)((Object)controller);
            this.updateWorkspaceDir(r, m);
            this.updateOptions(r, m);
            if (this.rObjectDBEnabled) {
                HashSet<RElementName> elements = this.changedEnvirs;
                if ((options & 2) != 0 || ((options & 1) != 0 || !elements.isEmpty() || controller.isSuspended()) && this.isAutoRefreshEnabled()) {
                    this.updateREnvironments(elements, (options & 2) != 0, r, m);
                    this.clearBriefedChanges();
                }
            } else {
                this.clearBriefedChanges();
            }
        } else {
            this.clearBriefedChanges();
        }
        boolean bl = dirty = !this.isAutoRefreshEnabled() && this.hasBriefedChanges();
        if (dirty != this.autoRefreshDirty) {
            this.autoRefreshDirty = dirty;
            this.addPropertyChanged("RObjectDB.dirty", dirty);
        }
    }

    private void updateWorkspaceDir(IRDataAdapter r, ProgressMonitor m) throws StatusException {
        RObject rWd = r.evalData("getwd()", m);
        if (RDataUtils.isSingleChar((RObject)rWd)) {
            String wd = rWd.getData().getChar(0);
            if (!this.isRemote()) {
                this.controlSetWorkspaceDir(EFS.getLocalFileSystem().getStore(this.createToolPath(wd)));
            } else {
                this.controlSetRemoteWorkspaceDir(this.createToolPath(wd));
            }
        }
    }

    private void updateOptions(IRDataAdapter r, ProgressMonitor m) throws StatusException {
        RObject rContinue;
        RList rOptions = (RList)r.evalData("options(\"prompt\", \"continue\")", m);
        RObject rPrompt = rOptions.get("prompt");
        if (RDataUtils.isSingleChar((RObject)rPrompt) && !rPrompt.getData().isNA(0)) {
            ((AbstractRController)((Object)r)).setDefaultPromptTextL(rPrompt.getData().getChar(0));
        }
        if (RDataUtils.isSingleChar((RObject)(rContinue = rOptions.get("continue"))) && !rContinue.getData().isNA(0)) {
            ((AbstractRController)((Object)r)).setContinuePromptText(rContinue.getData().getChar(0));
        }
    }

    private void updateREnvironments(Set<RElementName> envirs, boolean force, IRDataAdapter r, ProgressMonitor m) throws StatusException {
        if (!(r instanceof ICombinedRDataAdapter)) {
            return;
        }
        AbstractRController controller = this.getController();
        RObjectDB previous = this.rObjectDB;
        if (!(force |= previous == null || previous.getSearchEnvs() == null) && previous.getSearchEnvsStamp() == controller.getChangeStamp() && envirs.isEmpty()) {
            return;
        }
        RObjectDB db = new RObjectDB(this, controller.getChangeStamp(), controller, m);
        List<REnvironmentVar> updateEnvs = db.update(envirs, previous, force, (ICombinedRDataAdapter)r, m);
        if (m.isCanceled()) {
            return;
        }
        this.rObjectDB = db;
        this.addPropertyChanged("REnvironments", updateEnvs);
    }

    protected void dispose() {
        if (this.pkgManagerListener != null) {
            this.pkgManager.removeListener(this.pkgManagerListener);
            this.pkgManagerListener = null;
        }
        super.dispose();
        this.rObjectDB = null;
    }

    protected static final class Changes {
        private final int changeFlags;
        private final Set<RElementName> changedEnvirs;

        public Changes(int changeFlags, Set<RElementName> changedEnvirs) {
            this.changeFlags = changeFlags;
            this.changedEnvirs = changedEnvirs;
        }
    }
}

