/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

@NonNullByDefault
public abstract class AbstractToolScopeHandler<TTool extends Tool>
extends AbstractScopeHandler {
    private final ActiveToolListener toolListener = this::onToolChanged;
    private @Nullable ToolProvider toolProvider;
    private @Nullable TTool currentTool;

    public AbstractToolScopeHandler(Object scope, @Nullable String commandId) {
        this.init(scope, commandId);
    }

    protected void init(Object scope, @Nullable String commandId) {
        IWorkbenchPage workbenchPage;
        super.init(scope, commandId);
        ToolProvider toolProvider = null;
        if (scope instanceof ToolProvider) {
            toolProvider = (ToolProvider)scope;
        } else if (scope instanceof IWorkbenchWindow && (workbenchPage = ((IWorkbenchWindow)scope).getActivePage()) != null) {
            toolProvider = NicoUI.getToolRegistry().getToolProvider(workbenchPage);
        }
        if (toolProvider != null) {
            this.toolProvider = toolProvider;
            toolProvider.addToolListener(this.toolListener);
        }
    }

    public void dispose() {
        ToolProvider toolProvider = this.toolProvider;
        if (toolProvider != null) {
            this.toolProvider = null;
            toolProvider.removeToolListener(this.toolListener);
        }
        super.dispose();
    }

    protected @Nullable Tool getTool(@Nullable IEvaluationContext evalContext) {
        Object scope = this.getScope();
        if (scope instanceof ToolProvider) {
            return ((ToolProvider)scope).getTool();
        }
        return null;
    }

    private void onToolChanged(ActiveToolListener.ActiveToolEvent event) {
        if (this.toolProvider != null) {
            this.setEnabled(null);
        }
    }

    protected @Nullable TTool getCurrentTool(@Nullable IEvaluationContext evalContext) {
        Tool tool = this.getTool(evalContext);
        Tool currentTool = tool == this.currentTool || tool != null && this.isSupported(tool) ? tool : null;
        this.currentTool = currentTool;
        return (TTool)currentTool;
    }

    protected boolean isSupported(Tool tool) {
        return true;
    }

    protected boolean evaluateIsEnabled(TTool tool) {
        return true;
    }

    public void setEnabled(@Nullable IEvaluationContext context) {
        TTool currentTool = this.getCurrentTool(context);
        this.setBaseEnabled(currentTool != null && this.evaluateIsEnabled(currentTool));
    }

    public @Nullable Object execute(ExecutionEvent event, IEvaluationContext evalContext) throws ExecutionException {
        TTool currentTool = this.getCurrentTool(evalContext);
        if (currentTool != null && this.evaluateIsEnabled(currentTool)) {
            return this.execute(event, currentTool, evalContext);
        }
        return null;
    }

    public abstract @Nullable Object execute(ExecutionEvent var1, TTool var2, IEvaluationContext var3) throws ExecutionException;
}

