/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.source;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.docmlet.wikitext.core.ast.Block;
import org.eclipse.statet.docmlet.wikitext.core.ast.Control;
import org.eclipse.statet.docmlet.wikitext.core.ast.Heading;
import org.eclipse.statet.docmlet.wikitext.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.wikitext.core.ast.Span;
import org.eclipse.statet.docmlet.wikitext.core.ast.Text;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupSourceFormatAdapter;
import org.eclipse.statet.docmlet.wikitext.core.source.doc.WikidocDocumentSetupParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.ExtdocMarkupLanguage;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class HardLineWrap {
    public static final byte SELECTION_STRICT = 1;
    public static final byte SELECTION_WITH_TAIL = 2;
    public static final byte SELECTION_MERGE1 = 3;
    public static final byte SELECTION_MERGE = 4;
    public static final byte PARAGRAPH = 5;
    private final DocContentSections documentContentInfo;
    private final WikitextCoreAccess wikitextCoreAccess;

    public HardLineWrap(DocContentSections documentContentInfo, WikitextCoreAccess coreAccess) {
        this.documentContentInfo = documentContentInfo;
        this.wikitextCoreAccess = coreAccess;
    }

    public WikitextCoreAccess getWikitextCoreAccess() {
        return this.wikitextCoreAccess;
    }

    public void addTextEdits(IDocument document, SourceComponent sourceNode, TextRegion region, byte mode, MarkupSourceFormatAdapter formatAdapter, TextEdit rootEdit, IndentUtil indentUtil) throws Exception {
        if (indentUtil != null) {
            if (indentUtil.getDocument() != document) {
                throw new IllegalArgumentException("indentUtil.document != document");
            }
        } else {
            indentUtil = new IndentUtil(document, (IIndentSettings)this.wikitextCoreAccess.getWikitextCodeStyle());
        }
        Task task = new Task(mode, document, region, formatAdapter, sourceNode, this.wikitextCoreAccess.getWikitextCodeStyle().getLineWidth(), indentUtil);
        task.collect();
        this.processBlocks(task, rootEdit);
    }

    public TextEdit createTextEdit(IDocument document, SourceComponent sourceNode, TextRegion region, byte mode, MarkupSourceFormatAdapter formatAdapter, IndentUtil indentUtil) throws Exception {
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.addTextEdits(document, sourceNode, region, mode, formatAdapter, (TextEdit)rootEdit, indentUtil);
        return rootEdit.getChildrenSize() > 0 ? rootEdit : null;
    }

    public void addTextEdits(IDocument document, AstInfo ast, TextRegion region, byte mode, TextEdit rootEdit, IndentUtil indentUtil) throws Exception {
        MarkupSourceFormatAdapter formatAdapter;
        ExtdocMarkupLanguage markupLanguage = this.getMarkupLanguage(document);
        if (markupLanguage == null || (formatAdapter = markupLanguage.getSourceFormatAdapter()) == null || !(ast.getRoot() instanceof SourceComponent)) {
            return;
        }
        this.addTextEdits(document, (SourceComponent)ast.getRoot(), region, mode, formatAdapter, rootEdit, indentUtil);
    }

    public TextEdit createTextEdit(IDocument document, AstInfo ast, TextRegion region, byte mode, IndentUtil indentUtil) throws Exception {
        MultiTextEdit rootEdit = new MultiTextEdit();
        this.addTextEdits(document, ast, region, mode, (TextEdit)rootEdit, indentUtil);
        return rootEdit.getChildrenSize() > 0 ? rootEdit : null;
    }

    protected final ExtdocMarkupLanguage getMarkupLanguage(IDocument document) {
        WikitextMarkupLanguage markupLanguage = WikidocDocumentSetupParticipant.getMarkupLanguage(document, this.documentContentInfo.getPartitioning());
        return markupLanguage instanceof ExtdocMarkupLanguage ? (ExtdocMarkupLanguage)markupLanguage : null;
    }

    /*
     * Unable to fully structure code
     */
    private void processBlocks(Task task, TextEdit rootEdit) throws BadLocationException {
        block0: for (BlockData blockData : task.blocks) {
            lineWrap = null;
            lineWrapColumns = -1;
            openOffset = -1;
            beginColumn = -1;
            endColumn = -1;
            lastChange = 1;
            lineInRegion = true;
            for (LineData lineData : blockData.lines) {
                block9: {
                    if (lineInRegion) {
                        lineInRegion = lineData.startOffset < task.region.getEndOffset();
                    } else if (task.mode <= 4 && lastChange == 0) break block0;
                    if (!lineInRegion && task.mode <= 3 && lastChange <= 1) break block0;
                    textRegion = task.trimText(lineData);
                    textIdx = textRegion.getOffset();
                    textEndIdx = textRegion.getOffset() + textRegion.getLength();
                    remainingSource = lineData.textSource;
                    br = null;
                    if (openOffset < 0 || (br = task.getBreak(lineData, textIdx, textEndIdx, endColumn + 1, false)) == null) break block9;
                    if (task.mode <= 2 && !this.isInRegion(task.region, lineData.startOffset + textRegion.getOffset())) break block0;
                    if (task.document.getChar(openOffset) == ' ') {
                        rootEdit.addChild((TextEdit)new DeleteEdit(openOffset + 1, lineData.startOffset - openOffset - 1));
                    } else {
                        rootEdit.addChild((TextEdit)new ReplaceEdit(openOffset, lineData.startOffset - openOffset, " "));
                    }
                    beginColumn = endColumn + 1;
                    endColumn = task.indentUtil.getColumn((CharSequence)remainingSource, textEndIdx - textIdx, beginColumn);
                    lastChange = 1;
                    ** GOTO lbl51
                }
                beginColumn = task.indentUtil.getColumn(lineData.startOffset + textIdx);
                endColumn = task.indentUtil.getColumn((CharSequence)remainingSource, textEndIdx - textIdx, beginColumn);
                lastChange = 0;
                if (beginColumn < task.lineWidth) ** GOTO lbl51
                openOffset = -1;
                continue;
lbl-1000:
                // 1 sources

                {
                    if (br == null) {
                        br = task.getBreak(lineData, textIdx, textEndIdx, beginColumn, true);
                    }
                    if (br == null || br.getLength() == 0) break;
                    if (task.mode <= 1 && !this.isInRegion(task.region, lineData.startOffset + br.getOffset())) break block0;
                    if (lineWrap == null) {
                        lineWrapColumns = task.indentUtil.getColumn((CharSequence)blockData.indentCont, blockData.indentCont.length());
                        lineWrap = String.valueOf(TextUtilities.getDefaultLineDelimiter((IDocument)task.document)) + blockData.indentCont;
                    }
                    rootEdit.addChild((TextEdit)new ReplaceEdit(lineData.startOffset + br.getOffset(), br.getLength(), lineWrap));
                    textIdx = br.getOffset() + br.getLength();
                    remainingSource = lineData.textSource.substring(textIdx);
                    beginColumn = lineWrapColumns;
                    endColumn = task.indentUtil.getColumn((CharSequence)remainingSource, textEndIdx - textIdx, beginColumn);
                    lastChange = 2;
                    br = null;
lbl51:
                    // 3 sources

                    ** while (endColumn > task.lineWidth)
                }
lbl52:
                // 2 sources

                v0 = openOffset = endColumn < task.lineWidth && lineData.end != 1 ? lineData.startOffset + textEndIdx : -1;
            }
        }
    }

    private boolean isInRegion(TextRegion region, int offset) {
        return offset >= region.getStartOffset() && offset < region.getEndOffset();
    }

    private static final class BlockData {
        private final Block node;
        private final ImList<LineData> lines;
        private final String indentCont;

        public BlockData(Block node, ImList<LineData> lines, String indentCont) {
            this.node = node;
            this.lines = lines;
            this.indentCont = indentCont;
        }
    }

    private static final class LineData {
        private static final byte HARD_LINE_BREAK = 1;
        private final int startOffset;
        private final int endOffset;
        private final String textSource;
        private final List<Text> textNodes;
        private byte end;

        public LineData(int startOffset, int endOffset, String textSource) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.textSource = textSource;
            this.textNodes = new ArrayList<Text>(8);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            sb.append(this.startOffset);
            sb.append(", ");
            sb.append(this.endOffset);
            sb.append("): ");
            sb.append(this.textSource);
            return sb.toString();
        }
    }

    private static final class Task
    extends WikitextAstVisitor {
        private final byte mode;
        private final IDocument document;
        private final MarkupSourceFormatAdapter formatAdapter;
        private final SourceComponent sourceNode;
        private final TextRegion region;
        private final List<BlockData> blocks = new ArrayList<BlockData>();
        private boolean createLineContent;
        private final List<LineData> lines = new ArrayList<LineData>();
        private int currentLineIdx;
        private final int lineWidth;
        private final IndentUtil indentUtil;
        private static final byte TEXT = 0;
        private static final byte ESCAPE = 1;
        private static final byte BREAK = 2;

        public Task(byte mode, IDocument document, TextRegion region, MarkupSourceFormatAdapter sourceAdapter, SourceComponent sourceNode, int lineWidth, IndentUtil indentUtil) {
            this.mode = mode;
            this.document = document;
            this.formatAdapter = sourceAdapter;
            this.sourceNode = sourceNode;
            this.region = region;
            this.lineWidth = lineWidth;
            this.indentUtil = indentUtil;
        }

        @Override
        public void visit(Block node) throws InvocationTargetException {
            if (this.createLineContent || !this.region.intersectsNonEmpty((TextRegion)node)) {
                return;
            }
            switch (node.getBlockType()) {
                case PARAGRAPH: {
                    this.createTextBlockNode(node);
                    return;
                }
                case QUOTE: 
                case NUMERIC_LIST: 
                case BULLETED_LIST: 
                case LIST_ITEM: 
                case DEFINITION_LIST: 
                case DEFINITION_ITEM: {
                    node.acceptInWikitextChildren(this);
                    return;
                }
            }
        }

        private void createTextBlockNode(Block node) throws InvocationTargetException {
            try {
                try {
                    ImList<? extends TextRegion> textRegions = node.getTextRegions();
                    int i = 0;
                    while (i < textRegions.size()) {
                        TextRegion textRegion = (TextRegion)textRegions.get(i);
                        if (textRegion.getEndOffset() > this.region.getStartOffset()) break;
                        ++i;
                    }
                    while (i < textRegions.size()) {
                        String indentCont;
                        this.lines.clear();
                        int line = Integer.MIN_VALUE;
                        while (i < textRegions.size()) {
                            TextRegion textRegion = (TextRegion)textRegions.get(i);
                            if (this.mode >= 3 || this.region.intersectsNonEmpty(textRegion)) {
                                int currentLine = this.document.getLineOfOffset(textRegion.getStartOffset());
                                if (line != Integer.MIN_VALUE && currentLine - line > 1) break;
                                line = currentLine;
                                this.lines.add(new LineData(textRegion.getStartOffset(), textRegion.getEndOffset(), this.document.get(textRegion.getStartOffset(), textRegion.getLength())));
                                ++i;
                                continue;
                            }
                            i = Integer.MAX_VALUE;
                            break;
                        }
                        if (this.lines.isEmpty() || (indentCont = this.getBlockWrapIndent(node)) == null) continue;
                        this.createLineContent = true;
                        this.currentLineIdx = 0;
                        node.acceptInWikitextChildren(this);
                        this.blocks.add(new BlockData(node, (ImList<LineData>)ImCollections.toList(this.lines), indentCont));
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                this.createLineContent = false;
            }
        }

        @Override
        public void visit(Heading node) throws InvocationTargetException {
        }

        @Override
        public void visit(Span node) throws InvocationTargetException {
            if (!this.createLineContent) {
                return;
            }
            switch (node.getSpanType()) {
                case CODE: {
                    return;
                }
            }
            node.acceptInWikitextChildren(this);
        }

        @Override
        public void visit(Text node) throws InvocationTargetException {
            if (!this.createLineContent) {
                return;
            }
            if (node.getLength() > 0) {
                while (this.currentLineIdx < this.lines.size()) {
                    LineData lineData = this.lines.get(this.currentLineIdx);
                    if (node.getEndOffset() <= lineData.startOffset) {
                        return;
                    }
                    if (node.getStartOffset() < lineData.endOffset) {
                        lineData.textNodes.add(node);
                    }
                    if (node.getEndOffset() <= lineData.endOffset) break;
                    ++this.currentLineIdx;
                }
            }
        }

        @Override
        public void visit(Control node) throws InvocationTargetException {
            if (!this.createLineContent) {
                return;
            }
            if (node.getText() == "\n") {
                while (this.currentLineIdx < this.lines.size()) {
                    LineData lineData = this.lines.get(this.currentLineIdx);
                    if (node.getEndOffset() <= lineData.startOffset) {
                        return;
                    }
                    if (node.getStartOffset() < lineData.endOffset) {
                        lineData.end = 1;
                        break;
                    }
                    ++this.currentLineIdx;
                }
            }
        }

        public void collect() throws Exception {
            try {
                this.sourceNode.acceptInWikitextChildren(this);
                if (this.blocks.isEmpty()) {
                    return;
                }
            }
            catch (InvocationTargetException e) {
                throw (Exception)e.getTargetException();
            }
        }

        private String getBlockWrapIndent(Block node) throws Exception {
            return this.formatAdapter.getPrefixCont(node, this.indentUtil);
        }

        private IRegion trimText(LineData lineData) {
            int beginIdx = 0;
            int endIdx = lineData.endOffset - lineData.startOffset;
            block12: while (endIdx > beginIdx) {
                switch (lineData.textSource.charAt(endIdx - 1)) {
                    case '\n': 
                    case '\r': {
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                --endIdx;
            }
            if (!lineData.textNodes.isEmpty()) {
                int bound;
                Text node = lineData.textNodes.get(0);
                if (node.getStartOffset() <= lineData.startOffset) {
                    bound = Math.min(node.getEndOffset() - lineData.startOffset, endIdx);
                    block13: while (beginIdx < bound) {
                        switch (lineData.textSource.charAt(beginIdx)) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            default: {
                                break block13;
                            }
                        }
                        ++beginIdx;
                    }
                }
                if ((node = lineData.textNodes.get(lineData.textNodes.size() - 1)).getEndOffset() >= lineData.endOffset) {
                    bound = Math.max(node.getStartOffset() - lineData.startOffset, beginIdx);
                    int savedOffset = endIdx;
                    block14: while (endIdx > bound) {
                        switch (lineData.textSource.charAt(endIdx - 1)) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            default: {
                                break block14;
                            }
                        }
                        --endIdx;
                    }
                    if (endIdx < savedOffset) {
                        int count = 0;
                        block15: while (endIdx - count > bound) {
                            switch (lineData.textSource.charAt(endIdx - count - 1)) {
                                case '\\': {
                                    break;
                                }
                                default: {
                                    break block15;
                                }
                            }
                            ++count;
                        }
                        if (count % 2 == 1) {
                            ++endIdx;
                        }
                    }
                }
            }
            return new Region(beginIdx, endIdx - beginIdx);
        }

        private IRegion getBreak(LineData lineData, int beginIdx, int endIdx, int beginColumn, boolean fallback) {
            int brIdx = -1;
            int brLength = 0;
            int state = 0;
            int chIdx = beginIdx;
            int column = beginColumn;
            while (chIdx < endIdx && (column <= this.lineWidth || fallback && brIdx < 0)) {
                switch (lineData.textSource.charAt(chIdx)) {
                    case ' ': {
                        if (this.isTextOffset(lineData, chIdx)) {
                            switch (state) {
                                case 0: {
                                    brIdx = chIdx;
                                    brLength = 1;
                                    state = 2;
                                    break;
                                }
                                case 1: {
                                    state = 0;
                                    break;
                                }
                                case 2: {
                                    ++brLength;
                                }
                            }
                        } else {
                            state = 0;
                        }
                        ++column;
                        break;
                    }
                    case '\t': {
                        if (this.isTextOffset(lineData, chIdx)) {
                            switch (state) {
                                case 0: {
                                    brIdx = chIdx;
                                    brLength = 1;
                                    state = 2;
                                    break;
                                }
                                case 1: {
                                    state = 0;
                                    break;
                                }
                                case 2: {
                                    ++brLength;
                                }
                            }
                        } else {
                            state = 0;
                        }
                        column += this.indentUtil.getTabWidth() - column % this.indentUtil.getTabWidth();
                        break;
                    }
                    case '\\': {
                        if (this.isTextOffset(lineData, chIdx)) {
                            switch (state) {
                                case 1: {
                                    state = 0;
                                    break;
                                }
                                default: {
                                    state = 1;
                                    break;
                                }
                            }
                        } else {
                            state = 0;
                        }
                        ++column;
                        break;
                    }
                    default: {
                        state = 0;
                        ++column;
                    }
                }
                ++chIdx;
            }
            if (chIdx == endIdx && column <= this.lineWidth) {
                return new Region(endIdx, 0);
            }
            return brIdx >= 0 ? new Region(brIdx, brLength) : null;
        }

        private boolean isTextOffset(LineData lineData, int chIdx) {
            int offset = lineData.startOffset + chIdx;
            for (Text node : lineData.textNodes) {
                if (node.getStartOffset() > offset) break;
                if (node.getEndOffset() <= offset) continue;
                return true;
            }
            return false;
        }
    }
}

