/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.coordinate;

import org.eclipse.statet.ecommons.waltable.core.layer.Layer;

public final class PositionCoordinate {
    private final Layer layer;
    public long columnPosition;
    public long rowPosition;

    public PositionCoordinate(Layer layer, long columnPosition, long rowPosition) {
        this.layer = layer;
        this.columnPosition = columnPosition;
        this.rowPosition = rowPosition;
    }

    public PositionCoordinate(PositionCoordinate coordinate) {
        this.layer = coordinate.layer;
        this.columnPosition = coordinate.columnPosition;
        this.rowPosition = coordinate.rowPosition;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public long getColumnPosition() {
        return this.columnPosition;
    }

    public long getRowPosition() {
        return this.rowPosition;
    }

    public void set(long rowPosition, long columnPosition) {
        this.rowPosition = rowPosition;
        this.columnPosition = columnPosition;
    }

    public int hashCode() {
        int h = (int)(this.columnPosition ^ this.columnPosition >>> 32);
        h = Integer.rotateRight(h, 15);
        return this.layer.hashCode() + ((h ^= (int)(this.rowPosition ^ this.rowPosition)) ^ h >>> 7);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PositionCoordinate)) {
            return false;
        }
        PositionCoordinate other = (PositionCoordinate)obj;
        return this.layer == other.layer && this.columnPosition == other.columnPosition && this.rowPosition == other.rowPosition;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.layer + ":" + this.columnPosition + "," + this.rowPosition + "]";
    }
}

