/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.rmodel;

import java.util.List;
import org.eclipse.statet.internal.r.core.rmodel.BuildSourceFrame;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.source.SourceModelStamp;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceContainerElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.r.core.rmodel.RElement;
import org.eclipse.statet.r.core.rmodel.RElementName;
import org.eclipse.statet.r.core.rmodel.RFrame;
import org.eclipse.statet.r.core.rmodel.RLangSourceElement;
import org.eclipse.statet.r.core.rmodel.RSourceUnit;

@NonNullByDefault
abstract class RSourceFileElement
implements RLangSourceElement,
SourceContainerElement<RLangSourceElement> {
    private final RSourceUnit sourceUnit;
    private final SourceModelStamp stamp;
    protected final BuildSourceFrame envir;

    public RSourceFileElement(RSourceUnit sourceUnit, SourceModelStamp stamp, BuildSourceFrame envir) {
        this.sourceUnit = sourceUnit;
        this.stamp = stamp;
        this.envir = envir;
    }

    public final String getModelTypeId() {
        return "R";
    }

    public int getElementType() {
        return 528;
    }

    @Override
    public RElementName getElementName() {
        ElementName elementName = this.sourceUnit.getElementName();
        if (elementName instanceof RElementName) {
            return (RElementName)elementName;
        }
        return RElementName.create(2, elementName.getSegmentName());
    }

    public String getId() {
        return this.sourceUnit.getId();
    }

    public boolean exists() {
        SourceUnitModelInfo modelInfo = this.getSourceUnit().getModelInfo("R", 0, null);
        return modelInfo != null && modelInfo.getSourceElement() == this;
    }

    public boolean isReadOnly() {
        return this.sourceUnit.isReadOnly();
    }

    @Override
    public @Nullable RElement<?> getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return false;
    }

    @Override
    public List<? extends RLangSourceElement> getModelChildren(@Nullable LtkModelElementFilter<? super RLangSourceElement> filter) {
        return ImCollections.emptyList();
    }

    public @Nullable SourceStructElement<?, ?> getSourceParent() {
        return null;
    }

    @Override
    public RSourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public SourceModelStamp getStamp() {
        return this.stamp;
    }

    public @Nullable TextRegion getNameSourceRange() {
        return null;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RFrame.class) {
            return (T)this.envir;
        }
        return null;
    }

    public int hashCode() {
        return this.sourceUnit.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SourceStructElement) {
            SourceStructElement other = (SourceStructElement)obj;
            return (other.getElementType() & 0xFF0) == 528 && this.sourceUnit.equals(other.getSourceUnit());
        }
        return false;
    }
}

