/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.ruby.core.RubyLanguageToolkit;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinAlias;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyObjectMixinClass;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;

public class RubyMixinModel {
    private static RubyMixinModel instance;
    private final MixinModel model = new MixinModel(RubyLanguageToolkit.getDefault());

    public static RubyMixinModel getInstance() {
        if (instance == null) {
            instance = new RubyMixinModel();
        }
        return instance;
    }

    public static MixinModel getRawInstance() {
        return RubyMixinModel.getInstance().getRawModel();
    }

    private RubyMixinModel() {
    }

    public MixinModel getRawModel() {
        return this.model;
    }

    public RubyMixinClass createRubyClass(RubyClassType type) {
        return (RubyMixinClass)this.createRubyElement(type.getModelKey());
    }

    public IRubyMixinElement createRubyElement(String key) {
        if (key.equals("Object")) {
            return new RubyObjectMixinClass(this, true);
        }
        if (key.equals("Object%")) {
            return new RubyObjectMixinClass(this, false);
        }
        IMixinElement mixinElement = this.model.get(key);
        if (mixinElement != null) {
            return this.createRubyElement(mixinElement);
        }
        return null;
    }

    public IRubyMixinElement createRubyElement(IMixinElement element) {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        if (element.getKey().equals("Object")) {
            return new RubyObjectMixinClass(this, true);
        }
        if (element.getKey().equals("Object%")) {
            return new RubyObjectMixinClass(this, false);
        }
        Object[] objects = element.getAllObjects();
        if (objects == null) {
            return null;
        }
        int i = 0;
        while (i < objects.length) {
            RubyMixinElementInfo obj = (RubyMixinElementInfo)objects[i];
            if (obj != null && obj.getObject() != null) {
                switch (obj.getKind()) {
                    case 0: 
                    case 5: 
                    case 6: {
                        return new RubyMixinClass(this, element.getKey(), false);
                    }
                    case 1: {
                        return new RubyMixinClass(this, element.getKey(), true);
                    }
                    case 2: {
                        return new RubyMixinMethod(this, element.getKey());
                    }
                    case 7: {
                        return new RubyMixinAlias(this, element.getKey());
                    }
                    case 3: {
                        return new RubyMixinVariable(this, element.getKey());
                    }
                }
            }
            ++i;
        }
        return null;
    }
}

