/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parsers.jruby;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.ruby.internal.parsers.jruby.DLTKRubyNullWarnings;
import org.eclipse.dltk.ruby.internal.parsers.jruby.DLTKRubyWarnings;
import org.eclipse.dltk.ruby.internal.parsers.jruby.IDLTKRubyWarnings;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;

public class DLTKRubyParser {
    private boolean success;
    private RubyParserResult result = null;

    public RubyParserResult getParserResult() {
        return this.result;
    }

    public Node parse(String file, String content, IProblemReporter problemReporter) {
        return this.parse(file, new StringReader(content), problemReporter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node parse(String file, Reader content, IProblemReporter problemReporter) {
        RubyParserConfiguration configuration = new RubyParserConfiguration();
        DefaultRubyParser parser = null;
        this.success = false;
        IDLTKRubyWarnings warnings = problemReporter == null ? new DLTKRubyNullWarnings() : new DLTKRubyWarnings(problemReporter);
        try {
            try {
                parser = RubyParserPool.getInstance().borrowParser();
                parser.setWarnings(warnings);
                LexerSource lexerSource = LexerSource.getSource(file, content);
                this.result = parser.parse(configuration, lexerSource);
                if (this.result.isEndSeen()) {
                    this.result.setEndSeen(false);
                }
                this.success = true;
            }
            catch (SyntaxException e) {
                ISourcePosition position = e.getPosition();
                if (position.getStartOffset() == position.getEndOffset() && position.getStartOffset() > 0) {
                    position.adjustStartOffset(-1);
                }
                warnings.error(position, e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            RubyParserPool.getInstance().returnParser(parser);
            throw throwable;
        }
        {
            Object var9_12 = null;
            RubyParserPool.getInstance().returnParser(parser);
            if (this.result != null) {
                this.result.addAppendBeginNodes();
                return this.result.getAST();
            }
            return null;
        }
    }

    public boolean isSuccess() {
        return this.success;
    }
}

